/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

public class Base64 {
    public static final int BASE64DEFAULTLENGTH = 76;
    static int _base64length;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    private Base64() {
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 76);
    }

    protected static final boolean isWhiteSpace(byte by) {
        return by == 32 || by == 13 || by == 10 || by == 9;
    }

    protected static final boolean isPad(byte by) {
        return by == 61;
    }

    protected static final String encode(byte[] byArray, int n) {
        byte by;
        int n2;
        int n3;
        if (n < 4) {
            n = Integer.MAX_VALUE;
        }
        if (byArray == null) {
            return null;
        }
        int n4 = byArray.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = n / 4;
        int n9 = (n7 - 1) / n8;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n9];
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (n3 = 0; n3 < n9; ++n3) {
            for (n2 = 0; n2 < 19; ++n2) {
                by4 = byArray[n11++];
                by5 = byArray[n11++];
                by6 = byArray[n11++];
                by3 = (byte)(by5 & 0xF);
                by2 = (byte)(by4 & 3);
                by = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
                byte by7 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
                cArray[n10++] = lookUpBase64Alphabet[by];
                cArray[n10++] = lookUpBase64Alphabet[by7 | by2 << 4];
                cArray[n10++] = lookUpBase64Alphabet[by3 << 2 | by8];
                cArray[n10++] = lookUpBase64Alphabet[by6 & 0x3F];
                ++n12;
            }
            cArray[n10++] = 10;
        }
        while (n12 < n6) {
            by4 = byArray[n11++];
            by5 = byArray[n11++];
            by6 = byArray[n11++];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by3 << 2 | by];
            cArray[n10++] = lookUpBase64Alphabet[by6 & 0x3F];
            ++n12;
        }
        if (n5 == 8) {
            by4 = byArray[n11];
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[by2 << 4];
            cArray[n10++] = 61;
            cArray[n10++] = 61;
        } else if (n5 == 16) {
            by4 = byArray[n11];
            by5 = byArray[n11 + 1];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by3 << 2];
            cArray[n10++] = 61;
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        return Base64.decodeInternal(string.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final byte[] decodeInternal(byte[] byArray) {
        int n = Base64.removeWhiteSpace(byArray);
        if (n % 4 != 0) {
            throw new IllegalArgumentException("decoding.divisible.four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n5 = (n2 - 1) * 4;
        n4 = (n2 - 1) * 3;
        by = base64Alphabet[byArray[n5++]];
        by2 = base64Alphabet[byArray[n5++]];
        if (by == -1 || by2 == -1) {
            throw new IllegalArgumentException("decoding.general");
        }
        byte by5 = byArray[n5++];
        by3 = base64Alphabet[by5];
        byte by6 = byArray[n5++];
        by4 = base64Alphabet[by6];
        if (by3 == -1 || by4 == -1) {
            if (Base64.isPad(by5) && Base64.isPad(by6)) {
                if ((by2 & 0xF) != 0) {
                    throw new IllegalArgumentException("decoding.general");
                }
                byArray2 = new byte[n4 + 1];
                byArray2[n4] = (byte)(by << 2 | by2 >> 4);
            } else {
                if (Base64.isPad(by5) || !Base64.isPad(by6)) throw new IllegalArgumentException("decoding.general");
                if ((by3 & 3) != 0) {
                    throw new IllegalArgumentException("decoding.general");
                }
                byArray2 = new byte[n4 + 2];
                byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
                byArray2[n4] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            }
        } else {
            byArray2 = new byte[n4 + 3];
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
        }
        n4 = 0;
        n5 = 0;
        for (n3 = n2 - 1; n3 > 0; --n3) {
            by = base64Alphabet[byArray[n5++]];
            by2 = base64Alphabet[byArray[n5++]];
            by3 = base64Alphabet[byArray[n5++]];
            by4 = base64Alphabet[byArray[n5++]];
            if (by == -1 || by2 == -1 || by3 == -1 || by4 == -1) {
                throw new IllegalArgumentException("decoding.general");
            }
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
        }
        return byArray2;
    }

    protected static int removeWhiteSpace(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        for (byte by : byArray) {
            if (Base64.isWhiteSpace(by)) continue;
            byArray[n++] = by;
        }
        return n;
    }

    static {
        int n;
        _base64length = 76;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

