/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BlockBufferStream;
import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.Extensions;
import java.io.IOException;
import java.io.InputStream;

public class BlockBufferReadStream
extends BlockBufferStream {
    private NativeStream nativeStream = new NativeStream();
    private BufferSegment danglingTransformedBuffer;

    public BlockBufferReadStream(BufferStream.Listener listener) {
        super(listener);
    }

    protected BufferSegment getDanglingTransformedBuffer() {
        return this.danglingTransformedBuffer;
    }

    protected int getCipherMode() {
        return 2;
    }

    public InputStream getNativeStream() {
        return this.nativeStream;
    }

    protected void resetBlockSize(int n) {
        super.resetBlockSize(n);
        this.danglingTransformedBuffer = new BufferSegment(n);
        this.danglingTransformedBuffer.advanceToEnd();
    }

    public boolean isAnyAvailable() {
        return this.getDanglingTransformedBuffer().getRemainingCount() != 0 || this.getDanglingUntransformedBuffer().getCompletedCount() + this.getBufferSegment().getRemainingCount() >= this.getBlockSize();
    }

    public void skipAvailableUntilNonZero() {
        while (true) {
            if (this.getDanglingTransformedBuffer().getRemainingCount() != 0) {
                if (this.getDanglingTransformedBuffer().getBuffer()[this.getDanglingTransformedBuffer().getRemainingOffset()] != 0) {
                    return;
                }
                this.getDanglingTransformedBuffer().advance(1);
                continue;
            }
            if (this.getDanglingUntransformedBuffer().getCompletedCount() == this.getBlockSize()) {
                this.transformDangling();
                continue;
            }
            if (this.getBufferSegment().getRemainingCount() == 0) break;
            this.copyBufferToDangling();
        }
    }

    public int readUnsignedByte() throws IOException {
        if (this.getDanglingTransformedBuffer().getRemainingCount() != 0) {
            return Extensions.toUnsignedByte(this.getDanglingTransformedBuffer().readAndAdvance());
        }
        return Extensions.readUnsignedByteDefault(this);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        while (this.getDanglingTransformedBuffer().getRemainingCount() == 0) {
            if (this.getDanglingUntransformedBuffer().getCompletedCount() == this.getBlockSize()) {
                this.transformDangling();
                continue;
            }
            if (this.getDanglingUntransformedBuffer().getCompletedCount() != 0) {
                if (!this.requestBufferCount(1)) {
                    return -1;
                }
                this.copyBufferToDangling();
                continue;
            }
            if (!this.requestBufferCount(1)) {
                return -1;
            }
            int n3 = Math.min(this.getBufferSegment().getRemainingCount(), n2);
            int n4 = n3 / this.getBlockSize();
            if (n4 != 0) {
                int n5 = n4 * this.getBlockSize();
                this.copyOrTransform(this.getBufferSegment().getBuffer(), this.getBufferSegment().getRemainingOffset(), byArray, n, n5);
                this.getBufferSegment().advance(n5);
                return n5;
            }
            this.copyBufferToDangling();
        }
        return this.getDanglingTransformedBuffer().readAsMuchAsPossibleAndAdvance(byArray, n, n2);
    }

    private void copyBufferToDangling() {
        this.getBufferSegment().readAsMuchAsPossibleAndAdvance(this.getDanglingUntransformedBuffer());
    }

    private void transformDangling() {
        this.getDanglingTransformedBuffer().advanceToStart();
        this.copyOrTransform(this.getDanglingUntransformedBuffer().getBuffer(), this.getDanglingUntransformedBuffer().getCompletedOffset(), this.getDanglingTransformedBuffer().getBuffer(), this.getDanglingTransformedBuffer().getRemainingOffset(), this.getDanglingUntransformedBuffer().getCompletedCount());
        this.getDanglingUntransformedBuffer().advanceToStart();
    }

    private class NativeStream
    extends InputStream {
        private NativeStream() {
        }

        public int read() throws IOException {
            return BlockBufferReadStream.this.readUnsignedByte();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return BlockBufferReadStream.this.read(byArray, n, n2);
        }
    }
}

