/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.Extensions;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class BlockBufferStream
extends BufferStream {
    private Cipher transform;
    private int blockSize;
    private BufferSegment danglingUntransformedBuffer;

    public BlockBufferStream(BufferStream.Listener listener) {
        super(listener);
        this.resetBlockSize(1);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    protected BufferSegment getDanglingUntransformedBuffer() {
        return this.danglingUntransformedBuffer;
    }

    protected abstract int getCipherMode();

    protected void resetBlockSize(int n) {
        this.blockSize = n;
        this.danglingUntransformedBuffer = new BufferSegment(this.blockSize);
    }

    public void startSecureChannel(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        this.transform = Extensions.createCipher(byArray, byArray2, this.getCipherMode());
        this.resetBlockSize(this.transform.getBlockSize());
    }

    protected void copyOrTransform(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (this.transform == null) {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        } else {
            Extensions.transformBlock(this.transform, byArray, n, n3, byArray2, n2);
        }
    }
}

