/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BlockBufferStream;
import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Extensions;
import java.io.IOException;
import java.io.OutputStream;

public class BlockBufferWriteStream
extends BlockBufferStream {
    private NativeStream nativeStream = new NativeStream();

    public BlockBufferWriteStream(BufferStream.Listener listener) {
        super(listener);
    }

    protected int getCipherMode() {
        return 1;
    }

    public OutputStream getNativeStream() {
        return this.nativeStream;
    }

    public void writeByte(byte by) throws IOException {
        if (this.getDanglingUntransformedBuffer().getRemainingCount() != 0) {
            this.getDanglingUntransformedBuffer().writeAndAdvance(by);
        } else {
            Extensions.writeByteDefault(this, by);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        BufferSegment bufferSegment = new BufferSegment(byArray, n, n2);
        if (this.getDanglingUntransformedBuffer().getCompletedCount() != 0) {
            this.getDanglingUntransformedBuffer().writeAsMuchAsPossibleAndAdvance(bufferSegment);
            if (this.getDanglingUntransformedBuffer().getRemainingCount() == 0) {
                this.transformAndWriteBlocks(this.getDanglingUntransformedBuffer().getCompletedSegment());
                this.getDanglingUntransformedBuffer().advanceToStart();
            }
        }
        if (bufferSegment.getRemainingCount() == 0) {
            return;
        }
        bufferSegment.advance(this.transformAndWriteBlocks(bufferSegment.getRemainingSegment()));
        if (bufferSegment.getRemainingCount() == 0) {
            return;
        }
        this.getDanglingUntransformedBuffer().writeAndAdvance(bufferSegment.getRemainingSegment());
    }

    public void flush() throws IOException {
        if (this.getDanglingUntransformedBuffer().getCompletedCount() != 0) {
            this.getDanglingUntransformedBuffer().writeAndAdvance(new byte[this.getDanglingUntransformedBuffer().getRemainingCount()]);
            this.transformAndWriteBlocks(this.getDanglingUntransformedBuffer().getCompletedSegment());
            this.getDanglingUntransformedBuffer().advanceToStart();
        }
        if (this.getBufferSegment().getCompletedCount() != 0) {
            this.onNeedsBufferCycled();
        }
    }

    private int transformAndWriteBlocks(ByteArraySegment byteArraySegment) throws IOException {
        BufferSegment bufferSegment = new BufferSegment(byteArraySegment);
        while (bufferSegment.getRemainingCount() >= this.getBlockSize()) {
            this.demandBufferCount(this.getBlockSize());
            int n = Math.min(bufferSegment.getRemainingCount(), this.getBufferSegment().getRemainingCount()) / this.getBlockSize();
            int n2 = n * this.getBlockSize();
            this.copyOrTransform(bufferSegment.getBuffer(), bufferSegment.getRemainingOffset(), this.getBufferSegment().getBuffer(), this.getBufferSegment().getRemainingOffset(), n2);
            bufferSegment.advance(n2);
            this.getBufferSegment().advance(n2);
        }
        this.demandBufferCount(this.getBlockSize());
        return bufferSegment.getCompletedCount();
    }

    private class NativeStream
    extends OutputStream {
        private NativeStream() {
        }

        public void write(int n) throws IOException {
            BlockBufferWriteStream.this.writeByte((byte)n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            BlockBufferWriteStream.this.write(byArray, n, n2);
        }
    }
}

