/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.SingleCallCoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferProducer
implements SingleCallCoder.BufferProvider {
    private BufferSegment bufferSegment;
    private List<ByteArraySegment> completedBuffers = new ArrayList<ByteArraySegment>();

    public BufferProducer(int n) {
        this.bufferSegment = new BufferSegment(n);
    }

    public List<ByteArraySegment> getCompletedBuffers() {
        return this.completedBuffers;
    }

    @Override
    public BufferSegment borrowByteBuffer() throws IOException {
        this.completeCurrentIfFull();
        return this.bufferSegment;
    }

    @Override
    public void returnByteBuffer(BufferSegment bufferSegment) throws IOException {
        if (!this.bufferSegment.equals(bufferSegment)) {
            throw new IllegalArgumentException();
        }
        this.completeCurrentIfFull();
    }

    private void completeCurrentIfFull() {
        if (this.bufferSegment.getRemainingCount() == 0) {
            this.completeCurrent();
        }
    }

    public void completeCurrent() {
        this.completedBuffers.add(this.bufferSegment.getCompletedSegment().copy());
        this.bufferSegment.advanceToStart();
    }
}

