/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.ByteArraySegment;

public class BufferSegment {
    private byte[] buffer;
    private int firstIndex;
    private int lastIndexExclusive;
    private int currentIndex;

    public BufferSegment(int n) {
        this(new byte[n]);
    }

    public BufferSegment(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public BufferSegment(ByteArraySegment byteArraySegment) {
        this(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
    }

    public BufferSegment(byte[] byArray, int n, int n2) {
        this(byArray, n, n + n2, n);
    }

    public BufferSegment(byte[] byArray, int n, int n2, int n3) {
        this.buffer = byArray;
        this.firstIndex = n;
        this.lastIndexExclusive = n2;
        this.currentIndex = n3;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getCompletedOffset() {
        return this.firstIndex;
    }

    public int getCompletedCount() {
        return this.currentIndex - this.firstIndex;
    }

    public int getRemainingOffset() {
        return this.currentIndex;
    }

    public int getRemainingCount() {
        return this.lastIndexExclusive - this.currentIndex;
    }

    public void advance(int n) {
        this.currentIndex += n;
    }

    public void advanceToStart() {
        this.currentIndex = this.firstIndex;
    }

    public void advanceToEnd() {
        this.currentIndex = this.lastIndexExclusive;
    }

    public byte readAndAdvance() {
        byte by = this.buffer[this.currentIndex];
        this.advance(1);
        return by;
    }

    public void readAndAdvance(byte[] byArray, int n, int n2) {
        System.arraycopy(this.buffer, this.currentIndex, byArray, n, n2);
        this.advance(n2);
    }

    public void readAndAdvance(BufferSegment bufferSegment, int n) {
        this.readAndAdvance(bufferSegment.getBuffer(), bufferSegment.getRemainingOffset(), n);
        bufferSegment.advance(n);
    }

    public int readAsMuchAsPossibleAndAdvance(byte[] byArray, int n, int n2) {
        int n3 = Math.min(this.getRemainingCount(), n2);
        this.readAndAdvance(byArray, n, n3);
        return n3;
    }

    public int readAsMuchAsPossibleAndAdvance(ByteArraySegment byteArraySegment) {
        return this.readAsMuchAsPossibleAndAdvance(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
    }

    public int readAsMuchAsPossibleAndAdvance(BufferSegment bufferSegment) {
        int n = this.readAsMuchAsPossibleAndAdvance(bufferSegment.getRemainingSegment());
        bufferSegment.advance(n);
        return n;
    }

    public void writeAndAdvance(byte by) {
        this.buffer[this.currentIndex] = by;
        this.advance(1);
    }

    public void writeAndAdvance(byte[] byArray) {
        this.writeAndAdvance(byArray, 0, byArray.length);
    }

    public void writeAndAdvance(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buffer, this.currentIndex, n2);
        this.advance(n2);
    }

    public void writeAndAdvance(ByteArraySegment byteArraySegment) {
        this.writeAndAdvance(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
    }

    public void writeAndAdvance(BufferSegment bufferSegment, int n) {
        bufferSegment.readAndAdvance(this, n);
    }

    public int writeAsMuchAsPossibleAndAdvance(BufferSegment bufferSegment) {
        return bufferSegment.readAsMuchAsPossibleAndAdvance(this);
    }

    public ByteArraySegment getCompletedSegment() {
        return new ByteArraySegment(this.buffer, this.firstIndex, this.currentIndex - this.firstIndex);
    }

    public ByteArraySegment getRemainingSegment() {
        return new ByteArraySegment(this.buffer, this.currentIndex, this.lastIndexExclusive - this.currentIndex);
    }

    public ByteArraySegment toFullSegment() {
        return new ByteArraySegment(this.buffer, this.firstIndex, this.lastIndexExclusive - this.firstIndex);
    }
}

