/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Extensions;
import java.io.EOFException;
import java.io.IOException;

public class BufferStream {
    private Listener listener;
    private BufferSegment bufferSegment;

    public BufferStream(Listener listener) {
        this.listener = Extensions.assertArgumentNonNull(listener);
        this.bufferSegment = new BufferSegment(0);
    }

    public BufferSegment getBufferSegment() {
        return this.bufferSegment;
    }

    public void setBuffer(byte[] byArray, int n, int n2) {
        this.bufferSegment = new BufferSegment(byArray, n, n2);
    }

    public void setBuffer(ByteArraySegment byteArraySegment) {
        this.bufferSegment = new BufferSegment(Extensions.assertArgumentNonNull(byteArraySegment));
    }

    public int readUnsignedByte() throws IOException {
        if (!this.requestBufferCount(1)) {
            return -1;
        }
        return Extensions.toUnsignedByte(this.bufferSegment.readAndAdvance());
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.requestBufferCount(1)) {
            return -1;
        }
        return this.bufferSegment.readAsMuchAsPossibleAndAdvance(byArray, n, n2);
    }

    public void writeByte(byte by) throws IOException {
        this.demandBufferCount(1);
        this.bufferSegment.writeAndAdvance(by);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        BufferSegment bufferSegment = new BufferSegment(byArray, n, n2);
        while (bufferSegment.getRemainingCount() != 0) {
            this.demandBufferCount(1);
            this.bufferSegment.writeAsMuchAsPossibleAndAdvance(bufferSegment);
        }
    }

    public void flush() throws IOException {
        if (this.bufferSegment.getCompletedCount() != 0) {
            this.onNeedsBufferCycled();
        }
    }

    protected boolean requestBufferCount(int n) throws IOException {
        if (this.bufferSegment.getRemainingCount() < n) {
            this.onNeedsBufferCycled();
            if (this.bufferSegment.getRemainingCount() < n) {
                return false;
            }
        }
        return true;
    }

    protected void demandBufferCount(int n) throws IOException {
        if (!this.requestBufferCount(n)) {
            throw new EOFException();
        }
    }

    protected void onNeedsBufferCycled() throws IOException {
        this.listener.needsBufferCycled(this);
    }

    public static interface Listener {
        public void needsBufferCycled(BufferStream var1) throws IOException;
    }
}

