/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import java.util.Arrays;

public class ByteArraySegment {
    public final byte[] array;
    public final int offset;
    public final int count;

    public ByteArraySegment(byte[] byArray) {
        this(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public ByteArraySegment(byte[] byArray, int n, int n2) {
        this.array = byArray;
        this.offset = n;
        this.count = n2;
    }

    public ByteArraySegment(int n) {
        this(new byte[n], 0, n);
    }

    public byte[] copyBytes() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.array, this.offset, byArray, 0, this.count);
        return byArray;
    }

    public ByteArraySegment copy() {
        return new ByteArraySegment(this.copyBytes());
    }

    public boolean contentEquals(ByteArraySegment byteArraySegment) {
        if (byteArraySegment == null) {
            return this.count == 0;
        }
        if (this.count != byteArraySegment.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.array[this.offset + i] == byteArraySegment.array[byteArraySegment.offset + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOfRange(this.array, this.offset, this.offset + this.count));
    }
}

