/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Base64;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.ProcessType;
import com.elsitech.screenconnect.SessionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLaunchParameters {
    public String originalQueryString;
    public SessionType sessionType;
    public ProcessType processType;
    public String host;
    public int port;
    public UUID sessionID;
    public byte[] encryptionKey;
    public byte[] accessToken;
    public String participantName;
    public String sessionTitle;
    public String nameCallbackFormat;
    public String[] customPropertyValueCallbackFormats;

    public static void copyFromParameters(ClientLaunchParameters clientLaunchParameters, HashMap<String, ArrayList<String>> hashMap) {
        Extensions.assertArgumentNonNull(clientLaunchParameters);
        Extensions.assertArgumentNonNull(hashMap);
        String string = Extensions.getSingleValue(hashMap, "e");
        String string2 = Extensions.getSingleValue(hashMap, "y");
        String string3 = Extensions.getSingleValue(hashMap, "p");
        String string4 = Extensions.getSingleValue(hashMap, "s");
        String string5 = Extensions.getSingleValue(hashMap, "k");
        String string6 = Extensions.getSingleValue(hashMap, "n");
        clientLaunchParameters.sessionType = Extensions.isNullOrEmpty(string) ? SessionType.Support : SessionType.valueOf(string);
        clientLaunchParameters.processType = Extensions.isNullOrEmpty(string2) ? ProcessType.Unknown : ProcessType.valueOf(string2);
        clientLaunchParameters.host = Extensions.getSingleValue(hashMap, "h");
        clientLaunchParameters.port = Extensions.isNullOrEmpty(string3) ? 0 : Integer.parseInt(string3);
        clientLaunchParameters.sessionID = Extensions.isNullOrEmpty(string4) ? null : UUID.fromString(string4);
        clientLaunchParameters.encryptionKey = Extensions.isNullOrEmpty(string5) ? null : Base64.decode(string5);
        clientLaunchParameters.accessToken = Extensions.isNullOrEmpty(string6) ? null : Base64.decode(string6);
        clientLaunchParameters.participantName = Extensions.getSingleValue(hashMap, "r");
        clientLaunchParameters.sessionTitle = Extensions.getSingleValue(hashMap, "i");
        clientLaunchParameters.nameCallbackFormat = Extensions.getSingleValue(hashMap, "t");
        ArrayList<String> arrayList = hashMap.get("c");
        clientLaunchParameters.customPropertyValueCallbackFormats = arrayList == null ? new String[]{} : arrayList.toArray(new String[arrayList.size()]);
    }

    public static ClientLaunchParameters fromQueryString(String string) {
        HashMap<String, ArrayList<String>> hashMap = Extensions.decodeQueryString(string);
        ClientLaunchParameters clientLaunchParameters = new ClientLaunchParameters();
        clientLaunchParameters.originalQueryString = string;
        ClientLaunchParameters.copyFromParameters(clientLaunchParameters, hashMap);
        return clientLaunchParameters;
    }

    public static ClientLaunchParameters fromUrl(String string, int n, String string2) {
        ClientLaunchParameters clientLaunchParameters = new ClientLaunchParameters();
        clientLaunchParameters.host = string;
        clientLaunchParameters.port = n;
        String[] stringArray = string2.split("/");
        if (!Extensions.isNullOrEmpty(stringArray[1])) {
            clientLaunchParameters.sessionID = UUID.fromString(Extensions.urlDecode(stringArray[1]));
        }
        if (!Extensions.isNullOrEmpty(stringArray[2])) {
            clientLaunchParameters.encryptionKey = Base64.decode(Extensions.urlDecode(stringArray[2]));
        }
        if (stringArray.length > 3 && !Extensions.isNullOrEmpty(stringArray[3])) {
            clientLaunchParameters.accessToken = Base64.decode(Extensions.urlDecode(stringArray[3]));
        }
        if (stringArray.length > 4) {
            clientLaunchParameters.participantName = Extensions.urlDecode(stringArray[4]);
        }
        if (stringArray.length > 5) {
            clientLaunchParameters.sessionType = SessionType.valueOf(Extensions.urlDecode(stringArray[5]));
        }
        if (stringArray.length > 6) {
            clientLaunchParameters.sessionTitle = Extensions.urlDecode(stringArray[6]);
        }
        clientLaunchParameters.processType = clientLaunchParameters.accessToken != null && clientLaunchParameters.accessToken.length != 0 ? ProcessType.Host : ProcessType.Guest;
        return clientLaunchParameters;
    }

    public String toString() {
        return this.sessionID != null ? this.sessionID.toString() : this.host;
    }
}

