/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreSize;

public class CoreRect {
    public int x;
    public int y;
    public int width;
    public int height;

    public CoreRect() {
    }

    public CoreRect(CoreRect coreRect) {
        this.x = coreRect.x;
        this.y = coreRect.y;
        this.width = coreRect.width;
        this.height = coreRect.height;
    }

    public CoreRect(CorePoint corePoint, CoreSize coreSize) {
        this.x = corePoint.x;
        this.y = corePoint.y;
        this.width = coreSize.width;
        this.height = coreSize.height;
    }

    public CoreRect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public CoreSize getSize() {
        return new CoreSize(this.width, this.height);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public CoreRect union(CoreRect coreRect) {
        long l = this.width;
        long l2 = this.height;
        if ((l | l2) < 0L) {
            return new CoreRect(coreRect);
        }
        long l3 = coreRect.width;
        long l4 = coreRect.height;
        if ((l3 | l4) < 0L) {
            return new CoreRect(this);
        }
        int n = this.x;
        int n2 = this.y;
        l += (long)n;
        l2 += (long)n2;
        int n3 = coreRect.x;
        int n4 = coreRect.y;
        l3 += (long)n3;
        l4 += (long)n4;
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (l < l3) {
            l = l3;
        }
        if (l2 < l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new CoreRect(n, n2, (int)l, (int)l2);
    }

    public CoreRect intersection(CoreRect coreRect) {
        int n = this.x;
        int n2 = this.y;
        int n3 = coreRect.x;
        int n4 = coreRect.y;
        long l = n;
        l += (long)this.width;
        long l2 = n2;
        l2 += (long)this.height;
        long l3 = n3;
        l3 += (long)coreRect.width;
        long l4 = n4;
        l4 += (long)coreRect.height;
        if (n < n3) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (l > l3) {
            l = l3;
        }
        if (l2 > l4) {
            l2 = l4;
        }
        l2 -= (long)n2;
        if ((l -= (long)n) < Integer.MIN_VALUE) {
            l = Integer.MIN_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            l2 = Integer.MIN_VALUE;
        }
        return new CoreRect(n, n2, (int)l, (int)l2);
    }

    public CoreRect inflate(int n) {
        return new CoreRect(this.x - n, this.y - n, this.width + n * 2, this.height + n * 2);
    }

    public CoreRect inflateWithinBounds(int n, CoreRect coreRect) {
        return this.inflate(n).intersection(coreRect);
    }

    public CoreRect offset(int n, int n2) {
        return new CoreRect(this.x + n, this.y + n2, this.width, this.height);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CoreRect)) {
            return false;
        }
        CoreRect coreRect = (CoreRect)object;
        return coreRect.width == this.width && coreRect.height == this.height && coreRect.x == this.x && coreRect.y == this.y;
    }

    public String toString() {
        return "[x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.height + "]";
    }
}

