/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Messages;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CursorMessageProcessor<T> {
    HashMap<Integer, CursorInfo<T>> cursorMap;
    CursorInfo<T> cursor;
    CorePoint position;

    public CorePoint getPosition() {
        return this.position;
    }

    public CursorInfo<T> getCursor() {
        return this.cursor;
    }

    public void processMessage(Messages.CursorMessage cursorMessage) {
        if (this.cursorMap == null) {
            this.cursorMap = new HashMap();
        }
        this.position = cursorMessage.position;
        this.cursor = this.cursorMap.get(cursorMessage.cursorID);
        if (this.cursor == null) {
            Object t;
            T t2;
            CorePoint corePoint;
            if (cursorMessage instanceof Messages.CustomCursorMessage) {
                Messages.CustomCursorMessage customCursorMessage = (Messages.CustomCursorMessage)cursorMessage;
                corePoint = customCursorMessage.hotSpot;
                t2 = this.loadImage(customCursorMessage.maskImage);
                t = this.loadImage(customCursorMessage.colorImage);
            } else {
                int n = 32512;
                if (cursorMessage instanceof Messages.StandardCursorMessage) {
                    n = ((Messages.StandardCursorMessage)cursorMessage).standardCursorID;
                }
                corePoint = this.getHotSpot(n);
                t2 = this.loadImage(n);
                t = null;
            }
            this.cursor = new CursorInfo<Object>(corePoint, t, t2);
            this.cursorMap.put(cursorMessage.cursorID, this.cursor);
        }
    }

    protected abstract T loadImage(ByteArraySegment var1);

    protected abstract T loadImage(int var1);

    protected abstract CorePoint getHotSpot(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CursorInfo<T> {
        private CorePoint hotSpot;
        private T colorImage;
        private T maskImage;

        public CursorInfo(CorePoint corePoint, T t, T t2) {
            this.hotSpot = Extensions.assertArgumentNonNull(corePoint);
            this.colorImage = t;
            this.maskImage = t2;
        }

        public CorePoint getHotSpot() {
            return this.hotSpot;
        }

        public T getColorImage() {
            return this.colorImage;
        }

        public T getMaskImage() {
            return this.maskImage;
        }
    }
}

