/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.SingleCallCoder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.zip.Deflater;

public class DeflateEncoder
implements SingleCallCoder {
    private Deflater nativeDeflater;
    private int compressionLevel;
    private byte[] overflowOutputBuffer;
    private boolean isSyncFlushSet;
    private boolean isSyncFlushIncompatible;

    public DeflateEncoder(int n, int n2, boolean bl) {
        this.compressionLevel = n;
        this.nativeDeflater = new Deflater(this.compressionLevel, !bl);
        this.nativeDeflater.setStrategy(n2);
        try {
            Field field = this.nativeDeflater.getClass().getDeclaredField("flushParm");
            field.setAccessible(true);
            field.setInt(this.nativeDeflater, 2);
            this.isSyncFlushSet = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.nativeDeflater.end();
    }

    public int getTotalInputCount() {
        return this.nativeDeflater.getTotalIn();
    }

    public int getTotalOutputCount() {
        return this.nativeDeflater.getTotalOut();
    }

    public int getUnusedBitTakenCount() {
        throw new UnsupportedOperationException();
    }

    public void process(ByteArraySegment byteArraySegment, SingleCallCoder.BufferProvider bufferProvider) throws IOException {
        Extensions.assertArgumentNonNull(byteArraySegment);
        Extensions.assertArgumentNonNull(bufferProvider);
        this.nativeDeflater.setInput(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
        BufferSegment bufferSegment = null;
        int n = 0;
        do {
            if (bufferSegment != null) {
                bufferProvider.returnByteBuffer(bufferSegment);
            }
            bufferSegment = bufferProvider.borrowByteBuffer();
            if (!this.isSyncFlushIncompatible) {
                try {
                    n = this.nativeDeflater.deflate(bufferSegment.getBuffer(), bufferSegment.getRemainingOffset(), bufferSegment.getRemainingCount(), 2);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    this.isSyncFlushIncompatible = true;
                }
            }
            if (this.isSyncFlushIncompatible) {
                n = this.nativeDeflater.deflate(bufferSegment.getBuffer(), bufferSegment.getRemainingOffset(), bufferSegment.getRemainingCount());
            }
            bufferSegment.advance(n);
        } while (bufferSegment.getRemainingCount() == 0);
        if (!this.isSyncFlushSet && this.isSyncFlushIncompatible) {
            if (this.overflowOutputBuffer == null) {
                this.overflowOutputBuffer = new byte[32768];
            }
            this.nativeDeflater.setLevel(0);
            BufferSegment bufferSegment2 = new BufferSegment(this.overflowOutputBuffer, 0, this.nativeDeflater.deflate(this.overflowOutputBuffer, 0, this.overflowOutputBuffer.length));
            this.nativeDeflater.setLevel(this.compressionLevel);
            do {
                if (bufferSegment.getRemainingCount() == 0) {
                    bufferProvider.returnByteBuffer(bufferSegment);
                    bufferSegment = bufferProvider.borrowByteBuffer();
                }
                bufferSegment.writeAsMuchAsPossibleAndAdvance(bufferSegment2);
            } while (bufferSegment2.getRemainingCount() != 0);
        }
        bufferProvider.returnByteBuffer(bufferSegment);
    }
}

