/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.EndPointStatus;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.KeySet;
import com.elsitech.screenconnect.MessageSerializer;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.NetworkConnection;
import com.elsitech.screenconnect.ProcessType;
import com.elsitech.screenconnect.SessionType;
import com.elsitech.screenconnect.ThreadRunner;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;

public class EndPointManager
extends ThreadRunner {
    private MessageSerializer messageSerializer;
    private EndPointStatus status;
    private Queue<Object> outgoingQueue;
    private Calendar statusTime;
    private boolean reconnect;
    private Listener listener;
    private int sentMessageCount;
    private int receivedMessageCount;
    private String lastErrorMessage;
    private String host;
    private int port;
    private ProcessType processType;
    private UUID sessionID;
    private String nameCallbackFormat;
    private String[] customPropertyValueCallbackFormats;
    private byte[] encryptionKey;
    private byte[] accessToken;
    private String participantName;
    private Messages.Version clientVersion;
    private Messages.ClientType clientType;
    private SessionType sessionType;
    private InetAddress localAddress;

    public EndPointManager(String string, int n, ProcessType processType, UUID uUID, byte[] byArray, byte[] byArray2, String string2, String string3, String[] stringArray, Messages.Version version, Messages.ClientType clientType, SessionType sessionType, Listener listener) {
        super(6, false);
        Extensions.assertArgumentNonNull(string);
        this.encryptionKey = byArray;
        Extensions.assertArgumentNonNull(byArray);
        this.sessionID = uUID;
        this.host = string;
        this.port = n;
        this.accessToken = byArray2;
        this.participantName = string2;
        this.nameCallbackFormat = string3;
        this.customPropertyValueCallbackFormats = stringArray;
        this.clientVersion = version;
        this.clientType = clientType;
        this.sessionType = sessionType;
        this.processType = processType;
        this.listener = Extensions.assertArgumentNonNull(listener);
        this.status = EndPointStatus.Stopped;
        this.messageSerializer = new MessageSerializer();
        this.outgoingQueue = new LinkedList<Object>();
    }

    protected void onStopped(boolean bl) {
        super.onStopped(bl);
        this.setStatus(EndPointStatus.Stopped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.syncLock;
        synchronized (object) {
            this.reconnect = true;
            this.syncLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Throwable {
        final long[] lArray = new long[1];
        boolean bl = false;
        long l = 0L;
        while (!this.isStopping()) {
            final ThreadSharedState threadSharedState = new ThreadSharedState();
            boolean bl2 = false;
            long l2 = System.currentTimeMillis();
            threadSharedState.networkConnection = new NetworkConnection(new Socket(Proxy.NO_PROXY), new BufferStream.Listener(){

                public void needsBufferCycled(BufferStream bufferStream) {
                    lArray[0] = System.currentTimeMillis() + 10L;
                }
            });
            Thread thread = Extensions.createThread(new Runnable(){

                public void run() {
                    EndPointManager.this.runIncomingThread(threadSharedState);
                }
            }, "EndPointManagerIncoming", 5);
            this.setStatus(EndPointStatus.Connecting);
            this.receivedMessageCount = 0;
            this.sentMessageCount = 0;
            threadSharedState.networkConnection.socket.setTcpNoDelay(true);
            threadSharedState.networkConnection.socket.setKeepAlive(true);
            try {
                ProxySelector proxySelector = null;
                if (bl = !bl) {
                    proxySelector = ProxySelector.getDefault();
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
                Extensions.connect(threadSharedState.networkConnection.socket, inetSocketAddress, proxySelector);
                threadSharedState.networkConnection.initialize();
                this.localAddress = threadSharedState.networkConnection.socket.getLocalAddress();
                this.setStatus(EndPointStatus.Negotiating);
                Messages.VersionMessage versionMessage = new Messages.VersionMessage(this.clientVersion);
                Messages.ClientTypeMessage clientTypeMessage = new Messages.ClientTypeMessage(this.clientType);
                threadSharedState.secretKey = Extensions.generateEncryptionBytes(16, false);
                threadSharedState.clientRandom = Extensions.generateEncryptionBytes(32, false);
                byte[] byArray = Extensions.encryptAsymmetric(this.encryptionKey, threadSharedState.secretKey);
                Messages.SecureChannelMessage2 secureChannelMessage2 = new Messages.SecureChannelMessage2(byArray, threadSharedState.clientRandom);
                Object object = this.syncLock;
                synchronized (object) {
                    this.outgoingQueue.clear();
                    this.outgoingQueue.add(versionMessage);
                    this.outgoingQueue.add(clientTypeMessage);
                    this.outgoingQueue.add(secureChannelMessage2);
                }
                while (!this.isStopping()) {
                    int n;
                    object = null;
                    Object object2 = this.syncLock;
                    synchronized (object2) {
                        if (this.reconnect) {
                            this.reconnect = false;
                            break;
                        }
                        if (threadSharedState.networkConnection.isDisposed) {
                            break;
                        }
                        if (this.outgoingQueue.size() != 0) {
                            object = this.outgoingQueue.remove();
                        } else if (!bl2) {
                            bl2 = true;
                            thread.start();
                        } else if (lArray[0] != 0L) {
                            Extensions.waitQuietlyIfPositive(this.syncLock, lArray[0] - System.currentTimeMillis());
                        } else {
                            this.syncLock.wait();
                        }
                    }
                    if (threadSharedState.allowNonSystemMessages ? object != null : object instanceof Messages.SystemMessage) {
                        this.messageSerializer.serialize(threadSharedState.networkConnection.writer, object);
                        ++this.sentMessageCount;
                    }
                    if ((n = threadSharedState.networkConnection.writeStream.getBufferSegment().getCompletedCount()) == 0) continue;
                    if (object == null || n >= 1000 || System.currentTimeMillis() > lArray[0] - 2L) {
                        threadSharedState.networkConnection.writeStream.flush();
                        lArray[0] = 0L;
                        continue;
                    }
                    if (lArray[0] != 0L) continue;
                    lArray[0] = System.currentTimeMillis() + 10L;
                }
            }
            catch (Throwable throwable) {
                Constants.ExceptionTraceSource.traceException(throwable);
                this.lastErrorMessage = throwable.getMessage();
            }
            finally {
                Extensions.closeQuietly(threadSharedState.networkConnection);
                if (thread.getState() != Thread.State.TERMINATED) {
                    thread.join();
                }
            }
            l = System.currentTimeMillis() - l2 > 30000L ? 0L : Extensions.getBoundedValue(2000L, (int)((float)l * 1.5f), 1800000L);
            if (this.isStopping() || l == 0L) continue;
            this.setStatus(EndPointStatus.SleepingForRetry);
            this.waitUnlessStoppingUntil(l2 + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIncomingThread(ThreadSharedState threadSharedState) {
        try {
            while (true) {
                threadSharedState.networkConnection.readStream.skipAvailableUntilNonZero();
                Object object = this.messageSerializer.deserialize(threadSharedState.networkConnection.reader, null);
                if (object instanceof Messages.SecureChannelMessage2) {
                    KeySet keySet = Extensions.deriveKeys(threadSharedState.secretKey, threadSharedState.clientRandom, ((Messages.SecureChannelMessage2)object).random.copyBytes());
                    threadSharedState.networkConnection.readStream.startSecureChannel(keySet.serverWriteKey, keySet.serverWriteInitializationVector);
                    threadSharedState.networkConnection.writeStream.startSecureChannel(keySet.clientWriteKey, keySet.clientWriteInitializationVector);
                    Messages.InitiateSessionMessage initiateSessionMessage = this.createInitiateSessionMessage();
                    this.enqueueOutgoingMessage(initiateSessionMessage);
                    threadSharedState.allowNonSystemMessages = true;
                } else if (object instanceof Messages.SessionConnectionsChangedMessage3) {
                    this.lastErrorMessage = null;
                    EndPointStatus endPointStatus = this.getInSessionEndPointStatus(((Messages.SessionConnectionsChangedMessage3)object).connections, ((Messages.SessionConnectionsChangedMessage3)object).currentConnectionID);
                    this.setStatus(endPointStatus);
                } else if (object instanceof Messages.SessionWaitingMessage) {
                    this.lastErrorMessage = null;
                    this.setStatus(object instanceof Messages.SessionAlreadyConnectedMessage ? EndPointStatus.SleepingForFreeSlot : EndPointStatus.SleepingForFreeLicense);
                    long l = System.currentTimeMillis() + 30000L;
                    while (!this.isStopping()) {
                        long l2 = l - System.currentTimeMillis();
                        if (l2 <= 0L) {
                            this.setStatus(EndPointStatus.Negotiating);
                            Messages.InitiateSessionMessage initiateSessionMessage = this.createInitiateSessionMessage();
                            this.enqueueOutgoingMessage(initiateSessionMessage);
                            break;
                        }
                        this.waitUnlessSignaled(l2);
                    }
                } else {
                    if (object instanceof Messages.SessionKeyInvalidMessage) {
                        throw new SecurityException("Public key mismatch");
                    }
                    if (object instanceof Messages.SessionInvalidMessage) {
                        this.signalStopping();
                    }
                }
                this.listener.messageReceived(object);
                ++this.receivedMessageCount;
            }
        }
        catch (Throwable throwable) {
            Object object = this.syncLock;
            synchronized (object) {
                Extensions.closeQuietly(threadSharedState.networkConnection);
                this.syncLock.notifyAll();
            }
            this.lastErrorMessage = throwable.getMessage();
            Constants.ExceptionTraceSource.traceException(throwable);
            return;
        }
    }

    private Messages.InitiateSessionMessage createInitiateSessionMessage() throws GeneralSecurityException {
        if (this.sessionID == null || this.sessionID.equals(Constants.EmptyUUID)) {
            return new Messages.CreateSessionMessage5(Extensions.getMachineBasedSessionID(), this.processType, this.nameCallbackFormat, this.customPropertyValueCallbackFormats);
        }
        return new Messages.ConnectSessionMessage5(this.sessionID, this.processType, new ByteArraySegment(this.accessToken == null ? new byte[]{} : this.accessToken), this.participantName);
    }

    private EndPointStatus getInSessionEndPointStatus(Messages.SessionConnectionInfo3[] sessionConnectionInfo3Array, UUID uUID) {
        Messages.SessionConnectionInfo3 sessionConnectionInfo3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Messages.SessionConnectionInfo3 sessionConnectionInfo32 : sessionConnectionInfo3Array) {
            if (sessionConnectionInfo32.connectionID.equals(uUID)) {
                sessionConnectionInfo3 = sessionConnectionInfo32;
            }
            bl |= sessionConnectionInfo32.processType == ProcessType.Host;
            bl2 |= sessionConnectionInfo32.processType == ProcessType.Guest;
            bl3 |= sessionConnectionInfo32.attributes.contains((Object)Messages.SessionConnectionAttribute.CAPTURE_SCREEN);
        }
        if (sessionConnectionInfo3Array.length > 1 && bl3) {
            return EndPointStatus.Connected;
        }
        if (sessionConnectionInfo3 != null) {
            if (sessionConnectionInfo3.processType == ProcessType.Host && !bl2) {
                return EndPointStatus.WaitingForGuest;
            }
            if (sessionConnectionInfo3.processType == ProcessType.Guest && !bl) {
                return EndPointStatus.WaitingForHost;
            }
            if (sessionConnectionInfo3.attributes.contains((Object)Messages.SessionConnectionAttribute.REFUSED_CONSENT)) {
                return EndPointStatus.RefusedConsent;
            }
            if (sessionConnectionInfo3.attributes.contains((Object)Messages.SessionConnectionAttribute.NEEDS_CONSENT)) {
                return EndPointStatus.WaitingForConsent;
            }
        }
        return EndPointStatus.WaitingForCapture;
    }

    public EndPointStatus getStatus() {
        return this.status;
    }

    private void setStatus(EndPointStatus endPointStatus) {
        if (endPointStatus != this.status) {
            this.status = endPointStatus;
            this.statusTime = GregorianCalendar.getInstance();
            this.listener.statusChanged(endPointStatus);
        }
    }

    public long getSentMessageCount() {
        return this.sentMessageCount;
    }

    public long getReceivedMessageCount() {
        return this.receivedMessageCount;
    }

    public Calendar getStatusTime() {
        return this.statusTime;
    }

    public Messages.Version getClientVersion() {
        return this.clientVersion;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public UUID getSessionID() {
        return this.sessionID;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public ProcessType getProcessType() {
        return this.processType;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public int getOutgoingQueueDepth() {
        return this.outgoingQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueOutgoingMessage(Object object) {
        Object object2 = this.syncLock;
        synchronized (object2) {
            this.outgoingQueue.add(object);
            this.syncLock.notifyAll();
        }
    }

    public static interface Listener {
        public void messageReceived(Object var1);

        public void statusChanged(EndPointStatus var1);
    }

    private static class ThreadSharedState {
        public NetworkConnection networkConnection;
        public byte[] secretKey;
        public byte[] clientRandom;
        public boolean allowNonSystemMessages;

        private ThreadSharedState() {
        }
    }
}

