/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Base64;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.EndPointManager;
import com.elsitech.screenconnect.FileAction;
import com.elsitech.screenconnect.FileUserInterfaceManager;
import com.elsitech.screenconnect.KeySet;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.Order;
import com.elsitech.screenconnect.Resources;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.TraceSource;
import com.elsitech.screenconnect.VirtualFileReceiver;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Extensions {
    private Extensions() {
    }

    public static <T> T assertArgumentNonNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        return t;
    }

    public static <T> T assertArgumentNonNull(T t, String string) {
        if (t == null) {
            throw new IllegalArgumentException("Argument must be specified: " + string);
        }
        return t;
    }

    public static String assertArgumentNonNullOrEmpty(String string, String string2) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Argument must be specified: " + string2);
        }
        return string;
    }

    public static <T> T assertNonNull(T t) {
        if (t == null) {
            throw new IllegalStateException();
        }
        return t;
    }

    public static <T> T assertNull(T t) {
        if (t != null) {
            throw new IllegalStateException();
        }
        return t;
    }

    public static void closeQuietly(Object object) {
        if (object != null) {
            try {
                ((Closeable)object).close();
            }
            catch (Throwable throwable) {
                Constants.ExceptionTraceSource.traceException(throwable);
            }
        }
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        Extensions.assertArgumentNonNull(inputStream);
        Extensions.assertArgumentNonNull(byArray);
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new IOException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static void readFully(BufferStream bufferStream, byte[] byArray, int n, int n2) throws IOException {
        Extensions.assertArgumentNonNull(bufferStream);
        Extensions.assertArgumentNonNull(byArray);
        while (n2 > 0) {
            int n3 = bufferStream.read(byArray, n, n2);
            if (n3 <= 0) {
                throw new IOException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntireFile(File file, Charset charset) throws FileNotFoundException {
        Scanner scanner = new Scanner(file, charset.name());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.next();
            return string;
        }
        finally {
            scanner.close();
        }
    }

    public static void transformBlock(Cipher cipher, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        Extensions.assertArgumentNonNull(cipher);
        boolean bl = false;
        try {
            bl = cipher.update(byArray, n, n2, byArray2, n3) != n2;
        }
        catch (ShortBufferException shortBufferException) {
            bl = true;
        }
        if (bl) {
            throw new IllegalStateException("Unexpected count of bytes written from cryptography operation.");
        }
    }

    public static Cipher createCipher(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        Extensions.assertArgumentNonNull(byArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES/CBC/NoPadding".split("/")[0]);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(n, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    public static long getBoundedValue(long l, long l2, long l3) {
        if (l2 < l) {
            return l;
        }
        if (l2 > l3) {
            return l3;
        }
        return l2;
    }

    public static int divUp(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    public static long divUp(long l, long l2) {
        long l3 = l / l2;
        if (l % l2 != 0L) {
            ++l3;
        }
        return l3;
    }

    public static void waitQuietly(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void waitQuietly(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void waitQuietlyIfPositive(Object object, long l) {
        if (l > 0L) {
            Extensions.waitQuietly(object, l);
        }
    }

    public static void sleepQuietly(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void write7BitEncodedInt(DataOutput dataOutput, int n) throws IOException {
        while (((long)n & 0xFFFFFF80L) != 0L) {
            dataOutput.writeByte((byte)(n | 0x80));
            n >>>= 7;
        }
        dataOutput.writeByte((byte)n);
    }

    public static void write7BitEncodedLong(DataOutput dataOutput, long l) throws IOException {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            dataOutput.writeByte((byte)(l | 0x80L));
            l >>>= 7;
        }
        dataOutput.writeByte((byte)l);
    }

    public static int read7BitEncodedInt(DataInput dataInput) throws IOException {
        byte by;
        int n = 0;
        int n2 = 0;
        do {
            by = dataInput.readByte();
            n |= (by & 0x7F) << n2;
            n2 += 7;
        } while ((by & 0x80) != 0);
        return n;
    }

    public static long read7BitEncodedLong(DataInput dataInput) throws IOException {
        byte by;
        long l = 0L;
        int n = 0;
        do {
            by = dataInput.readByte();
            l |= (long)((by & 0x7F) << n);
            n += 7;
        } while ((by & 0x80) != 0);
        return l;
    }

    public static <K, V> V demand(HashMap<K, V> hashMap, K k) throws NoSuchElementException {
        Extensions.assertArgumentNonNull(hashMap);
        V v = hashMap.get(k);
        if (v == null) {
            String string = String.format("Key '%1$s' not found in hash map.", k);
            throw new NoSuchElementException(string);
        }
        return v;
    }

    public static void ensureDirectoryExists(File file) {
        if (!file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static Thread createThread(Runnable runnable, String string, int n) {
        Thread thread = new Thread(runnable, string);
        thread.setPriority(n);
        return thread;
    }

    public static int getOrderValue(Field field) {
        Order order = Extensions.assertArgumentNonNull(field).getAnnotation(Order.class);
        return order == null ? 0 : order.value();
    }

    public static Field[] getOrderedFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Comparator<Field> comparator = new Comparator<Field>(){

            @Override
            public int compare(Field field, Field field2) {
                return Extensions.getOrderValue(field) > Extensions.getOrderValue(field2) ? 1 : -1;
            }
        };
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            List<Field> list = Arrays.asList(clazz2.getDeclaredFields());
            Collections.sort(list, comparator);
            arrayList.addAll(list);
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    public static Integer tryParseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Proxy tryGetProxy(ProxySelector proxySelector, InetSocketAddress inetSocketAddress) {
        if (proxySelector != null) {
            try {
                URI uRI = new URI("socket", null, inetSocketAddress.getHostName(), inetSocketAddress.getPort(), null, null, null);
                List<Proxy> list = proxySelector.select(uRI);
                for (Proxy proxy : list) {
                    if (proxy.type() == Proxy.Type.DIRECT) continue;
                    return proxy;
                }
            }
            catch (Throwable throwable) {
                Constants.ExceptionTraceSource.traceException(throwable);
            }
        }
        return null;
    }

    public static void connect(Socket socket, InetSocketAddress inetSocketAddress, ProxySelector proxySelector) throws IOException {
        Extensions.assertArgumentNonNull(socket);
        Extensions.assertArgumentNonNull(inetSocketAddress);
        Proxy proxy = Extensions.tryGetProxy(proxySelector, inetSocketAddress);
        if (proxy != null) {
            Extensions.connect(socket, inetSocketAddress, proxy);
        } else {
            socket.connect(inetSocketAddress, 5000);
        }
    }

    public static void connect(Socket socket, InetSocketAddress inetSocketAddress, Proxy proxy) throws IOException {
        Extensions.assertArgumentNonNull(socket);
        Extensions.assertArgumentNonNull(inetSocketAddress);
        Extensions.assertArgumentNonNull(proxy);
        int n = socket.getSoTimeout();
        socket.setSoTimeout(5000);
        try {
            Object object;
            Object object2;
            Object object3;
            InetSocketAddress inetSocketAddress2 = (InetSocketAddress)proxy.address();
            if (inetSocketAddress2.isUnresolved()) {
                inetSocketAddress2 = new InetSocketAddress(inetSocketAddress2.getHostName(), inetSocketAddress2.getPort());
            }
            socket.connect(inetSocketAddress2, 5000);
            Charset charset = Charset.forName("US-ASCII");
            PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(inetSocketAddress2.getAddress(), inetSocketAddress2.getPort(), "http", null, "Basic");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), charset));
            bufferedWriter.write(String.format("CONNECT %1$s:%2$s HTTP/1.0", inetSocketAddress.getHostName(), inetSocketAddress.getPort()));
            bufferedWriter.newLine();
            if (passwordAuthentication != null) {
                object3 = passwordAuthentication.getUserName() + ":" + new String(passwordAuthentication.getPassword());
                object2 = ((String)object3).getBytes(charset);
                object = Base64.encode((byte[])object2);
                bufferedWriter.write("Proxy-Authorization: Basic " + (String)object);
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            object3 = new BufferedReader(new InputStreamReader(socket.getInputStream(), charset));
            object2 = ((BufferedReader)object3).readLine();
            object = ((String)object2).split(" ");
            Integer n2 = null;
            if (((String[])object).length < 2 || (n2 = Extensions.tryParseInt(object[1])) == null) {
                throw new IOException("Bad proxy response: " + (String)object2, null);
            }
            if (n2 != 200) {
                throw new IOException("Error from proxy: " + (String)object2, null);
            }
            while (((BufferedReader)object3).readLine().length() != 0) {
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Error connecting through proxy.", throwable);
        }
        finally {
            socket.setSoTimeout(n);
        }
    }

    public static boolean isClassAvailable(String string) {
        try {
            return Class.forName(string) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static UUID readUUID(DataInput dataInput) throws IOException {
        return new UUID((long)dataInput.readUnsignedByte() << 32 | (long)dataInput.readUnsignedByte() << 40 | (long)dataInput.readUnsignedByte() << 48 | (long)dataInput.readUnsignedByte() << 56 | (long)dataInput.readUnsignedByte() << 16 | (long)dataInput.readUnsignedByte() << 24 | (long)dataInput.readUnsignedByte() | (long)dataInput.readUnsignedByte() << 8, dataInput.readLong());
    }

    public static void writeUUID(DataOutput dataOutput, UUID uUID) throws IOException {
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        dataOutput.writeInt(Integer.reverseBytes((int)(l >> 32)));
        dataOutput.writeByte((byte)(l >> 16));
        dataOutput.writeByte((byte)(l >> 24));
        dataOutput.writeByte((byte)l);
        dataOutput.writeByte((byte)(l >> 8));
        dataOutput.writeLong(l2);
    }

    public static String getMachineName() {
        String string = System.getenv("HOSTNAME");
        if (string == null) {
            string = System.getenv("COMPUTERNAME");
        }
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return string;
    }

    public static boolean hasIP4Address(NetworkInterface networkInterface) {
        Extensions.assertArgumentNonNull(networkInterface);
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public static UUID getMachineUUID() {
        Object object;
        Object object2;
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            while (object2.hasMoreElements()) {
                object = (NetworkInterface)object2.nextElement();
                byte[] byArray = ((NetworkInterface)object).getHardwareAddress();
                if (byArray == null || byArray.length == 0 || ((NetworkInterface)object).getName().startsWith("vnic") || ((NetworkInterface)object).isVirtual() || ((NetworkInterface)object).isLoopback() || !Extensions.hasIP4Address((NetworkInterface)object)) continue;
                return UUID.nameUUIDFromBytes(byArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = Extensions.getMachineName();
        if (object2 == null) {
            throw new IllegalStateException("Can't get machine UUID");
        }
        object = ((String)object2).getBytes();
        return UUID.nameUUIDFromBytes((byte[])object);
    }

    public static void reverseIntArray(int[] nArray, int n, int n2) {
        int n3 = n;
        for (int i = n + n2 - 1; n3 < i; ++n3, --i) {
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    public static void reverseIntArray(int[] nArray) {
        Extensions.reverseIntArray(nArray, 0, nArray.length);
    }

    public static void reverseByteArray(byte[] byArray, int n, int n2) {
        int n3 = n;
        for (int i = n + n2 - 1; n3 < i; ++n3, --i) {
            byte by = byArray[n3];
            byArray[n3] = byArray[i];
            byArray[i] = by;
        }
    }

    public static void reverseByteArray(byte[] byArray) {
        Extensions.reverseByteArray(byArray, 0, byArray.length);
    }

    public static byte[] encryptRsaPkcs1(RSAPublicKeySpec rSAPublicKeySpec, byte[] byArray) {
        Extensions.assertArgumentNonNull(rSAPublicKeySpec);
        Extensions.assertArgumentNonNull(byArray);
        int n = rSAPublicKeySpec.getModulus().bitLength() / 8;
        byte[] byArray2 = Extensions.generateEncryptionBytes(n - byArray.length - 3, true);
        byte[] byArray3 = new byte[n];
        byArray3[0] = 0;
        byArray3[1] = 2;
        System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
        byArray3[byArray2.length + 2] = 0;
        System.arraycopy(byArray, 0, byArray3, byArray2.length + 3, byArray.length);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = bigInteger.modPow(rSAPublicKeySpec.getPublicExponent(), rSAPublicKeySpec.getModulus());
        byte[] byArray4 = bigInteger2.toByteArray();
        int n2 = Math.min(n, byArray4.length);
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray4, byArray4.length - n2, byArray5, n - n2, n2);
        return byArray5;
    }

    public static byte[] encryptAsymmetric(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Extensions.assertArgumentNonNull(byArray);
        Extensions.assertArgumentNonNull(byArray2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(12);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        byte[] byArray3 = new byte[n / 8];
        byteBuffer.get(byArray3);
        Extensions.reverseByteArray(byArray3);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, byArray3), BigInteger.valueOf(n2));
        return Extensions.encryptRsaPkcs1(rSAPublicKeySpec, byArray2);
    }

    public static UUID getMachineBasedSessionID() throws GeneralSecurityException {
        return Extensions.getMachineUUID();
    }

    public static byte[] generateEncryptionBytes(int n, boolean bl) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                while ((byArray[i] & 0xFF) == 0) {
                    byArray[i] = (byte)secureRandom.nextInt();
                }
            }
        }
        return byArray;
    }

    public static String expandEnvironmentVariables(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Map<String, String> map = System.getenv();
        Matcher matcher = Pattern.compile("%[A-Za-z_]+%").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = string.substring(matcher.start() + 1, matcher.end() - 1);
            String string3 = map.get(string2);
            matcher.appendReplacement(stringBuffer, string3 == null ? "" : string3);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encodeQueryString(HashMap<String, String> hashMap) {
        Extensions.assertArgumentNonNull(hashMap);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            String string = Extensions.urlEncode(entry.getKey());
            stringBuilder.append(string);
            stringBuilder.append("=");
            String string2 = Extensions.urlEncode(entry.getValue());
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getSingleValue(HashMap<String, ArrayList<String>> hashMap, String string) {
        ArrayList<String> arrayList = hashMap.get(string);
        return arrayList == null ? null : arrayList.get(0);
    }

    public static HashMap<String, ArrayList<String>> decodeQueryString(String string) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        if (string != null) {
            if (string.startsWith("?")) {
                string = string.substring(1);
            }
            for (String string2 : string.split("&")) {
                String[] stringArray = string2.split("=");
                String string3 = Extensions.urlDecode(stringArray[0]);
                String string4 = stringArray.length < 2 ? "" : Extensions.urlDecode(stringArray[1]);
                ArrayList<String> arrayList = hashMap.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(string3, arrayList);
                }
                arrayList.add(string4);
            }
        }
        return hashMap;
    }

    public static void writeTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String convertBothSlashesToChar(String string, char c) {
        if (string == null) {
            return null;
        }
        if (c != '\\') {
            string = string.replace('\\', c);
        }
        if (c != '/') {
            string = string.replace('/', c);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFiles(File file, File file2, boolean bl) throws IOException {
        Extensions.ensureDirectoryExists(file2);
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        for (File file3 : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (!file4.createNewFile() && !bl) continue;
            try {
                fileInputStream = new FileInputStream(file3);
                outputStream = new FileOutputStream(file4);
                Extensions.writeTo(fileInputStream, outputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public static void visitMethods(Class<?> clazz, boolean bl, boolean bl2, MethodVisitor methodVisitor) {
        AccessibleObject[] accessibleObjectArray;
        if (clazz == null) {
            return;
        }
        AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        if (bl) {
            Method.setAccessible(accessibleObjectArray, true);
        }
        for (AccessibleObject annotatedElement : accessibleObjectArray) {
            if (methodVisitor.visitMethod((Method)annotatedElement)) continue;
            return;
        }
        if (bl2 && bl) {
            for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
                Extensions.visitMethods(annotatedElement, bl, bl2, methodVisitor);
            }
            Extensions.visitMethods(clazz.getSuperclass(), bl, bl2, methodVisitor);
        }
    }

    public static Method demandPublicMethod(Class<?> clazz, String string) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        throw new NoSuchMethodException(string);
    }

    public static void findMethods(Class<?> clazz, boolean bl, boolean bl2, MethodSearchSpecifier ... methodSearchSpecifierArray) {
        final ArrayList<MethodSearchSpecifier> arrayList = new ArrayList<MethodSearchSpecifier>(Arrays.asList(methodSearchSpecifierArray));
        final PriorityQueue priorityQueue = new PriorityQueue();
        Extensions.visitMethods(clazz, bl, bl2, new MethodVisitor(){

            public boolean visitMethod(Method method) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    MethodSearchSpecifier methodSearchSpecifier = (MethodSearchSpecifier)iterator.next();
                    if (!Extensions.equals(methodSearchSpecifier.methodName, method.getName()) || methodSearchSpecifier.optionalParamTypes != null && methodSearchSpecifier.optionalParamTypes.length != 0 && !Arrays.equals(methodSearchSpecifier.optionalParamTypes, method.getParameterTypes())) continue;
                    iterator.remove();
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class MethodSearchResult
                    implements Comparable<MethodSearchResult> {
                        public MethodSearchSpecifier specifier;
                        public Method method;

                        public MethodSearchResult(MethodSearchSpecifier methodSearchSpecifier, Method method) {
                            this.specifier = methodSearchSpecifier;
                            this.method = method;
                        }

                        @Override
                        public int compareTo(MethodSearchResult methodSearchResult) {
                            return this.specifier.priority - methodSearchResult.specifier.priority;
                        }
                    }
                    priorityQueue.add(new MethodSearchResult(methodSearchSpecifier, method));
                }
                return !arrayList.isEmpty();
            }
        });
        for (MethodSearchResult methodSearchResult : priorityQueue) {
            methodSearchResult.specifier.methodFound(methodSearchResult.method);
        }
    }

    public static Object getFieldValue(Object object, String string) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(string);
        field.setAccessible(true);
        return field.get(object);
    }

    public static Object invoke(Object object, String string, Object ... objectArray) throws Throwable {
        try {
            Method method = Extensions.demandPublicMethod(object.getClass(), string);
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public static Object invoke(Object object, Method method, Object ... objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static <T> boolean equals(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return TArray2 == null;
        }
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (Extensions.equals(TArray[i], TArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String joinNonNullOrEmpty(String string, String ... stringArray) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (Extensions.isNullOrEmpty(stringArray[i])) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void writeByteDefault(BufferStream bufferStream, byte by) throws IOException {
        bufferStream.write(new byte[]{by}, 0, 1);
    }

    public static int readUnsignedByteDefault(BufferStream bufferStream) throws IOException {
        byte[] byArray = new byte[1];
        if (bufferStream.read(byArray, 0, 1) <= 0) {
            return -1;
        }
        return Extensions.toUnsignedByte(byArray[0]);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.equals("");
    }

    public static String getEndPointStatusString(EndPointManager endPointManager, boolean bl) {
        try {
            String string = Resources.getString("EndPointStatus" + (Object)((Object)endPointManager.getStatus()) + (bl ? "Title" : "Description"));
            return String.format(string, endPointManager.getLastErrorMessage());
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static <T> List<T> copyToList(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static KeySet deriveKeys(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Mac mac;
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length != 32 || byArray3 == null || byArray3.length != 32) {
            throw new IllegalArgumentException();
        }
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(byArray, "HmacSHA256"));
        }
        catch (GeneralSecurityException generalSecurityException) {
            Constants.ExceptionTraceSource.traceException(generalSecurityException);
            return null;
        }
        KeySet keySet = new KeySet(byArray.length, 16);
        int n = keySet.getTotalByteLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byte[] byArray4 = Extensions.concatenateByteArrays(byArray2, byArray3);
        while (byteBuffer.hasRemaining()) {
            byte[] byArray5 = mac.doFinal(byArray4);
            byteBuffer.put(byArray5, 0, Math.min(byArray5.length, byteBuffer.remaining()));
            byArray4 = byArray5;
        }
        byteBuffer.flip();
        byteBuffer.get(keySet.clientWriteKey);
        byteBuffer.get(keySet.serverWriteKey);
        byteBuffer.get(keySet.clientWriteInitializationVector);
        byteBuffer.get(keySet.serverWriteInitializationVector);
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendWakeToken(byte[] byArray, InetAddress inetAddress) {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(new InetSocketAddress(inetAddress, 12287));
            datagramSocket.setBroadcast(true);
            datagramSocket.send(new DatagramPacket(byArray, byArray.length, new InetSocketAddress(InetAddress.getByAddress(Constants.LANBroadcastAddress), 9)));
        }
        catch (IOException iOException) {
            Constants.ExceptionTraceSource.traceException(iOException);
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
    }

    public static void stopCaptureStateDependentThreadRunners(Object[] objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof ThreadRunner) || object.getClass().getAnnotation(CaptureStateDependent.class) == null) continue;
            ((ThreadRunner)object).ensureRunState(false, true);
        }
    }

    public static ByteArraySegment joinSegments(List<ByteArraySegment> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        int n = 0;
        for (ByteArraySegment byteArraySegment : list) {
            n += byteArraySegment.count;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (ByteArraySegment byteArraySegment : list) {
            System.arraycopy(byteArraySegment.array, 0, object, n2, byteArraySegment.count);
            n2 += byteArraySegment.count;
        }
        return new ByteArraySegment((byte[])object);
    }

    public static <K, V> V getFromMapAndCreateIfNull(Map<? super K, V> map, K k, Factory<? extends V> factory) {
        V v = map.get(k);
        if (v == null) {
            v = factory.createInstance();
            map.put(k, v);
        }
        return v;
    }

    public static <E> E firstOrDefault(List<? extends E> list, Predicate<? super E> predicate, E e) {
        for (E e2 : list) {
            if (predicate != null && !predicate.check(e2)) continue;
            return e2;
        }
        return e;
    }

    public static <E> E firstOrDefault(List<? extends E> list, Predicate<? super E> predicate) {
        return Extensions.firstOrDefault(list, predicate, null);
    }

    public static TraceSource createTraceSource(Class<?> clazz) {
        final String string = clazz.getSimpleName();
        return new TraceSource(){

            public void traceException(Throwable throwable) {
                System.out.println(string + ":");
                throwable.printStackTrace();
            }

            public void traceWarning(String string2, Object ... objectArray) {
                this.trace(string2, objectArray);
            }

            public void traceMessage(String string2, Object ... objectArray) {
                this.trace(string2, objectArray);
            }

            private void trace(String string2, Object ... objectArray) {
                System.out.printf(string + ": " + string2, objectArray);
                System.out.println();
            }
        };
    }

    public static String getParticipantNameText(String string) {
        if (!Extensions.isNullOrEmpty(string)) {
            return string;
        }
        return Resources.getString("GuestAnonymousName");
    }

    public static int getCombinedHashCode(int n, Object ... objectArray) {
        return Extensions.getCombinedHashCode(n, Arrays.asList(objectArray));
    }

    public static int getCombinedHashCode(int n, Iterable<?> iterable) {
        int n2 = n;
        if (iterable != null) {
            for (Object obj : iterable) {
                if (obj == null) continue;
                n2 ^= obj.hashCode();
            }
        }
        return n2;
    }

    public static boolean isOnWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isOnAndroid() {
        return System.getProperty("java.vm.name").startsWith("Dalvik");
    }

    public static boolean isOnMac() {
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runCommandLineCommands(int n, int n2, String string) {
        String[] stringArray = Extensions.isOnWindows() ? new String[]{"cmd.exe"} : (Extensions.isOnAndroid() ? new String[]{"/system/bin/sh", "-c", string} : new String[]{"/bin/sh", "-c", string});
        if (n2 < 0) {
            n2 = 0;
        }
        Pattern pattern = Pattern.compile("." + (n2 > 0 ? "{0," + n2 + "}" : "*"), 32);
        Scanner scanner = null;
        ExecutorService executorService = null;
        try {
            Object object;
            Object object2;
            final Process process = new ProcessBuilder(stringArray).redirectErrorStream(true).start();
            scanner = new Scanner(process.getInputStream());
            if (Extensions.isOnWindows()) {
                object2 = null;
                object = null;
                try {
                    object2 = new PrintWriter(new BufferedOutputStream(process.getOutputStream()), true);
                    object = new Scanner(string);
                    while (((Scanner)object).hasNextLine()) {
                        ((PrintWriter)object2).println(((Scanner)object).nextLine());
                    }
                    ((PrintWriter)object2).println("exit");
                }
                finally {
                    if (object2 != null) {
                        ((PrintWriter)object2).close();
                    }
                    if (object != null) {
                        ((Scanner)object).close();
                    }
                }
            }
            executorService = Executors.newSingleThreadScheduledExecutor();
            object2 = executorService.schedule(new Runnable(){

                public void run() {
                    process.destroy();
                    try {
                        process.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        Constants.ExceptionTraceSource.traceException(iOException);
                    }
                }
            }, n, TimeUnit.MILLISECONDS);
            object = scanner.findWithinHorizon(pattern, n2);
            scanner.useDelimiter("");
            if (scanner.hasNext()) {
                object = (String)object + String.format("%nOutput was truncated to %d characters.%n", ((String)object).length());
            }
            while (scanner.hasNext()) {
                scanner.skip(pattern);
            }
            process.waitFor();
            if (!object2.cancel(false)) {
                object = (String)object + String.format("Timed out after %d milliseconds.%n", n);
            }
            Object object3 = object;
            return object3;
        }
        catch (Exception exception) {
            Constants.ExceptionTraceSource.traceException(exception);
            String string2 = null;
            return string2;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    public static Messages.CommandMessage runCommandMessage(Messages.CommandMessage commandMessage) {
        String string = null;
        try {
            string = Extensions.runCommandLineCommands(commandMessage.runCommandKillAfterMilliseconds.intValue(), commandMessage.maxResultCharacterCount.intValue(), commandMessage.text);
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        return new Messages.CommandMessage(string);
    }

    public static void tryTransferFilesOnThread(final FileUserInterfaceManager fileUserInterfaceManager, final VirtualFileReceiver virtualFileReceiver, final Messages.VirtualFileInfo[] virtualFileInfoArray, final FileAction fileAction) {
        if (virtualFileInfoArray != null) {
            Thread thread = Extensions.createThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    File file = fileUserInterfaceManager.getBaseDirectory();
                    Extensions.ensureDirectoryExists(file);
                    fileUserInterfaceManager.activateExplorerWindow();
                    for (Messages.VirtualFileInfo virtualFileInfo : virtualFileInfoArray) {
                        File file2 = new File(file, virtualFileInfo.filePath);
                        try {
                            InputStream inputStream = null;
                            FileOutputStream fileOutputStream = null;
                            try {
                                fileOutputStream = new FileOutputStream(file2);
                                inputStream = virtualFileReceiver.openReadStream(virtualFileInfo.id);
                                Extensions.writeTo(inputStream, fileOutputStream);
                            }
                            catch (Throwable throwable) {
                                Extensions.closeQuietly(inputStream);
                                Extensions.closeQuietly(fileOutputStream);
                                throw throwable;
                            }
                            Extensions.closeQuietly(inputStream);
                            Extensions.closeQuietly(fileOutputStream);
                            if (virtualFileInfo.lastWriteTime != null) {
                                file2.setLastModified(virtualFileInfo.lastWriteTime.getTime());
                            }
                            if (fileAction == FileAction.TRANSFER) continue;
                            fileUserInterfaceManager.runFile(file2.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            Constants.ExceptionTraceSource.traceException(exception);
                            file2.delete();
                        }
                    }
                }
            }, "DownloadFiles", 5);
            thread.start();
        }
    }

    public static String getExtension(String string) {
        if (Extensions.isNullOrEmpty(string)) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean containsAnyIgnoreCase(String string, String ... stringArray) {
        String string2 = string.toLowerCase();
        for (String string3 : stringArray) {
            if (!string2.contains(string3.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static int ceilingDivide(int n, int n2) {
        return n / n2 + (int)(Math.signum(n2) * Math.signum(n % n2));
    }

    public static int toUnsignedByte(byte by) {
        return by & 0xFF;
    }

    public static <T> boolean dequeueUntil(Queue<T> queue, T t) {
        while (!queue.isEmpty()) {
            if (queue.peek().equals(t)) {
                return true;
            }
            queue.remove();
        }
        return false;
    }

    public static <T> boolean intersectsWith(Set<T> set, Set<T> set2) {
        for (T t : set) {
            if (!set2.contains(t)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean check(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<T> {
        public T createInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MethodSearchSpecifier {
        public String methodName;
        public int priority;
        public Class<?>[] optionalParamTypes;

        public MethodSearchSpecifier(int n, String string, Class<?> ... classArray) {
            this.methodName = string;
            this.priority = n;
            this.optionalParamTypes = classArray;
        }

        public abstract void methodFound(Method var1);
    }

    public static interface MethodVisitor {
        public boolean visitMethod(Method var1);
    }
}

