/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Extensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileData {
    public abstract String getFilePath();

    public abstract Date getCreationTime();

    public abstract Date getLastWriteTime();

    public abstract Date getLastAccessTime();

    public abstract Long getSize();

    public abstract Boolean getIsDirectory();

    public abstract InputStream openReadStream() throws IOException;

    public static FileData[] getFileDatas(File[] fileArray) {
        Extensions.assertArgumentNonNull(fileArray);
        ArrayList<FileData> arrayList = new ArrayList<FileData>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getParent();
            if (string == null) {
                string = "";
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            FileData.populateFileDatas(arrayList, string, fileArray[i]);
        }
        return arrayList.toArray(new FileData[arrayList.size()]);
    }

    private static void populateFileDatas(List<FileData> list, String string, File file) {
        if (!file.exists()) {
            return;
        }
        DiskFileData diskFileData = new DiskFileData(string, file);
        list.add(diskFileData);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileData.populateFileDatas(list, string, file2);
            }
        }
    }

    private static class DiskFileData
    extends FileData {
        String basePath;
        File file;
        Date time;

        public DiskFileData(String string, File file) {
            this.basePath = Extensions.assertArgumentNonNull(string);
            this.file = Extensions.assertArgumentNonNull(file);
            long l = file.lastModified();
            if (l != 0L) {
                this.time = new Date(l);
            }
        }

        public String getFilePath() {
            return this.file.getAbsolutePath().substring(this.basePath.length());
        }

        public Date getCreationTime() {
            return this.time;
        }

        public Date getLastWriteTime() {
            return this.time;
        }

        public Date getLastAccessTime() {
            return this.time;
        }

        public Boolean getIsDirectory() {
            return this.file.isDirectory();
        }

        public Long getSize() {
            return this.file.length();
        }

        public InputStream openReadStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

