/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.CoreSize;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.IntArraySegment;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.MonitorManager;
import com.elsitech.screenconnect.ScreenCapturer;
import com.elsitech.screenconnect.ScreenCodec;
import com.elsitech.screenconnect.WaitChecker;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IncrementalScreenCapturer
extends ScreenCapturer {
    int minFrameIntervalMilliseconds;
    int maxFrameIntervalMilliseconds;
    int frameDelayMultiple;

    public IncrementalScreenCapturer(MessagePreparerListener messagePreparerListener, WaitChecker waitChecker, int n, int n2, int n3) {
        super(messagePreparerListener, waitChecker);
        this.minFrameIntervalMilliseconds = n;
        this.maxFrameIntervalMilliseconds = n2;
        this.frameDelayMultiple = n3;
    }

    protected abstract MonitorManager[] createMonitorManagers() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run(HashMap<Integer, ScreenCodec> hashMap) throws Throwable {
        MonitorManager[] monitorManagerArray = this.createMonitorManagers();
        try {
            while (!this.isStopping()) {
                int n;
                boolean bl = false;
                CoreRect[] coreRectArray = new CoreRect[monitorManagerArray.length];
                CoreRect[] coreRectArray2 = new CoreRect[monitorManagerArray.length];
                CoreRect[] coreRectArray3 = new CoreRect[monitorManagerArray.length];
                int[][][] nArrayArray = new int[monitorManagerArray.length][][];
                int[][][] nArrayArray2 = new int[monitorManagerArray.length][][];
                CoreRect coreRect = new CoreRect();
                for (n = 0; n < monitorManagerArray.length; coreRect = coreRect.union(coreRectArray[n]), ++n) {
                    coreRectArray[n] = monitorManagerArray[n].captureMonitor(null);
                }
                for (n = 0; n < monitorManagerArray.length; ++n) {
                    coreRectArray2[n] = coreRectArray[n].offset(-coreRect.x, -coreRect.y);
                    coreRectArray3[n] = IncrementalScreenCapturer.getTilesFromBounds(new CoreRect(0, 0, coreRectArray2[n].width, coreRectArray2[n].height), 32);
                    nArrayArray[n] = new int[coreRectArray3[n].height][coreRectArray3[n].width];
                    nArrayArray2[n] = new int[coreRectArray3[n].height][coreRectArray3[n].width];
                }
                Messages.DesktopSizeMessage2 desktopSizeMessage2 = new Messages.DesktopSizeMessage2();
                desktopSizeMessage2.size = coreRect.getSize();
                desktopSizeMessage2.monitorVirtualBounds = coreRectArray2;
                this.messageReady(desktopSizeMessage2);
                this.setViewport(this.getUseFastScreenStart() ? new CoreRect(0, 0, desktopSizeMessage2.size.width, desktopSizeMessage2.size.height) : null);
                try {
                    block14: while (!this.isStopping()) {
                        int n2 = this.getCodecID();
                        CoreRect coreRect2 = this.getViewport();
                        if (coreRect2 == null || coreRect2.isEmpty() || this.shouldWait()) {
                            this.waitUnlessSignaled(10L);
                            continue;
                        }
                        long l = System.currentTimeMillis();
                        int n3 = 0;
                        while (true) {
                            CoreRect coreRect3;
                            if (n3 < monitorManagerArray.length) {
                                CoreRect coreRect4 = coreRect2.intersection(coreRectArray2[n3]);
                                if (!coreRect4.isEmpty()) {
                                    Object object;
                                    CoreRect coreRect5 = coreRect4.offset(-coreRectArray2[n3].x, -coreRectArray2[n3].y);
                                    coreRect3 = IncrementalScreenCapturer.getTilesFromBounds(coreRect5, 32);
                                    CoreRect coreRect6 = IncrementalScreenCapturer.getBoundsFromTiles(coreRect3, 32, coreRectArray[n3].getSize());
                                    if (bl) {
                                        bl = false;
                                    } else {
                                        object = monitorManagerArray[n3].captureMonitor(coreRect6);
                                        if (!((CoreRect)object).equals(coreRectArray[n3])) {
                                            throw new InvalidScreenException();
                                        }
                                    }
                                    object = monitorManagerArray[n3].acquireBitmapData(coreRect6);
                                    try {
                                        IncrementalScreenCapturer.hashTiles(nArrayArray[n3], (BitmapData)object, coreRect3, 32, n2);
                                    }
                                    finally {
                                        monitorManagerArray[n3].releaseBitmapData((BitmapData)object);
                                    }
                                }
                            } else {
                                CoreRect coreRect7;
                                long l2 = System.currentTimeMillis();
                                long l3 = Extensions.getBoundedValue(this.minFrameIntervalMilliseconds, (l2 - l) * (long)this.frameDelayMultiple, this.maxFrameIntervalMilliseconds);
                                long l4 = l + l3;
                                long l5 = l4 - l2;
                                if (l5 <= 0L) continue block14;
                                this.waitUnlessSignaled(l5);
                                continue block14;
                                while ((coreRect7 = IncrementalScreenCapturer.cleanDirtyScreenTiles(nArrayArray[n3], nArrayArray2[n3], coreRect3.x, coreRect3.y, coreRect3.width, coreRect3.height)) != null) {
                                    CoreRect coreRect8 = IncrementalScreenCapturer.getBoundsFromTiles(coreRect7, 32, coreRectArray[n3].getSize());
                                    Messages.ScreenStartMessage screenStartMessage = new Messages.ScreenStartMessage();
                                    screenStartMessage.bounds = new CoreRect(coreRect8.x + coreRectArray2[n3].x, coreRect8.y + coreRectArray2[n3].y, coreRect8.width, coreRect8.height);
                                    screenStartMessage.codecID = n2;
                                    this.messageReady(screenStartMessage);
                                    BitmapData bitmapData = monitorManagerArray[n3].acquireBitmapData(coreRect8);
                                    try {
                                        this.encode(hashMap, n2, bitmapData);
                                    }
                                    finally {
                                        monitorManagerArray[n3].releaseBitmapData(bitmapData);
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                }
                catch (InvalidScreenException invalidScreenException) {
                }
            }
            return;
        }
        finally {
            MonitorManager[] monitorManagerArray2 = monitorManagerArray;
            int n = monitorManagerArray2.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n) {
                }
                MonitorManager monitorManager = monitorManagerArray2[n4];
                monitorManager.close();
                ++n4;
            }
        }
    }

    private static CoreRect getTilesFromBounds(CoreRect coreRect, int n) {
        int n2 = coreRect.x >= 0 ? coreRect.x / n : -Extensions.divUp(-coreRect.x, n);
        int n3 = coreRect.y >= 0 ? coreRect.y / n : -Extensions.divUp(-coreRect.y, n);
        int n4 = coreRect.x + coreRect.width >= 0 ? Extensions.divUp(coreRect.x + coreRect.width, n) : coreRect.x + coreRect.width / n;
        int n5 = coreRect.y + coreRect.height >= 0 ? Extensions.divUp(coreRect.y + coreRect.height, n) : coreRect.y + coreRect.height / n;
        return new CoreRect(n2, n3, n4 - n2, n5 - n3);
    }

    private static CoreRect getBoundsFromTiles(CoreRect coreRect, int n, CoreSize coreSize) {
        int n2 = coreRect.x * n;
        int n3 = coreRect.y * n;
        int n4 = Math.min((coreRect.x + coreRect.width) * n, coreSize.width);
        int n5 = Math.min((coreRect.y + coreRect.height) * n, coreSize.height);
        return new CoreRect(n2, n3, n4 - n2, n5 - n3);
    }

    private static boolean areScreenTilesDirty(int[][] nArray, int[][] nArray2, int n, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n + n3;
        for (int i = n2; i < n5; ++i) {
            for (int j = n; j < n6; ++j) {
                if (nArray[i][j] != nArray2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean cleanScreenTile(int[][] nArray, int[][] nArray2, int n, int n2) {
        if (nArray[n2][n] == nArray2[n2][n]) {
            return false;
        }
        nArray2[n2][n] = nArray[n2][n];
        return true;
    }

    private static void cleanScreenTiles(int[][] nArray, int[][] nArray2, int n, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n + n3;
        for (int i = n2; i < n5; ++i) {
            for (int j = n; j < n6; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
    }

    private static CorePoint cleanFirstDirtyScreenTile(int[][] nArray, int[][] nArray2, int n, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n + n3;
        for (int i = n2; i < n5; ++i) {
            for (int j = n; j < n6; ++j) {
                if (!IncrementalScreenCapturer.cleanScreenTile(nArray, nArray2, j, i)) continue;
                return new CorePoint(j, i);
            }
        }
        return null;
    }

    private static CoreRect cleanDirtyScreenTiles(int[][] nArray, int[][] nArray2, int n, int n2, int n3, int n4) {
        CorePoint corePoint = IncrementalScreenCapturer.cleanFirstDirtyScreenTile(nArray, nArray2, n, n2, n3, n4);
        if (corePoint == null) {
            return null;
        }
        return IncrementalScreenCapturer.cleanDirtyScreenTiles(nArray, nArray2, n, n2, n3, n4, corePoint.x, corePoint.y);
    }

    private static CoreRect cleanDirtyScreenTiles(int[][] nArray, int[][] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = 1;
        for (n7 = 1; n7 < 40 && n7 < 300 && n5 + n7 < n + n3 && IncrementalScreenCapturer.cleanScreenTile(nArray, nArray2, n5 + n7, n6); ++n7) {
        }
        while (n7 * (n8 + 1) <= 300 && n6 + n8 < n2 + n4 && IncrementalScreenCapturer.areScreenTilesDirty(nArray, nArray2, n5, n6 + n8, n7, 1)) {
            IncrementalScreenCapturer.cleanScreenTiles(nArray, nArray2, n5, n6 + n8, n7, 1);
            ++n8;
        }
        return new CoreRect(n5, n6, n7, n8);
    }

    private static void hashTiles(int[][] nArray, BitmapData bitmapData, CoreRect coreRect, int n, int n2) {
        int n3;
        int n4;
        int n5 = coreRect.x + coreRect.width;
        int n6 = coreRect.y + coreRect.height;
        int[] nArray2 = new int[coreRect.width];
        int n7 = bitmapData.getHeight();
        for (n4 = 0; n4 < coreRect.width; ++n4) {
            nArray2[n4] = n;
            if (n4 != coreRect.width - 1 || (n3 = bitmapData.getWidth() % n) == 0) continue;
            nArray2[n4] = n3;
        }
        for (n4 = coreRect.y; n4 < n6; ++n4) {
            for (n3 = coreRect.x; n3 < n5; ++n3) {
                nArray[n4][n3] = n2;
            }
        }
        n4 = coreRect.y;
        for (n3 = 0; n3 < n7; ++n3) {
            IntArraySegment intArraySegment = bitmapData.getRowRgbPixelData(n3);
            int n8 = intArraySegment.offset;
            int n9 = coreRect.x;
            int n10 = 0;
            while (n9 < n5) {
                for (int i = 0; i < nArray2[n10]; ++i) {
                    int[] nArray3 = nArray[n4];
                    int n11 = n9;
                    nArray3[n11] = nArray3[n11] ^ (nArray[n4][n9] << 5) + intArraySegment.array[n8++] + (nArray[n4][n9] >> 2);
                }
                ++n9;
                ++n10;
            }
            if ((n3 + 1) % n != 0) continue;
            ++n4;
        }
    }

    private class InvalidScreenException
    extends Exception {
        private InvalidScreenException() {
        }
    }
}

