/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.GenericMessageProperty;
import com.elsitech.screenconnect.Message;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.SerializationReflectException;
import com.elsitech.screenconnect.Tuple;
import com.elsitech.screenconnect.TypeSerializer;
import com.elsitech.screenconnect.TypeSerializers;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageSerializer {
    private HashMap<Byte, MessageSerializationInfo> idMap;
    private HashMap<Class<?>, MessageSerializationInfo> typeMap;

    private void initialize() {
        HashMap<Tuple.TuplePair<Type, Type>, TypeSerializerWrapper> hashMap = new HashMap<Tuple.TuplePair<Type, Type>, TypeSerializerWrapper>();
        for (Class<?> clazz : TypeSerializers.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) continue;
            for (Type object : clazz.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(object instanceof ParameterizedType) || !TypeSerializer.class.equals((Object)(parameterizedType = (ParameterizedType)object).getRawType())) continue;
                try {
                    TypeSerializerWrapper illegalAccessException = new TypeSerializerWrapper();
                    illegalAccessException.instance = clazz.newInstance();
                    MessageSerializer.initializeTypeSerializerWrapper(illegalAccessException);
                    Type type = parameterizedType.getActualTypeArguments()[0];
                    hashMap.put(new Tuple.TuplePair<Type, Object>(type, null), illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new SerializationReflectException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SerializationReflectException(illegalAccessException);
                }
            }
        }
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Class<?> clazz : Messages.class.getClasses()) {
            Message message = clazz.getAnnotation(Message.class);
            if (message == null || Modifier.isAbstract(clazz.getModifiers())) continue;
            MessageSerializationInfo messageSerializationInfo = new MessageSerializationInfo();
            messageSerializationInfo.messageID = message.messageID();
            messageSerializationInfo.type = clazz;
            messageSerializationInfo.propertySerializers = MessageSerializer.getPropertySerializers(messageSerializationInfo.type, hashMap);
            hashMap2.put(messageSerializationInfo.messageID, messageSerializationInfo);
            hashMap3.put(messageSerializationInfo.type, messageSerializationInfo);
        }
        this.idMap = hashMap2;
        this.typeMap = hashMap3;
    }

    public void serialize(DataOutput dataOutput, Object object) throws IOException {
        Extensions.assertArgumentNonNull(dataOutput);
        Extensions.assertArgumentNonNull(object);
        if (this.typeMap == null) {
            this.initialize();
        }
        Class<?> clazz = object.getClass();
        MessageSerializationInfo messageSerializationInfo = Extensions.demand(this.typeMap, clazz);
        dataOutput.writeByte(messageSerializationInfo.messageID);
        MessageSerializer.serializeProperties(dataOutput, messageSerializationInfo.propertySerializers, object);
    }

    public Object deserialize(DataInput dataInput, Class<?> clazz) throws IOException {
        Extensions.assertArgumentNonNull(dataInput);
        byte by = dataInput.readByte();
        if (this.idMap == null) {
            this.initialize();
        }
        MessageSerializationInfo messageSerializationInfo = Extensions.demand(this.idMap, by);
        if (clazz != null && !clazz.isAssignableFrom(messageSerializationInfo.type)) {
            throw new IllegalStateException("Message must be type " + clazz + " but was " + messageSerializationInfo.type);
        }
        try {
            Object obj = messageSerializationInfo.type.newInstance();
            MessageSerializer.deserializeProperties(dataInput, messageSerializationInfo.propertySerializers, obj);
            return obj;
        }
        catch (InstantiationException instantiationException) {
            throw new SerializationReflectException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializationReflectException(illegalAccessException);
        }
    }

    private static void serializeProperties(DataOutput dataOutput, ArrayList<PropertySerializer> arrayList, Object object) throws IOException {
        try {
            for (PropertySerializer propertySerializer : arrayList) {
                Object object2 = object == null ? null : propertySerializer.property.get(object);
                MessageSerializer.invoke(propertySerializer.serializer.instance, propertySerializer.serializer.serializeMethod, dataOutput, object2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializationReflectException(illegalAccessException);
        }
    }

    private static void deserializeProperties(DataInput dataInput, ArrayList<PropertySerializer> arrayList, Object object) throws IOException {
        try {
            for (PropertySerializer propertySerializer : arrayList) {
                Object object2 = MessageSerializer.invoke(propertySerializer.serializer.instance, propertySerializer.serializer.deserializeMethod, dataInput);
                propertySerializer.property.set(object, object2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializationReflectException(illegalAccessException);
        }
    }

    private static ArrayList<PropertySerializer> getPropertySerializers(Class<?> clazz, HashMap<Tuple.TuplePair<Type, Type>, TypeSerializerWrapper> hashMap) {
        ArrayList<PropertySerializer> arrayList = new ArrayList<PropertySerializer>();
        for (Field field : Extensions.getOrderedFields(clazz)) {
            GenericMessageProperty genericMessageProperty = field.getAnnotation(GenericMessageProperty.class);
            TypeSerializerWrapper typeSerializerWrapper = MessageSerializer.getTypeSerializerWrapper(field.getType(), genericMessageProperty == null ? null : genericMessageProperty.typeArgument(), hashMap);
            PropertySerializer propertySerializer = new PropertySerializer(field, typeSerializerWrapper);
            arrayList.add(propertySerializer);
        }
        return arrayList;
    }

    private static TypeSerializerWrapper getTypeSerializerWrapper(Class<?> clazz, Class<?> clazz2, HashMap<Tuple.TuplePair<Type, Type>, TypeSerializerWrapper> hashMap) {
        Tuple.TuplePair tuplePair = new Tuple.TuplePair(clazz, clazz2);
        TypeSerializerWrapper typeSerializerWrapper = hashMap.get(tuplePair);
        if (typeSerializerWrapper == null) {
            typeSerializerWrapper = new TypeSerializerWrapper();
            hashMap.put(tuplePair, typeSerializerWrapper);
            if (clazz.isArray()) {
                Class<?> clazz3 = clazz.getComponentType();
                TypeSerializerWrapper typeSerializerWrapper2 = MessageSerializer.getTypeSerializerWrapper(clazz3, null, hashMap);
                typeSerializerWrapper.instance = new ArraySerializer(clazz3, typeSerializerWrapper2);
            } else if (clazz.isEnum()) {
                typeSerializerWrapper.instance = new EnumSerializer(clazz);
            } else if (EnumSet.class.isAssignableFrom(clazz)) {
                typeSerializerWrapper.instance = new EnumSetSerializer(clazz2);
            } else {
                ArrayList<PropertySerializer> arrayList = MessageSerializer.getPropertySerializers(clazz, hashMap);
                typeSerializerWrapper.instance = new ComplexSerializer(clazz, arrayList);
            }
            MessageSerializer.initializeTypeSerializerWrapper(typeSerializerWrapper);
        }
        return typeSerializerWrapper;
    }

    private static void initializeTypeSerializerWrapper(TypeSerializerWrapper typeSerializerWrapper) {
        try {
            Class<?> clazz = typeSerializerWrapper.instance.getClass();
            typeSerializerWrapper.serializeMethod = Extensions.demandPublicMethod(clazz, "serialize");
            typeSerializerWrapper.deserializeMethod = Extensions.demandPublicMethod(clazz, "deserialize");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SerializationReflectException(noSuchMethodException);
        }
    }

    private static Object invoke(Object object, Method method, Object ... objectArray) throws IOException {
        try {
            return Extensions.invoke(object, method, objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new SerializationReflectException(throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumSetSerializer
    extends EnumIntConverter
    implements TypeSerializer<EnumSet<?>> {
        private Class enumType;

        public EnumSetSerializer(Class<?> clazz) {
            super(clazz);
            this.enumType = clazz;
        }

        @Override
        public void serialize(DataOutput dataOutput, EnumSet<?> enumSet) throws IOException {
            long l = 0L;
            if (enumSet != null) {
                for (Enum enum_ : enumSet) {
                    l |= 1L << enum_.ordinal();
                }
            }
            Extensions.write7BitEncodedLong(dataOutput, l);
        }

        @Override
        public EnumSet<?> deserialize(DataInput dataInput) throws IOException {
            EnumSet<Enum<?>> enumSet = EnumSet.noneOf(this.enumType);
            int n = 0;
            long l = Extensions.read7BitEncodedLong(dataInput);
            while (l != 0L) {
                if ((l & 1L) != 0L) {
                    enumSet.add(this.getEnumConstant(n));
                }
                l >>>= 1;
                ++n;
            }
            return enumSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumSerializer
    extends EnumIntConverter
    implements TypeSerializer<Enum<?>> {
        public EnumSerializer(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(DataOutput dataOutput, Enum<?> enum_) throws IOException {
            Extensions.write7BitEncodedInt(dataOutput, enum_ == null ? 0 : enum_.ordinal());
        }

        @Override
        public Enum<?> deserialize(DataInput dataInput) throws IOException {
            return this.getEnumConstant(Extensions.read7BitEncodedInt(dataInput));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class EnumIntConverter {
        private Enum<?>[] valueArray;

        public EnumIntConverter(Class<?> clazz) {
            this.valueArray = (Enum[])clazz.getEnumConstants();
        }

        protected Enum<?> getEnumConstant(int n) {
            return this.valueArray[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComplexSerializer
    implements TypeSerializer<Object> {
        private Class<?> type;
        private ArrayList<PropertySerializer> propertySerializers;

        public ComplexSerializer(Class<?> clazz, ArrayList<PropertySerializer> arrayList) {
            this.type = Extensions.assertArgumentNonNull(clazz);
            this.propertySerializers = Extensions.assertArgumentNonNull(arrayList);
        }

        @Override
        public void serialize(DataOutput dataOutput, Object object) throws IOException {
            MessageSerializer.serializeProperties(dataOutput, this.propertySerializers, object);
        }

        @Override
        public Object deserialize(DataInput dataInput) throws IOException {
            try {
                Object obj = this.type.newInstance();
                MessageSerializer.deserializeProperties(dataInput, this.propertySerializers, obj);
                return obj;
            }
            catch (InstantiationException instantiationException) {
                throw new SerializationReflectException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationReflectException(illegalAccessException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArraySerializer
    implements TypeSerializer<Object> {
        public Class<?> elementType;
        private TypeSerializerWrapper innerSerializer;

        public ArraySerializer(Class<?> clazz, TypeSerializerWrapper typeSerializerWrapper) {
            this.elementType = Extensions.assertArgumentNonNull(clazz);
            this.innerSerializer = Extensions.assertArgumentNonNull(typeSerializerWrapper);
        }

        @Override
        public void serialize(DataOutput dataOutput, Object object) throws IOException {
            Object[] objectArray = (Object[])object;
            int n = objectArray == null ? 0 : objectArray.length;
            Extensions.write7BitEncodedInt(dataOutput, n);
            for (int i = 0; i < n; ++i) {
                MessageSerializer.invoke(this.innerSerializer.instance, this.innerSerializer.serializeMethod, new Object[]{dataOutput, objectArray[i]});
            }
        }

        @Override
        public Object deserialize(DataInput dataInput) throws IOException {
            int n = Extensions.read7BitEncodedInt(dataInput);
            Object object = Array.newInstance(this.elementType, n);
            for (int i = 0; i < n; ++i) {
                Object object2 = MessageSerializer.invoke(this.innerSerializer.instance, this.innerSerializer.deserializeMethod, new Object[]{dataInput});
                Array.set(object, i, object2);
            }
            return object;
        }
    }

    private static class PropertySerializer {
        public Field property;
        public TypeSerializerWrapper serializer;

        public PropertySerializer(Field field, TypeSerializerWrapper typeSerializerWrapper) {
            this.property = field;
            this.serializer = typeSerializerWrapper;
        }
    }

    private static class TypeSerializerWrapper {
        public Object instance;
        public Method serializeMethod;
        public Method deserializeMethod;

        private TypeSerializerWrapper() {
        }
    }

    private static class MessageSerializationInfo {
        public byte messageID;
        public Class<?> type;
        public ArrayList<PropertySerializer> propertySerializers;

        private MessageSerializationInfo() {
        }
    }
}

