/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.CoreSize;
import com.elsitech.screenconnect.FileAction;
import com.elsitech.screenconnect.GenericMessageProperty;
import com.elsitech.screenconnect.Message;
import com.elsitech.screenconnect.Order;
import com.elsitech.screenconnect.ProcessType;
import com.elsitech.screenconnect.ScreenQualityLevel;
import java.util.Date;
import java.util.EnumSet;
import java.util.UUID;

public final class Messages {
    private Messages() {
    }

    @Message(messageID=90)
    public static class CommandMessage {
        @Order(value=0)
        public String text;
        @Order(value=1)
        public Long maxResultCharacterCount;
        @Order(value=2)
        public Long runCommandKillAfterMilliseconds;

        public CommandMessage() {
        }

        public CommandMessage(String string) {
            this.text = string;
        }
    }

    @Message(messageID=88)
    public static class WakeTokenMessage {
        public ByteArraySegment wakeToken;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GuestInfoAttribute {
        CREDENTIALS_STORED;

    }

    @Message(messageID=86)
    public static class GuestInfoMessage {
        @Order(value=0)
        public String loggedOnUserDomain;
        @Order(value=1)
        public String loggedOnUserName;
        @Order(value=2)
        public Long idleSeconds;
        @Order(value=3)
        public String machineName;
        @Order(value=4)
        public String machineDomain;
        @Order(value=5)
        public String operatingSystemName;
        @Order(value=6)
        public Version operatingSystemVersion;
        @Order(value=7)
        public String processorName;
        @Order(value=8)
        public Integer processorVirtualCount;
        @Order(value=9)
        public Long systemMemoryTotalMegabytes;
        @Order(value=10)
        public Long systemMemoryAvailableMegabytes;
        @Order(value=11)
        @GenericMessageProperty(typeArgument=GuestInfoAttribute.class)
        public EnumSet<GuestInfoAttribute> attributes;
        @Order(value=12)
        public ByteArraySegment wakeToken;
        @Order(value=13)
        public ByteArraySegment screenshotContentHash;
        @Order(value=14)
        public String screenshotContentType;
        @Order(value=15)
        public ByteArraySegment screenshotContent;
    }

    @Message(messageID=83)
    public static class ConsentMessage2 {
        @Order(value=0)
        public UUID connectionID;
        @Order(value=1)
        public Boolean consentOrRefuse;

        public ConsentMessage2() {
        }

        public ConsentMessage2(UUID uUID, boolean bl) {
            this.connectionID = uUID;
            this.consentOrRefuse = bl;
        }
    }

    @Message(messageID=30)
    public static class SetCaptureMessage {
        @Order(value=0)
        public Boolean captureScreen;
        @Order(value=1)
        public Boolean captureSound;
        @Order(value=2)
        public Boolean allowInput;

        public SetCaptureMessage() {
        }

        public SetCaptureMessage(boolean bl, boolean bl2, boolean bl3) {
            this.captureScreen = bl;
            this.captureSound = bl2;
            this.allowInput = bl3;
        }
    }

    @Message(messageID=60)
    public static class ChatMessage2
    extends ChatMessage {
        @Order(value=0)
        public ProcessType senderProcessType;
        @Order(value=1)
        public String senderName;
    }

    @Message(messageID=23)
    public static class ChatMessage {
        @Order(value=0)
        public String text;

        public ChatMessage() {
        }

        public ChatMessage(String string) {
            this.text = string;
        }
    }

    @Message(messageID=17)
    public static class ClipboardTextMessage {
        public String text;
    }

    @Message(messageID=6)
    public static class ViewportMessage {
        public CoreRect bounds;
    }

    public static class ToolboxItem {
        @Order(value=0)
        public ByteArraySegment image;
        @Order(value=1)
        public String name;
        @Order(value=2)
        public Boolean isDirectory;
        @Order(value=3)
        public ToolboxItem[] items;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolboxOperation {
        RUN_TOOL,
        CREATE_DIRECTORY,
        MOVE,
        DELETE;

    }

    @Message(messageID=63)
    public static class ToolboxOperationMessage
    extends FileMessage {
        @Order(value=0)
        public ToolboxOperation operation;
        @Order(value=1)
        public String path;
        @Order(value=2)
        public String originalPath;

        public ToolboxOperationMessage() {
        }

        public ToolboxOperationMessage(ToolboxOperation toolboxOperation, String string, String string2) {
            this.operation = toolboxOperation;
            this.path = string;
            this.originalPath = string2;
        }
    }

    @Message(messageID=62)
    public static class ToolboxMessage
    extends FileMessage {
        public ToolboxItem toolbox;
    }

    @Message(messageID=38)
    public static class FileDragEffectMessage
    extends FileMessage {
        public Integer effect;
    }

    @Message(messageID=37)
    public static class FildDragActionMessage
    extends FileMessage {
        public Integer action;
    }

    @Message(messageID=36)
    public static class FileDragStartMessage
    extends VirtualFilesMessage {
    }

    @Message(messageID=61)
    public static class TransferFilesMessage
    extends VirtualFilesMessage {
        public FileAction action;

        public TransferFilesMessage() {
        }

        public TransferFilesMessage(FileAction fileAction, VirtualFileInfo[] virtualFileInfoArray) {
            this.action = fileAction;
            this.files = virtualFileInfoArray;
        }
    }

    @Message(messageID=39)
    public static class ClipboardFilesMessage
    extends VirtualFilesMessage {
    }

    public static class VirtualFileInfo {
        @Order(value=0)
        public UUID id;
        @Order(value=1)
        public String filePath;
        @Order(value=2)
        public Date creationTime;
        @Order(value=3)
        public Date lastWriteTime;
        @Order(value=4)
        public Date lastAccessTime;
        @Order(value=5)
        public Long size;
        @Order(value=6)
        public Boolean isDirectory;
    }

    public static abstract class VirtualFilesMessage
    extends FileMessage {
        public VirtualFileInfo[] files;
    }

    @Message(messageID=42)
    public static class VirtualFileDataMessage
    extends VirtualFileMessage {
        public ByteArraySegment data;

        public VirtualFileDataMessage() {
        }

        public VirtualFileDataMessage(UUID uUID, ByteArraySegment byteArraySegment) {
            this.id = uUID;
            this.data = byteArraySegment;
        }
    }

    @Message(messageID=41)
    public static class RequestVirtualFileDataMessage
    extends VirtualFileControlMessage {
        public Long requestedPosition;

        public RequestVirtualFileDataMessage() {
        }

        public RequestVirtualFileDataMessage(UUID uUID, long l) {
            this.id = uUID;
            this.requestedPosition = l;
        }
    }

    @Message(messageID=40)
    public static class ReleaseVirtualFileMessage
    extends VirtualFileControlMessage {
        public ReleaseVirtualFileMessage() {
        }

        public ReleaseVirtualFileMessage(UUID uUID) {
            this.id = uUID;
        }
    }

    public static abstract class VirtualFileControlMessage
    extends VirtualFileMessage {
    }

    public static abstract class VirtualFileMessage
    extends FileMessage {
        public UUID id;
    }

    @Message(messageID=69)
    public static class ReceiveFolderMessage
    extends FileMessage {
    }

    @Message(messageID=22)
    public static class ReceiveFilesMessage
    extends FileMessage {
    }

    public static abstract class FileMessage {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SoundCaptureMode {
        Silent,
        Speakers,
        HostMicrophone,
        AllMicrophones;

    }

    @Message(messageID=93)
    public static class SetSoundCaptureModeMessage
    extends ControlMessage {
        public SoundCaptureMode mode;

        public SetSoundCaptureModeMessage() {
        }

        public SetSoundCaptureModeMessage(SoundCaptureMode soundCaptureMode) {
            this.mode = soundCaptureMode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CredentialsAction {
        PROMPT_FOR_STORAGE,
        SEND_TO_SCREEN;

    }

    @Message(messageID=75)
    public static class CredentialsActionMessage
    extends ControlMessage {
        public CredentialsAction action;

        public CredentialsActionMessage() {
        }

        public CredentialsActionMessage(CredentialsAction credentialsAction) {
            this.action = credentialsAction;
        }
    }

    @Message(messageID=26)
    public static class ScreenQualityLevelMessage
    extends ControlMessage {
        public ScreenQualityLevel level;

        public ScreenQualityLevelMessage() {
        }

        public ScreenQualityLevelMessage(ScreenQualityLevel screenQualityLevel) {
            this.level = screenQualityLevel;
        }
    }

    @Message(messageID=59)
    public static class BlockInputMessage
    extends ControlMessage {
        public Boolean blockOrUnblock;

        public BlockInputMessage() {
        }

        public BlockInputMessage(boolean bl) {
            this.blockOrUnblock = bl;
        }
    }

    @Message(messageID=35)
    public static class BlankMonitorMessage
    extends ControlMessage {
        public Boolean blankOrUnblank;

        public BlankMonitorMessage() {
        }

        public BlankMonitorMessage(boolean bl) {
            this.blankOrUnblank = bl;
        }
    }

    @Message(messageID=21)
    public static class RebootReconnectMessage
    extends ControlMessage {
        public Boolean safeMode;

        public RebootReconnectMessage() {
        }

        public RebootReconnectMessage(boolean bl) {
            this.safeMode = bl;
        }
    }

    @Message(messageID=16)
    public static class SystemKeyCodeMessage
    extends ControlMessage {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlConnectionAction {
        FORCE_DISCONNECT,
        STOP_CAPTURE,
        REQUEST_CAPTURE;

    }

    @Message(messageID=82)
    public static class ControlConnectionActionMessage2
    extends ControlMessage {
        @Order(value=0)
        public UUID connectionID;
        @Order(value=1)
        public ControlConnectionAction action;

        public ControlConnectionActionMessage2() {
        }

        public ControlConnectionActionMessage2(UUID uUID, ControlConnectionAction controlConnectionAction) {
            this.connectionID = uUID;
            this.action = controlConnectionAction;
        }
    }

    public static abstract class ControlMessage {
    }

    @Message(messageID=15)
    public static class MouseWheelMessage
    extends MouseMessage {
        public Integer delta;

        public MouseWheelMessage() {
        }

        public MouseWheelMessage(CorePoint corePoint, int n) {
            super(corePoint);
            this.delta = n;
        }
    }

    @Message(messageID=14)
    public static class MouseButtonMessage
    extends MouseMessage {
        @Order(value=0)
        public Integer button;
        @Order(value=1)
        public Boolean upOrDown;

        public MouseButtonMessage() {
        }

        public MouseButtonMessage(CorePoint corePoint, int n, boolean bl) {
            super(corePoint);
            this.button = n;
            this.upOrDown = bl;
        }
    }

    @Message(messageID=13)
    public static class MouseMessage
    extends InputMessage {
        public CorePoint position;

        public MouseMessage() {
        }

        public MouseMessage(CorePoint corePoint) {
            this.position = corePoint;
        }
    }

    public static interface KeyLocks {
        public static final int Caps = 1;
        public static final int Num = 2;
        public static final int Scroll = 4;
        public static final int Unknown = 0x8000000;
    }

    public static interface KeyModifiers {
        public static final int Shift = 1;
        public static final int Ctrl = 2;
        public static final int Alt = 4;
        public static final int Win = 8;
        public static final int Unknown = 0x8000000;
    }

    @Message(messageID=77)
    public static class KeyboardMessage2
    extends InputMessage {
        @Order(value=0)
        public String keyboardLayoutID;
        @Order(value=1)
        public Integer hardwareScanCode;
        @Order(value=2)
        public Integer windowsKeyCode;
        @Order(value=3)
        public Integer javaKeyCode;
        @Order(value=4)
        public Integer charProducedCount;
        @Order(value=5)
        public String charsProducedOrBuffered;
        @Order(value=6)
        public Integer modifiersDown;
        @Order(value=7)
        public Integer locksActive;
        @Order(value=8)
        public Boolean upOrDown;
    }

    public static abstract class InputMessage {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SegmentPosition {
        FIRST,
        LAST,
        MIDDLE;

    }

    @Message(messageID=92)
    public static class SoundMessage2
    extends SoundMessage {
        @Order(value=0)
        public UUID streamID;

        public String toString() {
            return "Sound message: id: " + this.streamID + "; position: " + (Object)((Object)this.segmentPosition) + "; frame count: " + this.frameCount + "; frame data: " + this.frameData;
        }
    }

    @Message(messageID=43)
    public static class SoundMessage
    extends CaptureMessage {
        @Order(value=0)
        public SegmentPosition segmentPosition;
        @Order(value=1)
        public Integer frameCount;
        @Order(value=2)
        public ByteArraySegment frameData;
    }

    @Message(messageID=20)
    public static class CustomCursorMessage
    extends CursorMessage {
        @Order(value=0)
        public ByteArraySegment colorImage;
        @Order(value=1)
        public ByteArraySegment maskImage;
        @Order(value=2)
        public CorePoint hotSpot;
    }

    @Message(messageID=9)
    public static class StandardCursorMessage
    extends CursorMessage {
        public Integer standardCursorID;
    }

    @Message(messageID=8)
    public static class CursorMessage
    extends CaptureMessage {
        @Order(value=0)
        public CorePoint position;
        @Order(value=1)
        public Integer cursorID;
    }

    @Message(messageID=25)
    public static class ScreenDataMessage
    extends ScreenMessage {
        public ByteArraySegment data;
    }

    @Message(messageID=24)
    public static class ScreenStartMessage
    extends ScreenMessage {
        @Order(value=0)
        public CoreRect bounds;
        @Order(value=1)
        public Integer codecID;
    }

    public static abstract class ScreenMessage
    extends CaptureMessage {
    }

    @Message(messageID=44)
    public static class DesktopSizeMessage2
    extends DesktopSizeMessage {
        public CoreRect[] monitorVirtualBounds;
    }

    @Message(messageID=11)
    public static class DesktopSizeMessage
    extends CaptureMessage {
        public CoreSize size;
    }

    public static abstract class CaptureMessage {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionConnectionAttribute {
        RENDER_SCREEN,
        _UNUSED,
        RENDER_SOUND,
        CAPTURE_SCREEN,
        CAPTURE_MICROPHONE_SOUND,
        CAPTURE_SPEAKERS_SOUND,
        INPUT_SENDER,
        INPUT_RECEIVER,
        FILE_TRANSFER,
        CAN_END_SESSION,
        INPUT_BLOCKED,
        MONITOR_BLANKED,
        FAST_SCREEN_START,
        CAPTURE_REQUESTED,
        CAN_RUN_SHARED_TOOL,
        CAN_MANAGE_SHARED_TOOLBOX,
        CONTROLLER,
        REFUSED_CONSENT,
        NEEDS_CONSENT;

    }

    public static class SessionConnectionInfo3 {
        @Order(value=0)
        public UUID connectionID;
        @Order(value=1)
        public ProcessType processType;
        @Order(value=2)
        public String participantName;
        @Order(value=3)
        @GenericMessageProperty(typeArgument=SessionConnectionAttribute.class)
        public EnumSet<SessionConnectionAttribute> attributes;
    }

    @Message(messageID=81)
    public static class SessionConnectionsChangedMessage3
    extends SystemMessage {
        @Order(value=0)
        public UUID currentConnectionID;
        @Order(value=1)
        public SessionConnectionInfo3[] connections;
    }

    @Message(messageID=28)
    public static class SessionNotLicensedMessage
    extends SessionWaitingMessage {
    }

    @Message(messageID=3)
    public static class SessionAlreadyConnectedMessage
    extends SessionWaitingMessage {
    }

    public static abstract class SessionWaitingMessage
    extends SystemMessage {
    }

    @Message(messageID=70)
    public static class SessionForceDisconnectedMessage
    extends SessionInvalidMessage {
    }

    @Message(messageID=51)
    public static class SessionAccessTokenInvalidMessage
    extends SessionInvalidMessage {
    }

    @Message(messageID=10)
    public static class SessionEndedMessage
    extends SessionInvalidMessage {
    }

    public static abstract class SessionInvalidMessage
    extends SystemMessage {
    }

    @Message(messageID=84)
    public static class CreateSessionMessage5
    extends CreateSessionMessage4 {
        public String[] customPropertyValues;

        public CreateSessionMessage5() {
        }

        public CreateSessionMessage5(UUID uUID, ProcessType processType, String string, String[] stringArray) {
            this.sessionID = uUID;
            this.processType = processType;
            this.name = string;
            this.customPropertyValues = stringArray;
        }
    }

    @Message(messageID=55)
    public static class CreateSessionMessage4
    extends CreateSessionMessage {
        public String name;
    }

    public static abstract class CreateSessionMessage
    extends InitiateSessionMessage {
    }

    @Message(messageID=71)
    public static class ConnectSessionMessage5
    extends ConnectSessionMessage4 {
        public String participantName;

        public ConnectSessionMessage5() {
        }

        public ConnectSessionMessage5(UUID uUID, ProcessType processType, ByteArraySegment byteArraySegment, String string) {
            super(uUID, processType, byteArraySegment);
            this.participantName = string;
        }
    }

    @Message(messageID=54)
    public static class ConnectSessionMessage4
    extends ConnectSessionMessage {
        public ByteArraySegment accessToken;

        public ConnectSessionMessage4() {
        }

        public ConnectSessionMessage4(UUID uUID, ProcessType processType, ByteArraySegment byteArraySegment) {
            this.sessionID = uUID;
            this.processType = processType;
            this.accessToken = byteArraySegment;
        }
    }

    public static abstract class ConnectSessionMessage
    extends InitiateSessionMessage {
    }

    public static abstract class InitiateSessionMessage
    extends SystemMessage {
        @Order(value=0)
        public UUID sessionID;
        @Order(value=1)
        public ProcessType processType;
    }

    @Message(messageID=94)
    public static class SessionStateMessage
    extends SystemMessage {
        @Order(value=0)
        public ScreenQualityLevel screenQualityLevel;
        @Order(value=1)
        public Integer soundCaptureMode;
        @Order(value=2)
        public Boolean monitorBlanked;
        @Order(value=3)
        public Boolean inputBlocked;
    }

    @Message(messageID=2)
    public static class SessionKeyInvalidMessage
    extends SystemMessage {
    }

    @Message(messageID=66)
    public static class ScreenCodecMessage
    extends SystemMessage {
        public Integer codecID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientType {
        UNKNOWN,
        DOT_NET_WIN_FORMS,
        JAVA_SWING,
        ANDROID,
        MONO_TOUCH_IOS;

    }

    @Message(messageID=65)
    public static class ClientTypeMessage
    extends SystemMessage {
        public ClientType type;

        public ClientTypeMessage() {
        }

        public ClientTypeMessage(ClientType clientType) {
            this.type = clientType;
        }
    }

    @Message(messageID=85)
    public static class RequestGuestInfoMessage
    extends SystemMessage {
        @Order(value=0)
        public ByteArraySegment currentScreenshotContentHash;
        @Order(value=1)
        public Integer screenshotMaxScalePercent;
        @Order(value=2)
        public Integer screenshotMaxPixelCount;
    }

    @Message(messageID=91)
    public static class ResetCaptureStateMessage2
    extends ResetCaptureStateMessage1 {
        public Long captureStateVersion;
    }

    @Message(messageID=58)
    public static class ResetCaptureStateMessage1
    extends SystemMessage {
    }

    @Message(messageID=19)
    public static class EndSessionMessage
    extends SystemMessage {
    }

    @Message(messageID=89)
    public static class SecureChannelMessage2
    extends SecureChannelMessage1 {
        public ByteArraySegment random;

        public SecureChannelMessage2() {
        }

        public SecureChannelMessage2(byte[] byArray, byte[] byArray2) {
            this.encryptedSecretKey = new ByteArraySegment(byArray);
            this.random = new ByteArraySegment(byArray2);
        }
    }

    @Message(messageID=53)
    public static class SecureChannelMessage1
    extends SystemMessage {
        public ByteArraySegment encryptedSecretKey;
    }

    public static class Version {
        @Order(value=0)
        public Integer major;
        @Order(value=1)
        public Integer minor;
        @Order(value=2)
        public Integer build;
        @Order(value=3)
        public Integer revision;

        public Version() {
        }

        public Version(String string) {
            if (string != null && string.length() != 0) {
                String[] stringArray = string.split("\\D+");
                if (stringArray.length > 0) {
                    this.major = Integer.parseInt(stringArray[0]);
                }
                if (stringArray.length > 1) {
                    this.minor = Integer.parseInt(stringArray[1]);
                }
                if (stringArray.length > 2) {
                    this.build = Integer.parseInt(stringArray[2]);
                }
                if (stringArray.length > 3) {
                    this.revision = Integer.parseInt(stringArray[3]);
                }
            }
        }
    }

    @Message(messageID=57)
    public static class VersionMessage
    extends SystemMessage {
        public Version version;

        public VersionMessage() {
        }

        public VersionMessage(Version version) {
            this.version = version;
        }
    }

    public static abstract class SystemMessage {
    }
}

