/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BlockBufferReadStream;
import com.elsitech.screenconnect.BlockBufferWriteStream;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.Extensions;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class NetworkConnection
implements Closeable {
    public Socket socket;
    public BufferStream.Listener writeStreamListener;
    public InputStream socketInputStream;
    public OutputStream socketOutputStream;
    public BlockBufferReadStream readStream;
    public BlockBufferWriteStream writeStream;
    public DataInput reader;
    public DataOutput writer;
    public boolean isDisposed;

    public NetworkConnection(Socket socket, BufferStream.Listener listener) {
        this.socket = socket;
        Extensions.assertArgumentNonNull(this.socket);
        this.writeStreamListener = listener;
        Extensions.assertArgumentNonNull(this.writeStreamListener);
    }

    private byte[] getBuffer(BufferStream bufferStream) {
        if (bufferStream.getBufferSegment().getBuffer().length == 0) {
            return new byte[1456];
        }
        return bufferStream.getBufferSegment().getBuffer();
    }

    public void initialize() throws IOException {
        this.socketInputStream = this.socket.getInputStream();
        this.socketOutputStream = this.socket.getOutputStream();
        this.readStream = new BlockBufferReadStream(new BufferStream.Listener(){

            public void needsBufferCycled(BufferStream bufferStream) throws IOException {
                byte[] byArray = NetworkConnection.this.getBuffer(NetworkConnection.this.readStream);
                int n = NetworkConnection.this.socketInputStream.read(byArray, 0, byArray.length);
                NetworkConnection.this.readStream.setBuffer(byArray, 0, n == -1 ? 0 : n);
            }
        });
        this.writeStream = new BlockBufferWriteStream(new BufferStream.Listener(){

            public void needsBufferCycled(BufferStream bufferStream) throws IOException {
                if (NetworkConnection.this.writeStream.getBufferSegment().getCompletedCount() != 0) {
                    NetworkConnection.this.socketOutputStream.write(NetworkConnection.this.writeStream.getBufferSegment().getBuffer(), NetworkConnection.this.writeStream.getBufferSegment().getCompletedOffset(), NetworkConnection.this.writeStream.getBufferSegment().getCompletedCount());
                }
                byte[] byArray = NetworkConnection.this.getBuffer(NetworkConnection.this.writeStream);
                NetworkConnection.this.writeStream.setBuffer(byArray, 0, byArray.length);
            }
        });
        this.reader = new DataInputStream(this.readStream.getNativeStream());
        this.writer = new DataOutputStream(this.writeStream.getNativeStream());
    }

    public void close() throws IOException {
        if (this.socket != null) {
            if (!this.socket.isInputShutdown()) {
                this.socket.shutdownInput();
            }
            if (!this.socket.isOutputShutdown()) {
                this.socket.shutdownOutput();
            }
            this.socket.close();
            this.isDisposed = true;
        }
    }
}

