/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Base64;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    public static final String SHOULD_DISPLAY_TRAY_ICON_FOR_GUEST = "screenconnect.guest.tray.icon.display";
    public static final String SHOULD_REGISTER_MAC_URI_HANDLER = "screenconnect.mac.uri.handler.register";
    public static final String SHOULD_EXIT_ON_CLIENT_STOP = "screenconnect.client.stop.exit";
    public static final String CLIENT_LAUNCH_PARAMETERS_FILE = "screenconnect.client.launch.parameters.file";
    public static final String CLIENT_LAUNCH_PARAMETERS = "screenconnect.client.launch.parameters";
    public static final String RESOURCE_PREFIX = "resource://";
    public static final String RESOURCE_VALUE_TYPE_FILENAME = "file";
    public static final String RESOURCE_VALUE_TYPE_BASE64 = "base64";

    public static String getUserProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = System.getProperty("jnlp." + string);
        }
        return string2;
    }

    public static List<String> getResourceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : System.getProperties().keySet()) {
            String string = object.toString();
            if (!string.startsWith(RESOURCE_PREFIX)) continue;
            arrayList.add(string.substring(RESOURCE_PREFIX.length()));
        }
        return arrayList;
    }

    public static InputStream openResourceStream(String string) {
        String[] stringArray;
        String string2;
        String string3;
        String string4 = RESOURCE_PREFIX + string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((string3 = Properties.getUserProperty(string4 + "/" + n)) != null) {
            stringBuffer.append(string3);
            ++n;
        }
        String string5 = string2 = stringBuffer.length() > 0 ? stringBuffer.toString() : Properties.getUserProperty(string4);
        if (!Extensions.isNullOrEmpty(string2) && (stringArray = string2.split(":", 2)).length == 2) {
            String string6 = stringArray[0];
            String string7 = stringArray[1];
            if (RESOURCE_VALUE_TYPE_FILENAME.equals(string6)) {
                try {
                    return new FileInputStream(new File(string7));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Constants.ExceptionTraceSource.traceException(fileNotFoundException);
                }
            } else if (RESOURCE_VALUE_TYPE_BASE64.equals(string6)) {
                return new ByteArrayInputStream(Base64.decode(string7));
            }
        }
        return null;
    }
}

