/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.IntArraySegment;

public class RawBitmapData
implements BitmapData {
    int x;
    int y;
    int width;
    int height;
    int rgbPixelDataOffset;
    int stride;
    int[] rgbPixelData;

    public RawBitmapData(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.width = n3;
        this.height = n4;
        this.rgbPixelData = nArray;
        this.rgbPixelDataOffset = n5;
        this.stride = n6;
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRedBitShift() {
        return 16;
    }

    public int getGreenBitShift() {
        return 8;
    }

    public int getBlueBitShift() {
        return 0;
    }

    public int[] getRgbPixelData() {
        return this.rgbPixelData;
    }

    public int getRgbPixelDataOffset() {
        return this.rgbPixelDataOffset;
    }

    public int getStride() {
        return this.stride;
    }

    public RawBitmapData crop(CoreRect coreRect) {
        int n = this.rgbPixelDataOffset + (coreRect.y - this.y) * this.stride + (coreRect.x - this.x);
        return new RawBitmapData(coreRect.x, coreRect.y, coreRect.width, coreRect.height, this.rgbPixelData, n, this.stride);
    }

    public IntArraySegment getRowRgbPixelData(int n) {
        return new IntArraySegment(this.rgbPixelData, this.rgbPixelDataOffset + this.stride * n, this.width);
    }
}

