/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.ScreenCodec;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.WaitChecker;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScreenCapturer
extends ThreadRunner
implements BufferStream.Listener {
    private CoreRect viewport;
    private int codecID;
    private MessagePreparerListener messagePreparerListener;
    private WaitChecker waitChecker;
    private boolean useFastScreenStart;

    public ScreenCapturer(MessagePreparerListener messagePreparerListener, WaitChecker waitChecker) {
        super(1, false);
        this.messagePreparerListener = Extensions.assertArgumentNonNull(messagePreparerListener);
        this.waitChecker = Extensions.assertArgumentNonNull(waitChecker);
    }

    public boolean getUseFastScreenStart() {
        return this.useFastScreenStart;
    }

    public void setUseFastScreenStart(boolean bl) {
        this.useFastScreenStart = bl;
    }

    public int getCodecID() {
        return this.codecID;
    }

    public void setCodecID(int n) {
        this.codecID = n;
    }

    public CoreRect getViewport() {
        return this.viewport;
    }

    public void setViewport(CoreRect coreRect) {
        this.viewport = coreRect;
        this.signal();
    }

    protected void messageReady(Object object) {
        this.messagePreparerListener.messageReady(object);
    }

    protected boolean shouldWait() {
        return this.waitChecker.shouldWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Throwable {
        HashMap<Integer, ScreenCodec> hashMap = new HashMap<Integer, ScreenCodec>();
        try {
            this.run(hashMap);
        }
        finally {
            for (ScreenCodec screenCodec : hashMap.values()) {
                Extensions.closeQuietly(screenCodec);
            }
        }
    }

    protected abstract void run(HashMap<Integer, ScreenCodec> var1) throws Throwable;

    protected void encode(HashMap<Integer, ScreenCodec> hashMap, int n, BitmapData bitmapData) throws IOException {
        ScreenCodec screenCodec = hashMap.get(n);
        if (screenCodec == null) {
            screenCodec = ScreenCodec.createEncoder(this, n);
            hashMap.put(n, screenCodec);
        }
        screenCodec.process(bitmapData);
    }

    @Override
    public void needsBufferCycled(BufferStream bufferStream) {
        if (bufferStream.getBufferSegment().getCompletedCount() != 0) {
            Messages.ScreenDataMessage screenDataMessage = new Messages.ScreenDataMessage();
            screenDataMessage.data = bufferStream.getBufferSegment().getCompletedSegment();
            this.messageReady(screenDataMessage);
        }
        bufferStream.setBuffer(new byte[1440], 0, 1440);
    }
}

