/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Coder;
import com.elsitech.screenconnect.DeflateDecoder;
import com.elsitech.screenconnect.DeflateEncoder;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.IntArraySegment;
import com.elsitech.screenconnect.MultiCallCoder;
import com.elsitech.screenconnect.ScreenQualityLevel;
import com.elsitech.screenconnect.SingleCallCoder;
import java.io.Closeable;
import java.io.IOException;

public abstract class ScreenCodec
extends BufferStream
implements Closeable {
    protected ScreenCodec(BufferStream.Listener listener) {
        super(listener);
    }

    public abstract void process(BitmapData var1) throws IOException;

    public static int getCodecID(ScreenQualityLevel screenQualityLevel, boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || screenQualityLevel != ScreenQualityLevel.Low && screenQualityLevel != ScreenQualityLevel.Medium)) {
            return 0;
        }
        if (!bl2 && screenQualityLevel == ScreenQualityLevel.High) {
            return 1;
        }
        if (bl2 && !bl3 && screenQualityLevel == ScreenQualityLevel.High) {
            return 2;
        }
        if (bl && !bl3 && screenQualityLevel == ScreenQualityLevel.Medium) {
            return 3;
        }
        if (bl && !bl3 && screenQualityLevel == ScreenQualityLevel.Low) {
            return 4;
        }
        if (bl2 && bl3 && screenQualityLevel == ScreenQualityLevel.High) {
            return 5;
        }
        if (bl && bl3 && screenQualityLevel == ScreenQualityLevel.Medium) {
            return 6;
        }
        if (bl && bl3 && screenQualityLevel == ScreenQualityLevel.Low) {
            return 7;
        }
        throw new IllegalArgumentException();
    }

    public static ScreenCodec createEncoder(BufferStream.Listener listener, int n) {
        switch (n) {
            case 0: {
                return new GrayscaleScreenEncoder(listener, new DeflateEncoder(-1, 0, true));
            }
            case 1: {
                return new TrueColorScreenEncoder(listener, new DeflateEncoder(-1, 0, true));
            }
            case 2: {
                throw new IllegalArgumentException();
            }
            case 3: {
                return new WebColorScreenEncoder(listener, new DeflateEncoder(-1, 0, false));
            }
            case 4: {
                return new GrayscaleScreenEncoder(listener, new DeflateEncoder(-1, 0, false));
            }
            case 5: {
                throw new IllegalArgumentException();
            }
            case 6: {
                throw new IllegalArgumentException();
            }
            case 7: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public static ScreenCodec createDecoder(BufferStream.Listener listener, int n) {
        switch (n) {
            case 0: {
                return new GrayscaleScreenDecoder(listener, new DeflateDecoder(true));
            }
            case 1: {
                return new TrueColorScreenDecoder(listener, new DeflateDecoder(true));
            }
            case 2: {
                throw new IllegalArgumentException();
            }
            case 3: {
                return new WebColorScreenDecoder(listener, new DeflateDecoder(false));
            }
            case 4: {
                return new GrayscaleScreenDecoder(listener, new DeflateDecoder(false));
            }
            case 5: {
                throw new IllegalArgumentException();
            }
            case 6: {
                throw new IllegalArgumentException();
            }
            case 7: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    private static class TrueColorScreenEncoder
    extends SimpleScreenEncoder {
        public TrueColorScreenEncoder(BufferStream.Listener listener, SingleCallCoder singleCallCoder) {
            super(listener, 24, 1, singleCallCoder);
        }

        protected void processRow(int[] nArray, int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
            byArray[n2++] = 0;
            for (int i = 0; i < n3; ++i) {
                int n7 = nArray[n++];
                byArray[n2++] = (byte)(n7 >> n5 & 0xFF);
                byArray[n2++] = (byte)(n7 >> n6 & 0xFF);
                byArray[n2++] = (byte)(n7 >> n4 & 0xFF);
            }
        }
    }

    private static class TrueColorScreenDecoder
    extends SimpleScreenDecoder {
        protected TrueColorScreenDecoder(BufferStream.Listener listener, MultiCallCoder multiCallCoder) {
            super(listener, 24, 1, multiCallCoder);
        }

        protected void processRow(byte[] byArray, int n, int[] nArray, int n2, int n3, int n4, int n5, int n6) {
            ++n;
            for (int i = 0; i < n3; ++i) {
                nArray[n2++] = (byArray[n++] & 0xFF) << n5 | (byArray[n++] & 0xFF) << n6 | (byArray[n++] & 0xFF) << n4;
            }
        }
    }

    private static class WebColorScreenEncoder
    extends SimpleScreenEncoder {
        final byte[] map = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};

        public WebColorScreenEncoder(BufferStream.Listener listener, SingleCallCoder singleCallCoder) {
            super(listener, 8, 0, singleCallCoder);
        }

        protected void processRow(int[] nArray, int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
            for (int i = 0; i < n3; ++i) {
                int n7 = nArray[n++];
                byArray[n2++] = (byte)(this.map[n7 >> n5 & 0xFF] + this.map[n7 >> n6 & 0xFF] * 6 + this.map[n7 >> n4 & 0xFF] * 36);
            }
        }
    }

    private static class WebColorScreenDecoder
    extends SimpleScreenDecoder {
        final int[] map = new int[]{0, 51, 102, 153, 204, 255};

        public WebColorScreenDecoder(BufferStream.Listener listener, MultiCallCoder multiCallCoder) {
            super(listener, 8, 0, multiCallCoder);
        }

        protected void processRow(byte[] byArray, int n, int[] nArray, int n2, int n3, int n4, int n5, int n6) {
            for (int i = 0; i < n3; ++i) {
                int n7 = byArray[n++] & 0xFF;
                nArray[n2++] = this.map[n7 % 6] << n5 | this.map[n7 % 36 / 6] << n6 | this.map[n7 / 36] << n4;
            }
        }
    }

    private static class GrayscaleScreenEncoder
    extends SimpleScreenEncoder {
        public static final byte[] BlueColorTable = new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28};
        public static final byte[] GreenColorTable = new byte[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 14, 14, 15, 15, 16, 17, 17, 18, 18, 19, 19, 20, 21, 21, 22, 22, 23, 24, 24, 25, 25, 26, 27, 27, 28, 28, 29, 30, 30, 31, 31, 32, 32, 33, 34, 34, 35, 35, 36, 37, 37, 38, 38, 39, 40, 40, 41, 41, 42, 42, 43, 44, 44, 45, 45, 46, 47, 47, 48, 48, 49, 50, 50, 51, 51, 52, 53, 53, 54, 54, 55, 55, 56, 57, 57, 58, 58, 59, 60, 60, 61, 61, 62, 63, 63, 64, 64, 65, 65, 66, 67, 67, 68, 68, 69, 70, 70, 71, 71, 72, 73, 73, 74, 74, 75, 76, 76, 77, 77, 78, 78, 79, 80, 80, 81, 81, 82, 83, 83, 84, 84, 85, 86, 86, 87, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93, 93, 94, 94, 95, 96, 96, 97, 97, 98, 99, 99, 100, 100, 101, 101, 102, 103, 103, 104, 104, 105, 106, 106, 107, 107, 108, 109, 109, 110, 110, 111, 112, 112, 113, 113, 114, 114, 115, 116, 116, 117, 117, 118, 119, 119, 120, 120, 121, 122, 122, 123, 123, 124, 124, 125, 126, 126, 127, 127, -128, -127, -127, -126, -126, -125, -124, -124, -123, -123, -122, -121, -121, -120, -120, -119, -119, -118, -117, -117, -116, -116, -115, -114, -114, -113, -113, -112, -111, -111, -110, -110, -109, -108, -108, -107, -107, -106, -106};
        public static final byte[] RedColorTable = new byte[]{0, 0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 24, 24, 24, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 40, 40, 40, 40, 41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 44, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 48, 48, 48, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 52, 52, 52, 52, 53, 53, 53, 54, 54, 54, 55, 55, 55, 56, 56, 56, 56, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 60, 60, 60, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 64, 64, 64, 64, 65, 65, 65, 66, 66, 66, 67, 67, 67, 68, 68, 68, 68, 69, 69, 69, 70, 70, 70, 70, 71, 71, 71, 72, 72, 72, 73, 73, 73, 74, 74, 74, 74, 75, 75, 75, 76, 76, 76, 76};

        public GrayscaleScreenEncoder(BufferStream.Listener listener, SingleCallCoder singleCallCoder) {
            super(listener, 4, 0, singleCallCoder);
        }

        protected void processRow(int[] nArray, int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
            for (int i = 0; i < n3; ++i) {
                int n7 = nArray[n++];
                int n8 = BlueColorTable[n7 >> n5 & 0xFF] + GreenColorTable[n7 >> n6 & 0xFF] + RedColorTable[n7 >> n4 & 0xFF];
                if (i % 2 == 0) {
                    byArray[n2] = (byte)(n8 & 0xF0);
                    continue;
                }
                int n9 = n2++;
                byArray[n9] = (byte)(byArray[n9] | (byte)(n8 >> 4 & 0xF));
            }
        }
    }

    private static class GrayscaleScreenDecoder
    extends SimpleScreenDecoder {
        protected GrayscaleScreenDecoder(BufferStream.Listener listener, MultiCallCoder multiCallCoder) {
            super(listener, 4, 0, multiCallCoder);
        }

        protected void processRow(byte[] byArray, int n, int[] nArray, int n2, int n3, int n4, int n5, int n6) {
            for (int i = 0; i < n3; ++i) {
                byte by = 0;
                by = i % 2 == 0 ? (byte)((byArray[n] & 0xF0) >> 4) : (byte)(byArray[n++] & 0xF);
                nArray[n2++] = by | by << 4 | by << 8 | by << 12 | by << 16 | by << 20;
            }
        }
    }

    private static abstract class SimpleScreenDecoder
    extends SimpleScreenCodec {
        private MultiCallCoder coder;

        protected SimpleScreenDecoder(BufferStream.Listener listener, int n, int n2, MultiCallCoder multiCallCoder) {
            super(listener, n, n2);
            this.coder = Extensions.assertArgumentNonNull(multiCallCoder);
        }

        public void close() throws IOException {
            this.coder.close();
        }

        protected void readRow(byte[] byArray, int n) throws IOException {
            BufferSegment bufferSegment = new BufferSegment(byArray, 0, n);
            while (true) {
                this.coder.process(this.getBufferSegment(), bufferSegment, Coder.FlushType.Sync);
                if (bufferSegment.getRemainingCount() == 0) break;
                this.demandBufferCount(1);
            }
        }

        public void process(BitmapData bitmapData) throws IOException {
            int n = bitmapData.getRedBitShift();
            int n2 = bitmapData.getBlueBitShift();
            int n3 = bitmapData.getGreenBitShift();
            int n4 = bitmapData.getWidth();
            int n5 = bitmapData.getHeight();
            int n6 = this.getRowLength(n4);
            byte[] byArray = this.getWorkingBuffer(n6);
            for (int i = 0; i < n5; ++i) {
                this.readRow(byArray, n6);
                IntArraySegment intArraySegment = bitmapData.getRowRgbPixelData(i);
                this.processRow(byArray, 0, intArraySegment.array, intArraySegment.offset, n4, n, n2, n3);
            }
        }

        protected abstract void processRow(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8);
    }

    private static abstract class SimpleScreenEncoder
    extends SimpleScreenCodec
    implements SingleCallCoder.BufferProvider {
        private SingleCallCoder coder;

        protected SimpleScreenEncoder(BufferStream.Listener listener, int n, int n2, SingleCallCoder singleCallCoder) {
            super(listener, n, n2);
            this.coder = Extensions.assertArgumentNonNull(singleCallCoder);
        }

        public void close() throws IOException {
            this.coder.close();
        }

        public void process(BitmapData bitmapData) throws IOException {
            int n = bitmapData.getRedBitShift();
            int n2 = bitmapData.getBlueBitShift();
            int n3 = bitmapData.getGreenBitShift();
            int n4 = bitmapData.getWidth();
            int n5 = bitmapData.getHeight();
            int n6 = this.getRowLength(n4);
            int n7 = n5 * n6;
            byte[] byArray = this.getWorkingBuffer(n7);
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                IntArraySegment intArraySegment = bitmapData.getRowRgbPixelData(i);
                this.processRow(intArraySegment.array, intArraySegment.offset, byArray, n8, n4, n, n2, n3);
                n8 += n6;
            }
            ByteArraySegment byteArraySegment = new ByteArraySegment(byArray, 0, n7);
            this.coder.process(byteArraySegment, this);
        }

        protected abstract void processRow(int[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8);

        public BufferSegment borrowByteBuffer() throws IOException {
            if (this.getBufferSegment().getRemainingCount() == 0) {
                this.onNeedsBufferCycled();
            }
            return this.getBufferSegment();
        }

        public void returnByteBuffer(BufferSegment bufferSegment) throws IOException {
            if (bufferSegment != this.getBufferSegment()) {
                throw new IllegalArgumentException();
            }
            if (this.getBufferSegment().getCompletedCount() != 0) {
                this.onNeedsBufferCycled();
            }
        }
    }

    private static abstract class SimpleScreenCodec
    extends ScreenCodec {
        private int bitsPerPixel;
        private int rowPadding;
        private byte[][] workingBuffers;

        protected SimpleScreenCodec(BufferStream.Listener listener, int n, int n2) {
            super(listener);
            this.bitsPerPixel = n;
            this.rowPadding = n2;
            this.workingBuffers = new byte[10][];
        }

        protected int getRowLength(int n) {
            return Extensions.divUp(n * this.bitsPerPixel, 8) + this.rowPadding;
        }

        protected byte[] getWorkingBuffer(int n) {
            return this.getWorkingBuffer(0, n);
        }

        protected byte[] getWorkingBuffer(int n, int n2) {
            if (this.workingBuffers[n] == null || this.workingBuffers[n].length < n2) {
                this.workingBuffers[n] = new byte[n2];
            }
            return this.workingBuffers[n];
        }
    }
}

