/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.Blittable;
import com.elsitech.screenconnect.BufferStream;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.ReactiveThreadQueue;
import com.elsitech.screenconnect.ScreenCodec;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CaptureStateDependent
public class ScreenRenderer
extends ReactiveThreadQueue<Messages.ScreenMessage>
implements BufferStream.Listener {
    RenderTargetProvider renderTargetProvider;
    HashMap<Integer, ScreenCodec> decoders;
    int activeCodecID;

    public ScreenRenderer(int n, RenderTargetProvider renderTargetProvider) {
        super(10, false);
        this.renderTargetProvider = Extensions.assertArgumentNonNull(renderTargetProvider);
        this.decoders = new HashMap();
    }

    @Override
    protected void onStopped(boolean bl) {
        super.onStopped(bl);
        for (ScreenCodec screenCodec : this.decoders.values()) {
            Extensions.closeQuietly(screenCodec);
        }
        this.decoders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processItem(Messages.ScreenMessage screenMessage) throws Exception {
        Blittable[] blittableArray = this.renderTargetProvider.getRenderTargets();
        BitmapData[] bitmapDataArray = new BitmapData[blittableArray.length];
        try {
            if (screenMessage instanceof Messages.ScreenDataMessage) {
                this.decoders.get(this.activeCodecID).setBuffer(((Messages.ScreenDataMessage)screenMessage).data);
            } else {
                Messages.ScreenStartMessage screenStartMessage = (Messages.ScreenStartMessage)screenMessage;
                int n = -1;
                for (int i = 0; i < bitmapDataArray.length; ++i) {
                    bitmapDataArray[i] = blittableArray[i].acquireBitmapData(screenStartMessage.bounds);
                    if (bitmapDataArray[i] == null) continue;
                    if (n == -1) {
                        this.activeCodecID = screenStartMessage.codecID;
                        ScreenCodec screenCodec = this.decoders.get(this.activeCodecID);
                        if (screenCodec == null) {
                            screenCodec = ScreenCodec.createDecoder(this, screenStartMessage.codecID);
                            this.decoders.put(screenStartMessage.codecID, screenCodec);
                        }
                        screenCodec.process(bitmapDataArray[i]);
                        n = i;
                        continue;
                    }
                    throw new UnsupportedOperationException("Multiple targets not supported yet.");
                }
            }
        }
        finally {
            for (int i = 0; i < bitmapDataArray.length; ++i) {
                if (bitmapDataArray[i] == null) continue;
                blittableArray[i].releaseBitmapData(bitmapDataArray[i]);
            }
        }
    }

    @Override
    public void needsBufferCycled(BufferStream bufferStream) {
        Messages.ScreenMessage screenMessage = (Messages.ScreenMessage)this.dequeueItem();
        if (screenMessage instanceof Messages.ScreenDataMessage) {
            bufferStream.setBuffer(((Messages.ScreenDataMessage)screenMessage).data);
        }
    }

    public static interface RenderTargetProvider {
        public Blittable[] getRenderTargets();
    }
}

