/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferProducer;
import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.DeflateEncoder;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SingleCallCoder;
import com.elsitech.screenconnect.SoundFormat;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.TraceSource;
import com.elsitech.screenconnect.Tuple;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

@CaptureStateDependent
public abstract class SoundCapturer
extends ThreadRunner
implements Services.SoundDeviceManager {
    private MessagePreparerListener messagePreparerListener;
    private TraceSource traceSource = Extensions.createTraceSource(this.getClass());
    private Listener listener;
    private volatile float soundLevel = 0.0f;
    private volatile boolean currentlySending = false;
    private volatile boolean isMutedByUser = false;
    private volatile String userSelectedDeviceID = null;
    private volatile String runningDeviceID = null;
    private volatile boolean isSoundCurrentlyRenderedAloud = false;
    private volatile boolean useDynamicNoiseThresholding = true;

    public SoundCapturer(MessagePreparerListener messagePreparerListener, Listener listener) {
        super(6, false);
        this.messagePreparerListener = messagePreparerListener;
        this.listener = listener;
        if (SoundFormat.DEFAULT_CAPTURE_FORMAT.getBitsPerSample() != 8) {
            throw new IllegalStateException(SoundFormat.DEFAULT_CAPTURE_FORMAT.getBitsPerSample() + " bits per sample not supported");
        }
    }

    public float getSoundLevel() {
        return this.soundLevel;
    }

    public boolean isCurrentlySending() {
        return this.currentlySending;
    }

    public boolean isMutedByUser() {
        return this.isMutedByUser;
    }

    public void setMutedByUser(boolean bl) {
        this.isMutedByUser = bl;
        this.traceSource.traceMessage("Sending captures %s", bl ? "paused" : "resumed");
    }

    public String getUserSelectedDeviceID() {
        return this.userSelectedDeviceID;
    }

    public void setUserSelectedDeviceID(String string) {
        this.userSelectedDeviceID = string;
    }

    public String getRunningDeviceID() {
        return this.runningDeviceID;
    }

    public boolean isSoundCurrentlyRenderedAloud() {
        return this.isSoundCurrentlyRenderedAloud;
    }

    public void setSoundCurrentlyRenderedAloud(boolean bl) {
        this.isSoundCurrentlyRenderedAloud = bl;
    }

    protected abstract SoundStream openStream(String var1, boolean var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run() throws Throwable {
        DeflateEncoder deflateEncoder = new DeflateEncoder(-1, 0, true);
        LinkedList<Tuple.TuplePair<Long, Float>> linkedList = new LinkedList<Tuple.TuplePair<Long, Float>>();
        ByteArraySegment byteArraySegment = null;
        SoundStream soundStream = null;
        boolean bl = false;
        long l = -1L;
        long l2 = 0L;
        float f = 0.15f;
        float f2 = 0.09f;
        int n = 1;
        try {
            while (!this.isStopping()) {
                Object object;
                boolean bl2 = false;
                if (l2 < System.currentTimeMillis() - 4000L) {
                    object = soundStream;
                    if (this.userSelectedDeviceID != null) {
                        soundStream = this.tryChangeDeviceIfNotCurrent(this.userSelectedDeviceID, soundStream);
                    }
                    if (this.runningDeviceID == null) {
                        soundStream = this.tryChangeDeviceIfNotCurrent(this.tryGetDefaultDeviceID(), soundStream);
                    }
                    bl2 = !Extensions.equals(soundStream, object);
                    l2 = System.currentTimeMillis();
                }
                if (bl2 && bl) {
                    this.sendSoundMessage(new ByteArraySegment(0), Messages.SegmentPosition.LAST, deflateEncoder);
                    bl = false;
                }
                if (soundStream == null) {
                    this.waitUnlessSignaled(4000L);
                    continue;
                }
                try {
                    boolean bl3;
                    object = new BufferSegment(512);
                    while (((BufferSegment)object).getCompletedCount() < 384) {
                        int n2 = soundStream.read(((BufferSegment)object).getRemainingSegment());
                        ((BufferSegment)object).advance(n2);
                        if (n2 != 0) continue;
                        this.waitUnlessSignaled(10L);
                    }
                    ByteArraySegment byteArraySegment2 = ((BufferSegment)object).getCompletedSegment();
                    float f3 = SoundCapturer.calculateSoundLevel(byteArraySegment2);
                    long l3 = System.currentTimeMillis();
                    this.soundLevel = Math.max(this.soundLevel, f3);
                    linkedList.add(new Tuple.TuplePair<Long, Float>(l3, Float.valueOf(f3)));
                    boolean bl4 = false;
                    while (!linkedList.isEmpty() && (Long)((Tuple.TuplePair)linkedList.peek()).getItem1() < l3 - 500L) {
                        bl4 |= ((Float)((Tuple.TuplePair)linkedList.remove()).getItem2()).floatValue() >= this.soundLevel;
                    }
                    if (bl4) {
                        this.soundLevel = Collections.max(linkedList, new Comparator<Tuple.TuplePair<Long, Float>>(){

                            @Override
                            public int compare(Tuple.TuplePair<Long, Float> tuplePair, Tuple.TuplePair<Long, Float> tuplePair2) {
                                return tuplePair.getItem2().floatValue() > tuplePair2.getItem2().floatValue() ? 1 : (tuplePair.getItem2().floatValue() < tuplePair2.getItem2().floatValue() ? -1 : 0);
                            }
                        }).getItem2().floatValue();
                    }
                    boolean bl5 = this.isMutedByUser || !soundStream.hasEchoCancellation() && this.isSoundCurrentlyRenderedAloud;
                    boolean bl6 = bl3 = !bl5;
                    if (this.useDynamicNoiseThresholding) {
                        double d;
                        if (f3 < f) {
                            f -= 0.2f * (f - f3);
                        } else if (f3 > f) {
                            f += 0.01f * (f3 - f);
                        }
                        double d2 = Math.sqrt(f2 / (float)n);
                        double d3 = d = bl ? 1.75 : 2.0;
                        if ((double)f3 < (double)f + d * d2) {
                            float f4 = f3 - f;
                            f2 += f4 * f4;
                            ++n;
                            bl3 = false;
                        }
                        this.traceSource.traceMessage("Captured %.3f sound level; Current noise floor is %.3f; Current noise stddev is %.3f; Current max sound level is %.3f", Float.valueOf(f3), Float.valueOf(f), d2, Float.valueOf(this.soundLevel));
                    } else if (f3 == 0.0f) {
                        bl3 = false;
                    }
                    if (bl3) {
                        if (!bl) {
                            if (byteArraySegment == null) {
                                SoundCapturer.rampSoundLevel(byteArraySegment2, true);
                            } else {
                                SoundCapturer.rampSoundLevel(byteArraySegment, true);
                                this.sendSoundMessage(byteArraySegment, Messages.SegmentPosition.FIRST, deflateEncoder);
                                byteArraySegment = null;
                                bl = true;
                            }
                        }
                        this.sendSoundMessage(byteArraySegment2, bl ? Messages.SegmentPosition.MIDDLE : Messages.SegmentPosition.FIRST, deflateEncoder);
                        bl = true;
                        l = -1L;
                    } else if (bl) {
                        if (l < 0L) {
                            l = l3;
                        }
                        if (!bl5 && l3 - l < 500L) {
                            this.sendSoundMessage(byteArraySegment2, Messages.SegmentPosition.MIDDLE, deflateEncoder);
                        } else {
                            SoundCapturer.rampSoundLevel(byteArraySegment2, false);
                            this.sendSoundMessage(byteArraySegment2, Messages.SegmentPosition.LAST, deflateEncoder);
                            bl = false;
                        }
                    }
                    byteArraySegment = byteArraySegment2;
                    if (this.currentlySending == bl) continue;
                    this.currentlySending = bl;
                    this.listener.sendingStartedOrStopped();
                }
                catch (Exception exception) {
                    soundStream = this.tryChangeDeviceIfNotCurrent(null, soundStream);
                    l2 = 0L;
                }
            }
            Object var28_24 = null;
            soundStream = this.tryChangeDeviceIfNotCurrent(null, soundStream);
            this.soundLevel = 0.0f;
            this.currentlySending = false;
        }
        catch (Throwable throwable) {
            Object var28_25 = null;
            soundStream = this.tryChangeDeviceIfNotCurrent(null, soundStream);
            this.soundLevel = 0.0f;
            this.currentlySending = false;
            Extensions.closeQuietly(deflateEncoder);
            throw throwable;
        }
        Extensions.closeQuietly(deflateEncoder);
    }

    private SoundStream tryChangeDeviceIfNotCurrent(String string, SoundStream soundStream) {
        if (string == this.runningDeviceID) {
            return soundStream;
        }
        try {
            SoundStream soundStream2 = string == null ? null : this.openStream(string, false);
            Extensions.closeQuietly(soundStream);
            this.runningDeviceID = string;
            this.listener.runningDeviceChanged();
            return soundStream2;
        }
        catch (Exception exception) {
            return soundStream;
        }
    }

    private void sendSoundMessage(ByteArraySegment byteArraySegment, Messages.SegmentPosition segmentPosition, SingleCallCoder singleCallCoder) throws IOException {
        ByteArraySegment byteArraySegment2;
        Object object;
        for (int i = byteArraySegment.offset; i < byteArraySegment.offset + byteArraySegment.count; i += SoundFormat.DEFAULT_CAPTURE_FORMAT.getBytesPerSample()) {
            byteArraySegment.array[i] = SoundCapturer.convertToUnsignedSample(byteArraySegment.array[i]);
        }
        if (byteArraySegment.count > 0) {
            object = new BufferProducer(byteArraySegment.count);
            singleCallCoder.process(byteArraySegment, (SingleCallCoder.BufferProvider)object);
            ((BufferProducer)object).completeCurrent();
            byteArraySegment2 = Extensions.joinSegments(((BufferProducer)object).getCompletedBuffers());
        } else {
            byteArraySegment2 = new ByteArraySegment(0);
        }
        object = new Messages.SoundMessage();
        ((Messages.SoundMessage)object).segmentPosition = segmentPosition;
        ((Messages.SoundMessage)object).frameCount = SoundFormat.DEFAULT_CAPTURE_FORMAT.getNumFrames(byteArraySegment.count);
        ((Messages.SoundMessage)object).frameData = byteArraySegment2;
        this.messagePreparerListener.messageReady(object);
        this.traceSource.traceMessage("Sent %s segment", new Object[]{segmentPosition});
    }

    private static float calculateSoundLevel(ByteArraySegment byteArraySegment) {
        byte by = 0;
        for (int i = byteArraySegment.offset; i < byteArraySegment.offset + byteArraySegment.count; i += SoundFormat.DEFAULT_CAPTURE_FORMAT.getBytesPerSample()) {
            byte by2 = (byte)Math.abs(byteArraySegment.array[i]);
            if (by2 <= by) continue;
            by = by2;
        }
        return (float)by / 128.0f;
    }

    private static byte convertToUnsignedSample(byte by) {
        return (byte)(by - 128);
    }

    private static void rampSoundLevel(ByteArraySegment byteArraySegment, boolean bl) {
        int n = SoundFormat.DEFAULT_CAPTURE_FORMAT.getNumFrames(byteArraySegment.count);
        int n2 = -1;
        for (int i = byteArraySegment.offset; i < byteArraySegment.offset + byteArraySegment.count; i += SoundFormat.DEFAULT_CAPTURE_FORMAT.getBytesPerSample()) {
            if (i % SoundFormat.DEFAULT_CAPTURE_FORMAT.getBytesPerFrame() == 0) {
                ++n2;
            }
            byteArraySegment.array[i] = (byte)(byteArraySegment.array[i] * (bl ? n2 : n - 1 - n2) / n);
        }
    }

    public static interface Listener
    extends Services.SoundDeviceManagerListener {
        public void sendingStartedOrStopped();
    }

    protected static abstract class SoundStream
    implements Closeable {
        protected SoundStream() {
        }

        public boolean hasEchoCancellation() {
            return false;
        }

        public abstract int read(ByteArraySegment var1);
    }
}

