/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Extensions;

public class SoundFormat {
    public static final SoundFormat DEFAULT_RENDER_FORMAT = new SoundFormat(8, 1, 11025, false);
    public static final SoundFormat DEFAULT_CAPTURE_FORMAT = new SoundFormat(8, 1, 11025, true);
    private int bitsPerSample;
    private int numChannels;
    private int samplesPerSecond;
    private boolean signed;

    public SoundFormat(int n, int n2, int n3, boolean bl) {
        this.bitsPerSample = n;
        this.numChannels = n2;
        this.samplesPerSecond = n3;
        this.signed = bl;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getBytesPerSample() {
        return Extensions.ceilingDivide(this.getBitsPerSample(), 8);
    }

    public int getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getBytesPerFrame() {
        return this.getBytesPerSample() * this.getNumChannels();
    }

    public int getBytesPerSecond() {
        return this.getBytesPerSample() * this.getSamplesPerSecond();
    }

    public int getNumFrames(int n) {
        return n / this.getBytesPerFrame();
    }

    public int getNumBytes(int n) {
        return n * this.getBytesPerFrame();
    }

    public int getNumBytesForMilliseconds(int n) {
        return n * this.getBytesPerSecond() / 1000;
    }

    public int getNumMillisecondsForBytes(int n) {
        return n * 1000 / this.getBytesPerSecond();
    }
}

