/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Coder;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.DeflateDecoder;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.MultiCallCoder;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SoundException;
import com.elsitech.screenconnect.SoundFormat;
import com.elsitech.screenconnect.ThreadQueue;
import com.elsitech.screenconnect.TraceSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CaptureStateDependent
public abstract class SoundRenderer
extends ThreadQueue<Messages.SoundMessage2>
implements Services.SoundDeviceManager {
    private Listener listener;
    private TraceSource traceSource = Extensions.createTraceSource(this.getClass());
    private volatile float volume = 1.0f;
    private volatile String userSelectedDeviceID = null;
    private volatile String runningDeviceID = null;

    public SoundRenderer(Listener listener) {
        super(5, false);
        this.listener = listener;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    @Override
    public String getUserSelectedDeviceID() {
        return this.userSelectedDeviceID;
    }

    @Override
    public void setUserSelectedDeviceID(String string) {
        this.userSelectedDeviceID = string;
    }

    @Override
    public String getRunningDeviceID() {
        return this.runningDeviceID;
    }

    protected void setRunningDeviceID(String string) {
        this.runningDeviceID = string;
    }

    protected Boolean doesDeviceRenderSoundAloud(String string) throws SoundException.InvalidDeviceIDException {
        if (string == null) {
            return false;
        }
        return null;
    }

    protected static Boolean doesDeviceNameIndicateAloudRendering(String string) {
        if (Extensions.containsAnyIgnoreCase(string, "Headphones") && !Extensions.containsAnyIgnoreCase(string, "Speakers")) {
            return false;
        }
        if (Extensions.containsAnyIgnoreCase(string, "Headset")) {
            return false;
        }
        if (Extensions.containsAnyIgnoreCase(string, "Plantronics", "Jabra", "Skullcandy", "Sennheiser", "Jawbone")) {
            return false;
        }
        return null;
    }

    protected abstract LineRenderer createLineRenderer(String var1) throws SoundException.InvalidDeviceIDException;

    private LineRenderer CreateLineRendererAndApplyCurrentSettings(String string) throws SoundException {
        LineRenderer lineRenderer = string == null ? new NullLineRenderer() : this.createLineRenderer(string);
        lineRenderer.setVolume(this.volume);
        return lineRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Throwable {
        Iterator iterator;
        HashMap hashMap = new HashMap();
        ByteArraySegment byteArraySegment = SoundRenderer.createSilenceBuffer(300);
        ByteArraySegment byteArraySegment2 = SoundRenderer.createSilenceBuffer(100);
        try {
            while (!this.isStopping()) {
                Object var17_22;
                ArrayList<StreamState> arrayList = new ArrayList<StreamState>();
                int n = 0;
                long l = 0L;
                boolean bl = false;
                float f = 1.0f;
                try {
                    try {
                        while (!this.isStopping()) {
                            long l2;
                            Messages.SoundMessage2 soundMessage2;
                            float f2;
                            if (l < System.currentTimeMillis() - 4000L) {
                                String string = this.userSelectedDeviceID;
                                if (string != null && !Extensions.equals(string, this.runningDeviceID)) {
                                    try {
                                        bl = this.changeDevice(string, arrayList);
                                    }
                                    catch (Exception exception) {
                                        Constants.ExceptionTraceSource.traceException(exception);
                                    }
                                }
                                if (this.runningDeviceID == null) {
                                    try {
                                        bl = this.changeDevice(this.tryGetDefaultDeviceID(), arrayList);
                                    }
                                    catch (Exception exception) {
                                        bl = this.changeDevice(null, arrayList);
                                    }
                                }
                                l = System.currentTimeMillis();
                            }
                            if ((f2 = this.volume) != f) {
                                for (StreamState streamState : arrayList) {
                                    streamState.lineRenderer.setVolume(f2);
                                }
                            }
                            if ((soundMessage2 = (Messages.SoundMessage2)this.dequeueItem(l2 = System.currentTimeMillis() + (long)(n == 0 ? 4000 : 10))) != null) {
                                StreamState streamState = Extensions.firstOrDefault(arrayList, new Extensions.Predicate<StreamState>(){

                                    @Override
                                    public boolean check(StreamState streamState) {
                                        return Extensions.equals(streamState.deviceID, SoundRenderer.this.runningDeviceID) && Extensions.equals(streamState.streamID, soundMessage2.streamID);
                                    }
                                });
                                if (streamState == null && (streamState = Extensions.firstOrDefault(arrayList, new Extensions.Predicate<StreamState>(){

                                    @Override
                                    public boolean check(StreamState streamState) {
                                        return Extensions.equals(streamState.deviceID, SoundRenderer.this.runningDeviceID) && !streamState.isLineRendererRunning;
                                    }
                                })) != null) {
                                    streamState.streamID = soundMessage2.streamID;
                                }
                                if (streamState == null) {
                                    streamState = new StreamState(soundMessage2.streamID, this.CreateLineRendererAndApplyCurrentSettings(this.runningDeviceID), this.runningDeviceID);
                                    arrayList.add(streamState);
                                }
                                if (soundMessage2.segmentPosition == Messages.SegmentPosition.FIRST && streamState.isLineRendererRunning) {
                                    streamState.stopAfterFrame = -1L;
                                }
                                if (!streamState.isLineRendererRunning) {
                                    streamState.lineRenderer.start();
                                    SoundRenderer.write(streamState, byteArraySegment2);
                                    streamState.isLineRendererRunning = true;
                                    this.listener.rendererStartedOrStopped(true, streamState.streamID);
                                    if (n++ == 0) {
                                        this.listener.renderingStartedOrStopped(true, bl);
                                    }
                                }
                                MultiCallCoder multiCallCoder = Extensions.getFromMapAndCreateIfNull(hashMap, soundMessage2.streamID, new Extensions.Factory<MultiCallCoder>(){

                                    @Override
                                    public MultiCallCoder createInstance() {
                                        return new DeflateDecoder(true);
                                    }
                                });
                                this.writeMessageData(soundMessage2, streamState, multiCallCoder);
                                if (soundMessage2.segmentPosition == Messages.SegmentPosition.LAST) {
                                    streamState.stopAfterFrame = streamState.framesWritten;
                                    SoundRenderer.write(streamState, byteArraySegment);
                                }
                            }
                            for (int i = arrayList.size() - 1; i >= 0; --i) {
                                if (!((StreamState)arrayList.get((int)i)).isLineRendererRunning && ((StreamState)arrayList.get((int)i)).lastActivityTime < System.currentTimeMillis() - 30000L) {
                                    ((StreamState)arrayList.get((int)i)).lineRenderer.close();
                                    arrayList.remove(i);
                                    continue;
                                }
                                if (!((StreamState)arrayList.get((int)i)).isLineRendererRunning || ((StreamState)arrayList.get((int)i)).stopAfterFrame < 0L || ((StreamState)arrayList.get((int)i)).lineRenderer.getFramesPlayed() < ((StreamState)arrayList.get((int)i)).stopAfterFrame) continue;
                                ((StreamState)arrayList.get((int)i)).lineRenderer.stop();
                                ((StreamState)arrayList.get((int)i)).stopAfterFrame = -1L;
                                ((StreamState)arrayList.get((int)i)).isLineRendererRunning = false;
                                ((StreamState)arrayList.get((int)i)).lastActivityTime = System.currentTimeMillis();
                                this.listener.rendererStartedOrStopped(false, ((StreamState)arrayList.get((int)i)).streamID);
                                if (--n != 0) continue;
                                this.listener.renderingStartedOrStopped(false, bl);
                            }
                        }
                        var17_22 = null;
                    }
                    catch (SoundException soundException) {
                        var17_22 = null;
                        for (StreamState streamState : arrayList) {
                            if (streamState.isLineRendererRunning) {
                                this.listener.rendererStartedOrStopped(false, streamState.streamID);
                            }
                            streamState.lineRenderer.close();
                        }
                        if (n != 0) {
                            this.listener.renderingStartedOrStopped(false, bl);
                        }
                        if (this.runningDeviceID == null) continue;
                        this.runningDeviceID = null;
                        this.listener.runningDeviceChanged();
                        continue;
                    }
                    for (StreamState streamState : arrayList) {
                        if (streamState.isLineRendererRunning) {
                            this.listener.rendererStartedOrStopped(false, streamState.streamID);
                        }
                        streamState.lineRenderer.close();
                    }
                    if (n != 0) {
                        this.listener.renderingStartedOrStopped(false, bl);
                    }
                    if (this.runningDeviceID == null) continue;
                    this.runningDeviceID = null;
                    this.listener.runningDeviceChanged();
                }
                catch (Throwable throwable) {
                    var17_22 = null;
                    for (StreamState streamState : arrayList) {
                        if (streamState.isLineRendererRunning) {
                            this.listener.rendererStartedOrStopped(false, streamState.streamID);
                        }
                        streamState.lineRenderer.close();
                    }
                    if (n != 0) {
                        this.listener.renderingStartedOrStopped(false, bl);
                    }
                    if (this.runningDeviceID != null) {
                        this.runningDeviceID = null;
                        this.listener.runningDeviceChanged();
                    }
                    throw throwable;
                }
            }
            Object var21_26 = null;
            iterator = hashMap.values().iterator();
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            Iterator iterator2 = hashMap.values().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    throw throwable;
                }
                MultiCallCoder multiCallCoder = (MultiCallCoder)iterator2.next();
                multiCallCoder.close();
            }
        }
        while (iterator.hasNext()) {
            MultiCallCoder multiCallCoder = (MultiCallCoder)iterator.next();
            multiCallCoder.close();
        }
        return;
    }

    private static ByteArraySegment createSilenceBuffer(int n) {
        byte[] byArray = new byte[SoundFormat.DEFAULT_RENDER_FORMAT.getNumBytesForMilliseconds(n)];
        Arrays.fill(byArray, (byte)-128);
        return new ByteArraySegment(byArray);
    }

    private boolean changeDevice(String string, List<StreamState> list) throws SoundException {
        LineRenderer lineRenderer = this.CreateLineRendererAndApplyCurrentSettings(string);
        list.add(new StreamState(lineRenderer, string, System.currentTimeMillis()));
        this.runningDeviceID = string;
        this.listener.runningDeviceChanged();
        Boolean bl = this.doesDeviceRenderSoundAloud(string);
        return bl == null ? true : bl;
    }

    private void writeMessageData(Messages.SoundMessage soundMessage, StreamState streamState, MultiCallCoder multiCallCoder) throws IOException, SoundException.DeviceInvalidatedException {
        BufferSegment bufferSegment = new BufferSegment(soundMessage.frameData);
        byte[] byArray = new byte[SoundFormat.DEFAULT_RENDER_FORMAT.getNumBytes(soundMessage.frameCount)];
        while (bufferSegment.getRemainingCount() != 0) {
            BufferSegment bufferSegment2 = new BufferSegment(byArray);
            multiCallCoder.process(bufferSegment, bufferSegment2, Coder.FlushType.Sync);
            SoundRenderer.write(streamState, bufferSegment2.getCompletedSegment());
        }
        this.traceSource.traceMessage("Rendered %s frames at segment position %s", new Object[]{soundMessage.frameCount, soundMessage.segmentPosition});
    }

    private static void write(StreamState streamState, ByteArraySegment byteArraySegment) throws SoundException.DeviceInvalidatedException {
        streamState.lineRenderer.write(byteArraySegment);
        streamState.framesWritten += (long)byteArraySegment.count;
    }

    private static class NullLineRenderer
    implements LineRenderer {
        private NullLineRenderer() {
        }

        public void close() throws IOException {
        }

        public void start() {
        }

        public void stop() {
        }

        public void write(ByteArraySegment byteArraySegment) {
        }

        public long getFramesPlayed() {
            return 0L;
        }

        public void setVolume(float f) {
        }
    }

    public static interface Listener
    extends Services.SoundDeviceManagerListener {
        public void renderingStartedOrStopped(boolean var1, boolean var2);

        public void rendererStartedOrStopped(boolean var1, UUID var2);
    }

    private class StreamState {
        public UUID streamID;
        public String deviceID;
        public final LineRenderer lineRenderer;
        public long framesWritten;
        public long stopAfterFrame = -1L;
        public long lastActivityTime;
        public boolean isLineRendererRunning = false;

        public StreamState(UUID uUID, LineRenderer lineRenderer, String string, long l) {
            this.streamID = uUID;
            this.lineRenderer = lineRenderer;
            this.deviceID = string;
            this.lastActivityTime = l;
        }

        public StreamState(LineRenderer lineRenderer, String string, long l) {
            this(null, lineRenderer, string, l);
        }

        public StreamState(UUID uUID, LineRenderer lineRenderer, String string) {
            this(uUID, lineRenderer, string, 0L);
        }
    }

    public static interface LineRenderer
    extends Closeable {
        public void start() throws SoundException.DeviceInvalidatedException;

        public void stop();

        public void write(ByteArraySegment var1) throws SoundException.DeviceInvalidatedException;

        public long getFramesPlayed() throws SoundException.DeviceInvalidatedException;

        public void setVolume(float var1) throws SoundException.DeviceInvalidatedException;
    }
}

