/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.ThreadRunner;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadQueue<T>
extends ThreadRunner {
    private LinkedList<T> queue = new LinkedList();

    public ThreadQueue(int n, boolean bl) {
        super(n, bl);
    }

    @Override
    protected void onStarting() {
        super.onStarting();
        this.clearQueue();
    }

    @Override
    protected void onStopped(boolean bl) {
        super.onStopped(bl);
        this.clearQueue();
    }

    protected T dequeueItem() {
        return this.dequeueItem(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T dequeueItem(Long l) {
        T t = null;
        Object object = this.syncLock;
        synchronized (object) {
            while (!this.isStopping()) {
                if (!this.queue.isEmpty()) {
                    t = this.queue.remove();
                    break;
                }
                if (l == null) {
                    Extensions.waitQuietly(this.syncLock);
                    continue;
                }
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) {
                    return null;
                }
                Extensions.waitQuietly(this.syncLock, l2);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        Object object = this.syncLock;
        synchronized (object) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueItem(T t) {
        Extensions.assertArgumentNonNull(t);
        Object object = this.syncLock;
        synchronized (object) {
            this.queue.offer(t);
            this.syncLock.notifyAll();
        }
    }
}

