/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import java.io.Closeable;

public abstract class ThreadRunner
implements Closeable {
    private Thread thread;
    private int priority;
    private boolean rerunOnException;
    private Status status;
    protected Object syncLock;
    private Listener listener;

    public ThreadRunner(int n, boolean bl) {
        this.priority = n;
        this.rerunOnException = bl;
        this.syncLock = new Object();
        this.status = Status.Stopped;
    }

    public void close() {
        this.ensureRunState(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureRunState(boolean bl, boolean bl2) {
        Object object = this.syncLock;
        synchronized (object) {
            boolean bl3 = false;
            while (!(bl && this.status == Status.Running || !bl && this.status == Status.Stopped || bl && this.status == Status.Starting && !bl2 || !bl && this.status == Status.Stopping && !bl2 || bl && this.status == Status.Stopped && bl3)) {
                if (bl && this.status == Status.Stopped) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            ThreadRunner.this.runThread();
                        }
                    };
                    bl3 = true;
                    this.status = Status.Starting;
                    this.thread = Extensions.createThread(runnable, this.getClass().getSimpleName(), this.priority);
                    this.thread.start();
                    this.syncLock.notifyAll();
                    continue;
                }
                if (!bl && this.status == Status.Running) {
                    this.status = Status.Stopping;
                    this.syncLock.notifyAll();
                    if (bl2) continue;
                    break;
                }
                Extensions.waitQuietly(this.syncLock);
            }
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runThread() {
        this.onStarting();
        this.setStatusInLock(Status.Running);
        while (true) {
            try {
                this.run();
            }
            catch (Throwable throwable) {
                Constants.ExceptionTraceSource.traceException(throwable);
                if (this.rerunOnException) continue;
            }
            break;
        }
        boolean bl = false;
        Object object = this.syncLock;
        synchronized (object) {
            bl = this.status == Status.Running;
        }
        if (bl) {
            this.setStatusInLock(Status.Stopping);
        }
        this.setStatusInLock(Status.Stopped);
        this.onStopped(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatusInLock(Status status) {
        Object object = this.syncLock;
        synchronized (object) {
            this.status = status;
            this.syncLock.notifyAll();
        }
    }

    protected void onStarting() {
        if (this.listener != null) {
            this.listener.threadStarting();
        }
    }

    protected void onStopped(boolean bl) {
        if (this.listener != null) {
            this.listener.threadStopped(bl);
        }
    }

    public boolean isStopping() {
        return this.status == Status.Stopping;
    }

    public boolean isRunning() {
        return this.status == Status.Running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signal() {
        Object object = this.syncLock;
        synchronized (object) {
            this.syncLock.notifyAll();
        }
    }

    protected void signalStopping() {
        this.setStatusInLock(Status.Stopping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUnlessSignaled(long l) {
        Object object = this.syncLock;
        synchronized (object) {
            Extensions.waitQuietly(this.syncLock, l);
        }
    }

    protected void waitUnlessStopping(long l) {
        long l2 = System.currentTimeMillis() + l;
        this.waitUnlessStoppingUntil(l2);
    }

    protected void waitUnlessStoppingUntil(long l) {
        long l2;
        while (!this.isStopping() && (l2 = l - System.currentTimeMillis()) > 0L) {
            this.waitUnlessSignaled(l2);
        }
    }

    protected abstract void run() throws Throwable;

    public static interface Listener {
        public void threadStarting();

        public void threadStopped(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        Stopped,
        Starting,
        Running,
        Stopping;

    }
}

