/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.CoreSize;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.TypeSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;

public class TypeSerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    implements TypeSerializer<Date> {
        private static final long TicksBetween0000And1700 = 621355968000000000L;
        private static final long TicksPerMillisecond = 10000L;
        private static final long UtcFlag = 0x4000000000000000L;
        private static final long TicksMask = 0x3FFFFFFFFFFFFFFFL;

        @Override
        public void serialize(DataOutput dataOutput, Date date) throws IOException {
            long l = date == null ? 0L : 0x4000000000000000L | 621355968000000000L + date.getTime() * 10000L;
            dataOutput.writeByte((int)l);
            dataOutput.writeByte((int)(l >> 8));
            dataOutput.writeByte((int)(l >> 16));
            dataOutput.writeByte((int)(l >> 24));
            dataOutput.writeByte((int)(l >> 32));
            dataOutput.writeByte((int)(l >> 40));
            dataOutput.writeByte((int)(l >> 48));
            dataOutput.writeByte((int)(l >> 56));
        }

        @Override
        public Date deserialize(DataInput dataInput) throws IOException {
            long l = (long)dataInput.readUnsignedByte() | (long)dataInput.readUnsignedByte() << 8 | (long)dataInput.readUnsignedByte() << 16 | (long)dataInput.readUnsignedByte() << 24 | (long)dataInput.readUnsignedByte() << 32 | (long)dataInput.readUnsignedByte() << 40 | (long)dataInput.readUnsignedByte() << 48 | (long)dataInput.readUnsignedByte() << 56;
            if (l == 0L) {
                return null;
            }
            return new Date(((l & 0x3FFFFFFFFFFFFFFFL) - 621355968000000000L) / 10000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteBufferSerializer
    implements TypeSerializer<ByteArraySegment> {
        @Override
        public void serialize(DataOutput dataOutput, ByteArraySegment byteArraySegment) throws IOException {
            if (byteArraySegment == null) {
                dataOutput.writeByte(0);
            } else {
                Extensions.write7BitEncodedInt(dataOutput, byteArraySegment.count);
                dataOutput.write(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
            }
        }

        @Override
        public ByteArraySegment deserialize(DataInput dataInput) throws IOException {
            int n = Extensions.read7BitEncodedInt(dataInput);
            ByteArraySegment byteArraySegment = new ByteArraySegment(n);
            if (n != 0) {
                dataInput.readFully(byteArraySegment.array, byteArraySegment.offset, byteArraySegment.count);
            }
            return byteArraySegment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    implements TypeSerializer<String> {
        @Override
        public void serialize(DataOutput dataOutput, String string) throws IOException {
            if (string == null) {
                dataOutput.writeByte(0);
            } else {
                byte[] byArray = string.getBytes("UTF-8");
                Extensions.write7BitEncodedInt(dataOutput, byArray.length);
                dataOutput.write(byArray);
            }
        }

        @Override
        public String deserialize(DataInput dataInput) throws IOException {
            int n = Extensions.read7BitEncodedInt(dataInput);
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            return new String(byArray, "UTF-8");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoreRectSerializer
    implements TypeSerializer<CoreRect> {
        @Override
        public void serialize(DataOutput dataOutput, CoreRect coreRect) throws IOException {
            Extensions.write7BitEncodedInt(dataOutput, coreRect.x);
            Extensions.write7BitEncodedInt(dataOutput, coreRect.y);
            Extensions.write7BitEncodedInt(dataOutput, coreRect.width);
            Extensions.write7BitEncodedInt(dataOutput, coreRect.height);
        }

        @Override
        public CoreRect deserialize(DataInput dataInput) throws IOException {
            return new CoreRect(Extensions.read7BitEncodedInt(dataInput), Extensions.read7BitEncodedInt(dataInput), Extensions.read7BitEncodedInt(dataInput), Extensions.read7BitEncodedInt(dataInput));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CoreSizeSerializer
    implements TypeSerializer<CoreSize> {
        @Override
        public void serialize(DataOutput dataOutput, CoreSize coreSize) throws IOException {
            Extensions.write7BitEncodedInt(dataOutput, coreSize.width);
            Extensions.write7BitEncodedInt(dataOutput, coreSize.height);
        }

        @Override
        public CoreSize deserialize(DataInput dataInput) throws IOException {
            return new CoreSize(Extensions.read7BitEncodedInt(dataInput), Extensions.read7BitEncodedInt(dataInput));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CorePointSerializer
    implements TypeSerializer<CorePoint> {
        @Override
        public void serialize(DataOutput dataOutput, CorePoint corePoint) throws IOException {
            Extensions.write7BitEncodedInt(dataOutput, corePoint.x);
            Extensions.write7BitEncodedInt(dataOutput, corePoint.y);
        }

        @Override
        public CorePoint deserialize(DataInput dataInput) throws IOException {
            return new CorePoint(Extensions.read7BitEncodedInt(dataInput), Extensions.read7BitEncodedInt(dataInput));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UUIDSerializer
    implements TypeSerializer<UUID> {
        @Override
        public void serialize(DataOutput dataOutput, UUID uUID) throws IOException {
            Extensions.writeUUID(dataOutput, uUID);
        }

        @Override
        public UUID deserialize(DataInput dataInput) throws IOException {
            return Extensions.readUUID(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteSerializer
    implements TypeSerializer<Byte> {
        @Override
        public void serialize(DataOutput dataOutput, Byte by) throws IOException {
            dataOutput.writeByte(by.intValue());
        }

        @Override
        public Byte deserialize(DataInput dataInput) throws IOException {
            return dataInput.readByte();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanSerializer
    implements TypeSerializer<Boolean> {
        @Override
        public void serialize(DataOutput dataOutput, Boolean bl) throws IOException {
            dataOutput.writeBoolean(bl != null && bl != false);
        }

        @Override
        public Boolean deserialize(DataInput dataInput) throws IOException {
            return dataInput.readBoolean();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    implements TypeSerializer<Long> {
        @Override
        public void serialize(DataOutput dataOutput, Long l) throws IOException {
            Extensions.write7BitEncodedLong(dataOutput, l == null ? 0L : l);
        }

        @Override
        public Long deserialize(DataInput dataInput) throws IOException {
            return Extensions.read7BitEncodedLong(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerSerializer
    implements TypeSerializer<Integer> {
        @Override
        public void serialize(DataOutput dataOutput, Integer n) throws IOException {
            Extensions.write7BitEncodedInt(dataOutput, n == null ? 0 : n);
        }

        @Override
        public Integer deserialize(DataInput dataInput) throws IOException {
            return Extensions.read7BitEncodedInt(dataInput);
        }
    }
}

