/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.BufferSegment;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class VirtualFileReceiver
implements Closeable {
    private HashMap<UUID, Stream> streams = new HashMap();
    private MessagePreparerListener listener;

    public VirtualFileReceiver(MessagePreparerListener messagePreparerListener) {
        this.listener = Extensions.assertArgumentNonNull(messagePreparerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap<UUID, Stream> hashMap = this.streams;
        synchronized (hashMap) {
            for (UUID uUID : this.streams.keySet()) {
                this.releaseFile(uUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFile(UUID uUID) {
        Object object = this.streams;
        synchronized (object) {
            this.tryCloseStream(uUID);
        }
        object = new Messages.ReleaseVirtualFileMessage(uUID);
        this.listener.messageReady(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openReadStream(UUID uUID) {
        HashMap<UUID, Stream> hashMap = this.streams;
        synchronized (hashMap) {
            this.tryCloseStream(uUID);
            Stream stream = new Stream(uUID);
            this.streams.put(uUID, stream);
            return stream;
        }
    }

    private void tryCloseStream(UUID uUID) {
        Stream stream = this.streams.get(uUID);
        Extensions.closeQuietly(stream);
    }

    private void removeStream(UUID uUID) {
        this.streams.remove(uUID);
    }

    private void requestPosition(UUID uUID, long l) {
        Messages.RequestVirtualFileDataMessage requestVirtualFileDataMessage = new Messages.RequestVirtualFileDataMessage(uUID, l);
        this.listener.messageReady(requestVirtualFileDataMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(Messages.VirtualFileDataMessage virtualFileDataMessage) {
        Stream stream;
        HashMap<UUID, Stream> hashMap = this.streams;
        synchronized (hashMap) {
            stream = this.streams.get(virtualFileDataMessage.id);
            if (stream == null) {
                return false;
            }
        }
        stream.enqueueData(virtualFileDataMessage.data);
        return true;
    }

    private class Stream
    extends InputStream
    implements Closeable {
        private LinkedBlockingQueue<BufferSegment> queue;
        private int bytesAvailable;
        private long position;
        private long lastRequestedPosition;
        private UUID id;

        public Stream(UUID uUID) {
            this.id = uUID;
            this.queue = new LinkedBlockingQueue();
            this.requestPositionIfNeeded();
        }

        public void close() throws IOException {
            if (this.position != -1L) {
                VirtualFileReceiver.this.requestPosition(this.id, 0L);
                VirtualFileReceiver.this.removeStream(this.id);
                this.position = -1L;
            }
        }

        public int available() throws IOException {
            return this.bytesAvailable;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == 0) {
                return -1;
            }
            return byArray[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.position == -1L) {
                throw new IOException(this.getClass().getName());
            }
            this.requestPositionIfNeeded();
            LinkedBlockingQueue<BufferSegment> linkedBlockingQueue = this.queue;
            synchronized (linkedBlockingQueue) {
                if (this.queue.size() == 0) {
                    Extensions.waitQuietly(this.queue, 10000L);
                    if (this.queue.size() == 0) {
                        throw new IOException("Timeout waiting for virtual file read.");
                    }
                }
                BufferSegment bufferSegment = this.queue.peek();
                n3 = bufferSegment.readAsMuchAsPossibleAndAdvance(byArray, n, n2);
                this.bytesAvailable -= n3;
                this.position += (long)n3;
                if (bufferSegment.getRemainingCount() == 0 && bufferSegment.getCompletedCount() != 0) {
                    this.queue.remove();
                }
            }
            this.requestPositionIfNeeded();
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueData(ByteArraySegment byteArraySegment) {
            LinkedBlockingQueue<BufferSegment> linkedBlockingQueue = this.queue;
            synchronized (linkedBlockingQueue) {
                this.queue.add(new BufferSegment(byteArraySegment));
                this.bytesAvailable += byteArraySegment.count;
                this.queue.notifyAll();
            }
        }

        private void requestPositionIfNeeded() {
            long l = this.position + (long)this.bytesAvailable;
            if (this.lastRequestedPosition < l + 100000L) {
                long l2 = l + 200000L;
                VirtualFileReceiver.this.requestPosition(this.id, l2);
                this.lastRequestedPosition = l2;
            }
        }
    }
}

