/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.FileData;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class VirtualFileSender
implements Closeable {
    HashMap<UUID, Entry> files = new HashMap();
    MessagePreparerListener listener;

    public VirtualFileSender(MessagePreparerListener messagePreparerListener) {
        this.listener = Extensions.assertArgumentNonNull(messagePreparerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        HashMap<UUID, Entry> hashMap = this.files;
        synchronized (hashMap) {
            for (Entry entry : this.files.values()) {
                if (entry.stream == null) continue;
                entry.stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages.VirtualFileInfo[] registerVirtualFiles(FileData[] fileDataArray, String string) {
        ArrayList<Messages.VirtualFileInfo> arrayList = new ArrayList<Messages.VirtualFileInfo>();
        HashMap<UUID, Entry> hashMap = this.files;
        synchronized (hashMap) {
            for (FileData fileData : fileDataArray) {
                Messages.VirtualFileInfo virtualFileInfo = new Messages.VirtualFileInfo();
                virtualFileInfo.id = UUID.randomUUID();
                virtualFileInfo.filePath = Extensions.convertBothSlashesToChar(string == null ? fileData.getFilePath() : new File(new File(string), fileData.getFilePath()).getPath(), '/');
                virtualFileInfo.creationTime = fileData.getCreationTime();
                virtualFileInfo.lastWriteTime = fileData.getLastWriteTime();
                virtualFileInfo.lastAccessTime = fileData.getLastAccessTime();
                virtualFileInfo.size = fileData.getSize();
                virtualFileInfo.isDirectory = fileData.getIsDirectory();
                Entry entry = new Entry();
                entry.fileData = fileData;
                this.files.put(virtualFileInfo.id, entry);
                arrayList.add(virtualFileInfo);
            }
        }
        return arrayList.toArray(new Messages.VirtualFileInfo[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMessage(Messages.VirtualFileControlMessage virtualFileControlMessage) {
        Entry entry;
        HashMap<UUID, Entry> hashMap = this.files;
        synchronized (hashMap) {
            entry = this.files.get(virtualFileControlMessage.id);
            if (entry == null) {
                return false;
            }
        }
        if (virtualFileControlMessage instanceof Messages.RequestVirtualFileDataMessage) {
            hashMap = (Messages.RequestVirtualFileDataMessage)virtualFileControlMessage;
            if (((Messages.RequestVirtualFileDataMessage)((Object)hashMap)).requestedPosition == 0L) {
                if (entry.stream != null) {
                    Extensions.closeQuietly(entry.stream);
                    entry.stream = null;
                }
            } else {
                try {
                    if (entry.stream == null) {
                        entry.stream = entry.fileData.openReadStream();
                    }
                    long l = ((Messages.RequestVirtualFileDataMessage)((Object)hashMap)).requestedPosition - entry.streamPosition;
                    while (l > 0L) {
                        long l2 = Math.min(l, 1440L);
                        byte[] byArray = new byte[(int)l2];
                        int n = 0;
                        n = entry.stream.read(byArray, 0, byArray.length);
                        if (n == -1) {
                            n = 0;
                        }
                        Messages.VirtualFileDataMessage virtualFileDataMessage = new Messages.VirtualFileDataMessage(virtualFileControlMessage.id, new ByteArraySegment(byArray, 0, n));
                        this.listener.messageReady(virtualFileDataMessage);
                        l -= (long)n;
                        entry.streamPosition += (long)n;
                        if (n != 0) continue;
                    }
                }
                catch (Exception exception) {}
            }
        } else if (virtualFileControlMessage instanceof Messages.ReleaseVirtualFileMessage) {
            Extensions.closeQuietly(entry.stream);
            hashMap = this.files;
            synchronized (hashMap) {
                this.files.remove(virtualFileControlMessage.id);
            }
        }
        return true;
    }

    static class Entry {
        public FileData fileData;
        public InputStream stream;
        public long streamPosition;

        Entry() {
        }
    }
}

