/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ChatFrame
extends JFrame {
    private JTextPane textPane;
    private JTextArea textArea;
    private Listener listener;

    public ChatFrame(Listener listener) {
        this.listener = (Listener)Extensions.assertArgumentNonNull((Object)listener);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && !e.isShiftDown()) {
                    String text = ChatFrame.this.textArea.getText();
                    ChatFrame.this.listener.newChatMessage(text);
                    ChatFrame.this.textArea.setText(null);
                    e.consume();
                }
            }
        });
        JSplitPane splitPane = new JSplitPane(0, scrollPane, this.textArea);
        splitPane.setDividerLocation(200);
        this.getContentPane().add(splitPane);
        this.setSize(500, 300);
        ClientExtensions.setIconImages(this);
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                ChatFrame.this.textArea.requestFocusInWindow();
            }
        });
    }

    public void addMessage(Color color, String from, String text) {
        this.textPane.setEditable(true);
        this.addText(color, true, from + ": ");
        this.addText(Color.BLACK, false, text + '\n');
        this.textPane.setEditable(false);
    }

    void addText(Color color, boolean bold, String text) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setForeground(attributes, color);
        StyleConstants.setBold(attributes, bold);
        int position = this.textPane.getDocument().getLength();
        this.textPane.setCaretPosition(position);
        this.textPane.setCharacterAttributes(attributes, false);
        this.textPane.replaceSelection(text);
    }

    public static interface Listener {
        public void newChatMessage(String var1);
    }
}

