/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Blittable;
import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.ClientLaunchParameters;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.CoreSize;
import com.elsitech.screenconnect.EndPointManager;
import com.elsitech.screenconnect.EndPointStatus;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.FileAction;
import com.elsitech.screenconnect.FileData;
import com.elsitech.screenconnect.FileUserInterfaceManager;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.ProcessType;
import com.elsitech.screenconnect.Properties;
import com.elsitech.screenconnect.Resources;
import com.elsitech.screenconnect.ScreenQualityLevel;
import com.elsitech.screenconnect.ScreenRenderer;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SessionType;
import com.elsitech.screenconnect.SoundCapturer;
import com.elsitech.screenconnect.SoundRenderer;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.VirtualFileReceiver;
import com.elsitech.screenconnect.VirtualFileSender;
import com.elsitech.screenconnect.WaitChecker;
import com.elsitech.screenconnect.client.ChatFrame;
import com.elsitech.screenconnect.client.ClientExtensions;
import com.elsitech.screenconnect.client.ClientFileUserInterfaceManager;
import com.elsitech.screenconnect.client.ClientInputReceiver;
import com.elsitech.screenconnect.client.ClientResources;
import com.elsitech.screenconnect.client.ClientScreenCapturer;
import com.elsitech.screenconnect.client.ClientSoundCapturer;
import com.elsitech.screenconnect.client.ClientSoundRenderer;
import com.elsitech.screenconnect.client.ClipboardCapturer;
import com.elsitech.screenconnect.client.Command;
import com.elsitech.screenconnect.client.CursorCapturer;
import com.elsitech.screenconnect.client.InputSender;
import com.elsitech.screenconnect.client.JTrayIcon;
import com.elsitech.screenconnect.client.ScreenCaptureThumbnail;
import com.elsitech.screenconnect.client.ScreenFrame;
import com.elsitech.screenconnect.client.ScreenPanel;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.accessibility.Accessible;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements EndPointManager.Listener,
ChatFrame.Listener,
MessagePreparerListener,
ThreadRunner.Listener,
ScreenRenderer.RenderTargetProvider,
ScreenFrame.Listener,
ActionListener {
    private ClientFileUserInterfaceManager fileUserInterfaceManager;
    private VirtualFileSender virtualFileSender;
    private VirtualFileReceiver virtualFileReceiver;
    protected ClientScreenCapturer screenCapturer;
    private CursorCapturer cursorCapturer;
    private ScreenRenderer screenRenderer;
    private SoundCapturer soundCapturer;
    private SoundRenderer soundRenderer;
    private ClipboardCapturer clipboardCapturer;
    private ChatFrame chatFrame;
    private EndPointStatus lastEndPointStatus;
    private String applicationTitle;
    private String sessionTitle;
    private EndPointManager endPointManager;
    private ScreenFrame screenFrame;
    private Runnable stopListener;
    private JFileChooser fileChooser;
    private boolean remoteDesktopReady;
    private CoreSize remoteDesktopSize;
    private CoreRect[] remoteMonitorVirtualBounds;
    private Map<Class<?>, Boolean> unsupportedMessageTypes;
    private UUID currentConnectionID;
    private Messages.SessionStateMessage sessionStateMessage;
    private Messages.SessionConnectionInfo3[] sessionConnections;
    private EnumSet<Messages.SessionConnectionAttribute> connectionAttributes;
    private int remoteMonitorIndex;
    private Object[] components;
    private InputSender inputSender;
    private ClientInputReceiver inputReceiver;
    private Object trayIcon;
    private Messages.ToolboxItem toolbox;
    private boolean inputSuspended;
    private boolean beepOnConnect;
    private Map<UUID, JDialog> consentDialogs;
    private long manualZoomTimeMillis;

    public static Client create(ClientLaunchParameters clientLaunchParameters) {
        Extensions.assertArgumentNonNull((Object)clientLaunchParameters, (String)"clientLaunchParameters");
        Client client = new Client();
        client.initialize(clientLaunchParameters);
        return client;
    }

    protected void initialize(ClientLaunchParameters clientLaunchParameters) {
        this.applicationTitle = Resources.getString((String)"ApplicationTitle");
        String implementationVersionString = Client.class.getPackage().getImplementationVersion();
        Messages.Version version = new Messages.Version(implementationVersionString == null ? "10.0.0.0" : implementationVersionString);
        this.endPointManager = new EndPointManager(clientLaunchParameters.host, clientLaunchParameters.port, clientLaunchParameters.processType, clientLaunchParameters.sessionID, clientLaunchParameters.encryptionKey, clientLaunchParameters.accessToken, clientLaunchParameters.participantName, clientLaunchParameters.nameCallbackFormat, clientLaunchParameters.customPropertyValueCallbackFormats, version, Messages.ClientType.JAVA_SWING, clientLaunchParameters.sessionType, (EndPointManager.Listener)this);
        File receiveDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        receiveDirectory = new File(receiveDirectory, this.applicationTitle);
        WaitChecker screenCapturerWaitChecker = new WaitChecker(){

            public boolean shouldWait() {
                return Client.this.endPointManager.getOutgoingQueueDepth() > 20;
            }
        };
        this.connectionAttributes = EnumSet.noneOf(Messages.SessionConnectionAttribute.class);
        this.fileUserInterfaceManager = new ClientFileUserInterfaceManager(receiveDirectory);
        this.virtualFileReceiver = new VirtualFileReceiver((MessagePreparerListener)this);
        this.virtualFileSender = new VirtualFileSender((MessagePreparerListener)this);
        this.cursorCapturer = new CursorCapturer(this);
        this.screenCapturer = new ClientScreenCapturer(this, screenCapturerWaitChecker);
        this.screenRenderer = new ScreenRenderer(9600, (ScreenRenderer.RenderTargetProvider)this);
        this.soundCapturer = new ClientSoundCapturer(this, new SoundCapturer.Listener(){

            public void sendingStartedOrStopped() {
            }

            public void runningDeviceChanged() {
            }
        });
        this.soundRenderer = new ClientSoundRenderer((SoundRenderer.Listener)new Services.GeneralSoundRendererListener(this.soundCapturer));
        this.inputSender = new InputSender(this);
        this.inputReceiver = new ClientInputReceiver();
        this.clipboardCapturer = new ClipboardCapturer(this, this.virtualFileSender);
        this.components = new Object[]{this.endPointManager, this.cursorCapturer, this.screenCapturer, this.screenRenderer, this.soundCapturer, this.soundRenderer, this.virtualFileReceiver, this.virtualFileSender, this.inputSender, this.inputReceiver, this.clipboardCapturer};
        this.remoteMonitorIndex = -1;
        this.unsupportedMessageTypes = new HashMap();
        this.addUnsupportedMessageType(Messages.SystemKeyCodeMessage.class, true);
        this.addUnsupportedMessageType(Messages.RebootReconnectMessage.class, true);
        this.addUnsupportedMessageType(Messages.BlockInputMessage.class, true);
        this.addUnsupportedMessageType(Messages.BlankMonitorMessage.class, true);
        this.addUnsupportedMessageType(Messages.CredentialsActionMessage.class, true);
    }

    public void start(Runnable stopListener) {
        for (Object component : this.components) {
            if (!(component instanceof ThreadRunner)) continue;
            ((ThreadRunner)component).setListener((ThreadRunner.Listener)this);
        }
        this.stopListener = stopListener;
        this.endPointManager.ensureRunState(true, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Client.this.endPointManager.getSessionType() == SessionType.Meeting || Client.this.endPointManager.getProcessType() == ProcessType.Host) {
                    Client.this.ensureScreenFrame();
                    Client.this.screenFrame.setVisible(true);
                }
                if (Client.this.endPointManager.getProcessType() == ProcessType.Guest && Properties.getUserProperty((String)"screenconnect.guest.tray.icon.display") != null) {
                    Client.this.tryEnsureTrayIcon();
                }
                Client.this.updateUserInterface();
            }
        });
    }

    public void addUnsupportedMessageType(Class<?> messageType, boolean displayOrIgnore) {
        this.unsupportedMessageTypes.put(messageType, displayOrIgnore);
    }

    protected void initiateClose() {
        if (this.endPointManager.getSessionType() != SessionType.Access && this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAN_END_SESSION)) {
            String message = Resources.getString((String)"ClosePrompt");
            int option = JOptionPane.showConfirmDialog(null, message);
            if (option != 2) {
                if (option == 0) {
                    this.endPointManager.enqueueOutgoingMessage((Object)new Messages.EndSessionMessage());
                } else {
                    this.endPointManager.ensureRunState(false, false);
                }
            }
        } else {
            this.endPointManager.ensureRunState(false, false);
        }
    }

    protected void finalizeClose() {
        if (this.screenFrame != null) {
            this.screenFrame.dispose();
        }
        if (this.chatFrame != null) {
            this.chatFrame.dispose();
        }
        if (this.stopListener != null) {
            this.stopListener.run();
        }
    }

    public void messageReceived(Object message) {
        Boolean displayOrIgnoreUnsupportedMessage = this.unsupportedMessageTypes.get(message.getClass());
        if (displayOrIgnoreUnsupportedMessage != null) {
            if (displayOrIgnoreUnsupportedMessage.booleanValue()) {
                String errorFormat = Resources.getString((String)"OperationNotSupportedMessageFormat");
                final String errorMessage = String.format(errorFormat, message.getClass().getSimpleName());
                new Thread(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, errorMessage);
                    }
                }).start();
            }
        } else {
            this.processMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(final Object message) {
        if (message instanceof Messages.ScreenMessage) {
            this.screenRenderer.enqueueItem((Object)((Messages.ScreenMessage)message));
        } else if (message instanceof Messages.InputMessage) {
            this.inputReceiver.processMessage((Messages.InputMessage)message);
        } else if (message instanceof Messages.SoundMessage2) {
            this.soundRenderer.enqueueItem((Object)((Messages.SoundMessage2)message));
        } else if (message instanceof Messages.ClipboardTextMessage) {
            this.clipboardCapturer.processMessage((Messages.ClipboardTextMessage)message);
        } else if (message instanceof Messages.ClipboardFilesMessage) {
            this.clipboardCapturer.processMessage((Messages.ClipboardFilesMessage)message);
        } else if (message instanceof Messages.ReceiveFilesMessage || message instanceof Messages.ReceiveFolderMessage) {
            new Thread(new Runnable(){

                public void run() {
                    Client.this.promptSendFiles();
                }
            }).start();
        } else if (message instanceof Messages.ChatMessage2) {
            if (!Extensions.isNullOrEmpty((String)((Messages.ChatMessage2)message).text)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Client.this.activateChatFrame();
                        String senderName = Extensions.getParticipantNameText((String)((Messages.ChatMessage2)message).senderName);
                        Client.this.chatFrame.addMessage(((Messages.ChatMessage2)message).senderProcessType == ProcessType.Host ? Color.BLUE : Color.RED, senderName, ((Messages.ChatMessage2)message).text);
                    }
                });
            }
        } else if (message instanceof Messages.ScreenCodecMessage) {
            this.screenCapturer.setCodecID(((Messages.ScreenCodecMessage)message).codecID);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Client.this.updateUserInterface();
                }
            });
        } else if (message instanceof Messages.ResetCaptureStateMessage2) {
            Extensions.stopCaptureStateDependentThreadRunners((Object[])this.components);
            this.endPointManager.enqueueOutgoingMessage(message);
        } else if (message instanceof Messages.SessionStateMessage) {
            this.sessionStateMessage = (Messages.SessionStateMessage)message;
        } else if (message instanceof Messages.SessionConnectionsChangedMessage3) {
            ClientExtensions.tryInvokeAndWait(new Runnable(){

                public void run() {
                    Client.this.currentConnectionID = ((Messages.SessionConnectionsChangedMessage3)message).currentConnectionID;
                    Client.access$402(Client.this, ((Messages.SessionConnectionsChangedMessage3)message).connections);
                    for (Messages.SessionConnectionInfo3 sci : ((Messages.SessionConnectionsChangedMessage3)message).connections) {
                        if (!sci.connectionID.equals(Client.this.currentConnectionID)) continue;
                        Client.this.connectionAttributes = sci.attributes;
                    }
                    Client.this.onSessionConnectionsChanged();
                    Client.this.ensureSessionAttributeBasedState();
                }
            });
        } else if (message instanceof Messages.ViewportMessage) {
            CoreRect viewport = ((Messages.ViewportMessage)message).bounds.intersection(new CoreRect(new CorePoint(), ClientExtensions.fromAwt(ClientExtensions.getDesktopBounds().getSize())));
            this.screenCapturer.setViewport(viewport);
        } else if (message instanceof Messages.DesktopSizeMessage) {
            ClientExtensions.tryInvokeAndWait(new Runnable(){

                public void run() {
                    Client.this.remoteDesktopSize = ((Messages.DesktopSizeMessage)message).size;
                    Client.access$802(Client.this, message instanceof Messages.DesktopSizeMessage2 ? ((Messages.DesktopSizeMessage2)message).monitorVirtualBounds : null);
                    Client.this.ensureScreenFrame();
                    Client.this.updateUserInterface();
                    Client.this.remoteDesktopReady = true;
                    Client.this.sendViewport();
                }
            });
        } else {
            if (message instanceof Messages.ToolboxMessage) {
                EndPointManager viewport = this.endPointManager;
                synchronized (viewport) {
                    this.toolbox = ((Messages.ToolboxMessage)message).toolbox;
                    this.endPointManager.notifyAll();
                }
            }
            if (message instanceof Messages.WakeTokenMessage) {
                try {
                    Extensions.sendWakeToken((byte[])((Messages.WakeTokenMessage)message).wakeToken.copyBytes(), (InetAddress)this.endPointManager.getLocalAddress());
                }
                catch (Exception ex) {
                    Constants.ExceptionTraceSource.traceException((Throwable)ex);
                }
            } else if (message instanceof Messages.RequestGuestInfoMessage) {
                Messages.GuestInfoMessage guestInfoMessage = new Messages.GuestInfoMessage();
                try {
                    guestInfoMessage.loggedOnUserDomain = ClientExtensions.getLoggedOnUserDomain();
                    guestInfoMessage.loggedOnUserName = ClientExtensions.getLoggedOnUserName();
                    guestInfoMessage.idleSeconds = ClientExtensions.getIdleSeconds();
                    guestInfoMessage.machineName = Extensions.getMachineName();
                    guestInfoMessage.machineDomain = ClientExtensions.getMachineDomain();
                    guestInfoMessage.operatingSystemName = ClientExtensions.getOperatingSystemName();
                    guestInfoMessage.operatingSystemVersion = ClientExtensions.getOperatingSystemVersion();
                    guestInfoMessage.processorName = ClientExtensions.getProcessorName();
                    guestInfoMessage.processorVirtualCount = ClientExtensions.getProcessorVirtualCount();
                    guestInfoMessage.systemMemoryAvailableMegabytes = ClientExtensions.getAvailableSystemMemorySize() / 0x100000L;
                    guestInfoMessage.systemMemoryTotalMegabytes = ClientExtensions.getTotalSystemMemorySize() / 0x100000L;
                    guestInfoMessage.wakeToken = new ByteArraySegment(ClientExtensions.tryGetWakeToken(this.endPointManager.getLocalAddress()));
                    try {
                        ScreenCaptureThumbnail screenCapture = ClientExtensions.captureScreen((float)((Messages.RequestGuestInfoMessage)message).screenshotMaxScalePercent.intValue() / 100.0f, ((Messages.RequestGuestInfoMessage)message).screenshotMaxPixelCount, Integer.MAX_VALUE, Integer.MAX_VALUE);
                        guestInfoMessage.screenshotContentHash = new ByteArraySegment(screenCapture.contentHash);
                        guestInfoMessage.screenshotContentType = screenCapture.contentType;
                        if (!guestInfoMessage.screenshotContentHash.contentEquals(((Messages.RequestGuestInfoMessage)message).currentScreenshotContentHash)) {
                            guestInfoMessage.screenshotContent = new ByteArraySegment(screenCapture.content);
                        }
                    }
                    catch (Exception ex) {
                        Constants.ExceptionTraceSource.traceException((Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    Constants.ExceptionTraceSource.traceException((Throwable)ex);
                }
                this.endPointManager.enqueueOutgoingMessage((Object)guestInfoMessage);
            } else if (message instanceof Messages.CommandMessage) {
                Messages.CommandMessage resultMessage = Extensions.runCommandMessage((Messages.CommandMessage)((Messages.CommandMessage)message));
                this.endPointManager.enqueueOutgoingMessage((Object)resultMessage);
            } else if (message instanceof Messages.VirtualFileControlMessage) {
                this.virtualFileSender.processMessage((Messages.VirtualFileControlMessage)message);
            } else if (message instanceof Messages.VirtualFileDataMessage) {
                this.virtualFileReceiver.processMessage((Messages.VirtualFileDataMessage)message);
            } else if (message instanceof Messages.TransferFilesMessage) {
                Extensions.tryTransferFilesOnThread((FileUserInterfaceManager)this.fileUserInterfaceManager, (VirtualFileReceiver)this.virtualFileReceiver, (Messages.VirtualFileInfo[])((Messages.TransferFilesMessage)message).files, (FileAction)((Messages.TransferFilesMessage)message).action);
            }
        }
    }

    protected void onSessionConnectionsChanged() {
        if (this.screenFrame != null && this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_SCREEN)) {
            this.screenFrame.setExtendedState(1);
        }
        if (this.connectionAttributes.contains(Messages.SessionConnectionAttribute.RENDER_SCREEN)) {
            this.ensureScreenFrame();
            this.screenFrame.setVisible(true);
        }
        this.updateUserInterface();
        if (this.endPointManager.getSessionType() != SessionType.Meeting && this.endPointManager.getProcessType() == ProcessType.Guest) {
            this.refreshConsentDialogs();
        }
    }

    void refreshConsentDialogs() {
        HashMap<UUID, Messages.SessionConnectionInfo3> hostConnectionsNeedingConsent = new HashMap<UUID, Messages.SessionConnectionInfo3>();
        if (this.sessionConnections != null) {
            for (Messages.SessionConnectionInfo3 sci : this.sessionConnections) {
                if (!sci.attributes.contains(Messages.SessionConnectionAttribute.NEEDS_CONSENT)) continue;
                hostConnectionsNeedingConsent.put(sci.connectionID, sci);
            }
        }
        if (this.consentDialogs != null) {
            for (Map.Entry entry : Extensions.copyToList(this.consentDialogs.entrySet())) {
                if (hostConnectionsNeedingConsent.containsKey(entry.getKey())) continue;
                this.consentDialogs.remove(entry.getKey());
                ((JDialog)entry.getValue()).dispose();
            }
        }
        if (hostConnectionsNeedingConsent.size() != 0) {
            if (this.consentDialogs == null) {
                this.consentDialogs = new HashMap<UUID, JDialog>();
            }
            for (Map.Entry entry : hostConnectionsNeedingConsent.entrySet()) {
                if (this.consentDialogs.containsKey(entry.getKey())) continue;
                final UUID connectionID = ((Messages.SessionConnectionInfo3)entry.getValue()).connectionID;
                final String consentButtonText = Resources.getString((String)"ConsentHostConsentButtonText");
                final String refuseButtonText = Resources.getString((String)"ConsentHostRefuseButtonText");
                String labelText = String.format(Resources.getString((String)"ConsentHostLabelFormat"), Extensions.getParticipantNameText((String)((Messages.SessionConnectionInfo3)entry.getValue()).participantName));
                JOptionPane pane = new JOptionPane(labelText, -1, -1, null, new String[]{consentButtonText, refuseButtonText});
                JDialog dialog = pane.createDialog(String.format(Resources.getString((String)"ConsentHostTitleFormat"), this.applicationTitle));
                ClientExtensions.setIconImages(dialog);
                dialog.setDefaultCloseOperation(2);
                dialog.setModal(false);
                this.consentDialogs.put(connectionID, dialog);
                pane.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("value")) {
                            Boolean consentOrRefuse = null;
                            if (consentButtonText.equals(evt.getNewValue())) {
                                consentOrRefuse = true;
                            } else if (refuseButtonText.equals(evt.getNewValue())) {
                                consentOrRefuse = false;
                            }
                            if (consentOrRefuse != null) {
                                Client.this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ConsentMessage2(connectionID, consentOrRefuse.booleanValue()));
                            }
                            Client.this.consentDialogs.remove(connectionID);
                        }
                    }
                });
                dialog.setVisible(true);
            }
        }
    }

    private void ensureSessionAttributeBasedState() {
        this.screenCapturer.setUseFastScreenStart(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.FAST_SCREEN_START));
        this.screenCapturer.ensureRunState(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_SCREEN), true);
        this.cursorCapturer.ensureRunState(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_SCREEN), true);
        this.screenRenderer.ensureRunState(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.RENDER_SCREEN), true);
        this.soundRenderer.ensureRunState(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.RENDER_SOUND), true);
        this.soundCapturer.ensureRunState(this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_MICROPHONE_SOUND), true);
        this.clipboardCapturer.ensureRunState(Extensions.intersectsWith(this.connectionAttributes, EnumSet.of(Messages.SessionConnectionAttribute.INPUT_RECEIVER, Messages.SessionConnectionAttribute.INPUT_SENDER)), true);
    }

    @Override
    public void onViewportChanged() {
        if (this.remoteDesktopReady) {
            this.sendViewport();
        }
    }

    private void sendViewport() {
        Messages.ViewportMessage viewportMessage = new Messages.ViewportMessage();
        viewportMessage.bounds = ClientExtensions.fromAwt(this.screenFrame.getRemoteScreenViewport());
        this.endPointManager.enqueueOutgoingMessage((Object)viewportMessage);
    }

    protected Rectangle getRemoteScreenCropBounds() {
        if (this.remoteMonitorIndex != -1 && this.remoteMonitorVirtualBounds != null && this.remoteMonitorVirtualBounds.length > this.remoteMonitorIndex) {
            return ClientExtensions.toAwt(this.remoteMonitorVirtualBounds[this.remoteMonitorIndex]);
        }
        return new Rectangle(new Point(), ClientExtensions.toAwt(this.remoteDesktopSize));
    }

    public Blittable[] getRenderTargets() {
        this.ensureScreenFrame();
        return new Blittable[]{this.screenFrame.getScreenPanel()};
    }

    public void statusChanged(final EndPointStatus status) {
        this.remoteDesktopReady = false;
        final EndPointStatus newEndPointStatus = this.endPointManager.getStatus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Client.this.sessionConnections != null) {
                    Client.this.connectionAttributes = EnumSet.noneOf(Messages.SessionConnectionAttribute.class);
                    Client.access$402(Client.this, null);
                    Client.this.sessionStateMessage = null;
                    Client.this.onSessionConnectionsChanged();
                    Client.this.ensureSessionAttributeBasedState();
                }
                if (newEndPointStatus != Client.this.lastEndPointStatus) {
                    Client.this.lastEndPointStatus = Client.this.endPointManager.getStatus();
                    if (Client.this.trayIcon != null) {
                        String statusTitleText = Extensions.getEndPointStatusString((EndPointManager)Client.this.endPointManager, (boolean)true);
                        String balloonBody = Extensions.joinNonNullOrEmpty((String)System.getProperty("line.separator"), (String[])new String[]{Client.this.applicationTitle, Client.this.sessionTitle, statusTitleText});
                        ((TrayIcon)Client.this.trayIcon).displayMessage(Client.this.applicationTitle, balloonBody, TrayIcon.MessageType.INFO);
                    }
                    if (Client.this.endPointManager.getStatus() == EndPointStatus.Connected && Client.this.beepOnConnect) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    Client.this.updateUserInterface();
                }
                if (status == EndPointStatus.Stopped) {
                    Client.this.finalizeClose();
                }
            }
        });
    }

    void promptSendFiles() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.fileUserInterfaceManager.getBaseDirectory());
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileSelectionMode(2);
        }
        if (this.fileChooser.showDialog(null, null) == 0) {
            File[] selectedFiles = this.fileChooser.getSelectedFiles();
            FileData[] fileDatas = FileData.getFileDatas((File[])selectedFiles);
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.TransferFilesMessage(FileAction.TRANSFER, this.virtualFileSender.registerVirtualFiles(fileDatas, null)));
        }
    }

    protected void updateUserInterface() {
        String statusTitle = Extensions.getEndPointStatusString((EndPointManager)this.endPointManager, (boolean)true);
        String fullTitle = Extensions.joinNonNullOrEmpty((String)" - ", (String[])new String[]{this.applicationTitle, this.sessionTitle, statusTitle});
        ArrayList<Object> menuItems = new ArrayList<Object>();
        if (this.screenFrame != null) {
            this.screenFrame.setTitle(fullTitle);
            JMenuBar menuBar = this.screenFrame.getJMenuBar();
            ClientExtensions.populateMenuHierarchy(menuBar, menuItems);
            if (this.remoteDesktopSize != null) {
                Rectangle screenCropBounds = this.getRemoteScreenCropBounds();
                boolean screenSizeChanged = this.screenFrame.getScreenPanel().setScreenSize(ClientExtensions.toAwt(this.remoteDesktopSize));
                boolean cropBoundsChanged = this.screenFrame.getScreenPanel().setScreenCropBounds(screenCropBounds);
                if (screenSizeChanged || cropBoundsChanged) {
                    Dimension maxWindowSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
                    for (int zoomScaleIndex = Arrays.binarySearch(Constants.StandardZoomScales, 1.0); zoomScaleIndex >= 0; --zoomScaleIndex) {
                        this.screenFrame.getScreenPanel().setScreenScale(Constants.StandardZoomScales[zoomScaleIndex]);
                        this.screenFrame.revalidate();
                        Dimension preferredSize = this.screenFrame.getPreferredSize();
                        if (preferredSize.width <= maxWindowSize.width && preferredSize.height <= maxWindowSize.height) break;
                    }
                    ClientExtensions.tryPackFrame(this.screenFrame);
                }
            }
            if (this.connectionAttributes.contains(Messages.SessionConnectionAttribute.RENDER_SCREEN) && !this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_REQUESTED)) {
                this.screenFrame.setInfoPanel(null);
                this.screenFrame.getScreenPanel().setScreenEnabled(true);
            } else {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 3));
                JLabel headingLabel = new JLabel();
                headingLabel.setAlignmentX(0.0f);
                headingLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
                panel.add(headingLabel);
                if (this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_REQUESTED)) {
                    headingLabel.setText(Resources.getString((String)("InfoPanelShare" + this.endPointManager.getProcessType() + "Title")));
                    final JRadioButton everybodyButton = new JRadioButton(Resources.getString((String)"ShareEverybodyText"));
                    JRadioButton nobodyButton = new JRadioButton(Resources.getString((String)"ShareNobodyText"));
                    nobodyButton.setSelected(true);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    buttonGroup.add(everybodyButton);
                    buttonGroup.add(nobodyButton);
                    JLabel inputLabel = new JLabel(Resources.getString((String)"ShareAllowInputLabelText"));
                    JPanel inputPanel = new JPanel();
                    inputPanel.add(everybodyButton);
                    inputPanel.add(nobodyButton);
                    JPanel formPanel = new JPanel();
                    formPanel.setAlignmentX(0.0f);
                    formPanel.add(inputLabel);
                    formPanel.add(inputPanel);
                    panel.add(formPanel);
                    JButton shareButton = new JButton(Resources.getString((String)("CommandShareMyDesktop" + this.endPointManager.getProcessType())));
                    JButton cancelButton = new JButton(Resources.getString((String)("CommandUnshareMyDesktop" + this.endPointManager.getProcessType())));
                    JPanel buttonPanel = new JPanel();
                    buttonPanel.setAlignmentX(0.0f);
                    buttonPanel.add(shareButton);
                    buttonPanel.add(cancelButton);
                    panel.add(buttonPanel);
                    shareButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Client.this.onCommand(Command.ShareMyDesktop, everybodyButton.isSelected() ? "WithInput" : "WithoutInput");
                        }
                    });
                    cancelButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Client.this.onCommand(Command.ShareMyDesktop, "Cancel");
                        }
                    });
                } else {
                    headingLabel.setText(statusTitle);
                    String statusDescription = Extensions.getEndPointStatusString((EndPointManager)this.endPointManager, (boolean)false);
                    JTextArea descriptionLabel = new JTextArea(statusDescription);
                    descriptionLabel.setAlignmentX(0.0f);
                    descriptionLabel.setLineWrap(true);
                    descriptionLabel.setWrapStyleWord(true);
                    descriptionLabel.setEditable(false);
                    descriptionLabel.setPreferredSize(new Dimension(350, 100));
                    descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(5));
                    panel.add(descriptionLabel);
                }
                ClientExtensions.setAllOpaque(panel, false);
                this.screenFrame.setInfoPanel(panel);
                this.screenFrame.getScreenPanel().setScreenEnabled(false);
            }
        }
        if (this.trayIcon != null) {
            ((TrayIcon)this.trayIcon).setToolTip(fullTitle);
            PopupMenu menu = ((TrayIcon)this.trayIcon).getPopupMenu();
            ClientExtensions.populateMenuHierarchy(menu, menuItems);
        }
        this.updateMenuItemState(menuItems);
    }

    void updateMenuItemState(List<Object> menuItems) {
        for (Object menuItem : menuItems) {
            Command command = ClientExtensions.getCommand(menuItem);
            String commandArgument = ClientExtensions.getCommandArgument(menuItem);
            if (ClientExtensions.isCheckable(menuItem)) {
                boolean checked = this.isMenuItemChecked(command, commandArgument);
                ClientExtensions.setMenuItemChecked(menuItem, checked);
            }
            boolean enabled = this.isCommandEnabled(command, commandArgument);
            ClientExtensions.trySetMenuOrItemEnabled(menuItem, enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = ClientExtensions.getCommand(e.getSource());
        String commandArgument = ClientExtensions.getCommandArgument(e.getSource());
        this.onCommand(command, commandArgument);
    }

    boolean isMenuItemChecked(Command command, String commandArgument) {
        if (command == Command.ToggleBlankGuestMonitor) {
            return this.sessionStateMessage != null && this.sessionStateMessage.monitorBlanked != false;
        }
        if (command == Command.ToggleBlockGuestInput) {
            return this.sessionStateMessage != null && this.sessionStateMessage.inputBlocked != false;
        }
        if (command == Command.SelectSoundCaptureMode) {
            return this.sessionStateMessage != null && this.sessionStateMessage.soundCaptureMode.intValue() == Messages.SoundCaptureMode.valueOf((String)commandArgument).ordinal();
        }
        if (command == Command.ToggleBeepOnConnect) {
            return this.beepOnConnect;
        }
        if (command == Command.ToggleSuspendMyInput) {
            return this.inputSuspended;
        }
        if (command == Command.SelectMonitor) {
            return this.remoteMonitorIndex == Integer.parseInt(commandArgument);
        }
        if (command == Command.SelectQuality) {
            return this.sessionStateMessage != null && this.sessionStateMessage.screenQualityLevel == ScreenQualityLevel.valueOf((String)commandArgument);
        }
        if (command == Command.ZoomToScale) {
            return this.screenFrame.getScreenPanel().getScreenScale() == Double.parseDouble(commandArgument);
        }
        return false;
    }

    boolean isCommandEnabled(Command command, String commandArgument) {
        if (this.endPointManager.getStatus() != EndPointStatus.Connected) {
            switch (command) {
                case SelectMonitor: 
                case SelectQuality: 
                case ZoomToScale: 
                case ToggleBlankGuestMonitor: 
                case ToggleBlockGuestInput: 
                case SendSystemKeyCode: 
                case ShareMyDesktop: 
                case Reboot: 
                case ManageCredentials: 
                case ControlPanelReboot: {
                    return false;
                }
            }
        }
        if (!this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CONTROLLER)) {
            switch (command) {
                case SelectQuality: 
                case ToggleBlankGuestMonitor: 
                case ToggleBlockGuestInput: 
                case SendSystemKeyCode: 
                case Reboot: 
                case ManageCredentials: 
                case SelectSoundCaptureMode: {
                    return false;
                }
            }
        }
        if (!this.endPointManager.getStatus().isFlagSet(EndPointStatus.FlagInSession)) {
            switch (command) {
                case ControlPanelMessages: 
                case ShowChat: 
                case ControlPanelParticipants: {
                    return false;
                }
            }
        }
        if (!this.connectionAttributes.contains(Messages.SessionConnectionAttribute.FILE_TRANSFER)) {
            switch (command) {
                case ControlPanelToolbox: 
                case ControlPanelFileTransfer: 
                case SendFiles: 
                case ReceiveFiles: 
                case RunTool: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void onCommand(Command command, String commandArgument) {
        if (command == Command.ShowChat) {
            this.activateChatFrame();
        } else if (command == Command.SendFiles) {
            this.promptSendFiles();
        } else if (command == Command.ReceiveFiles) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ReceiveFilesMessage());
        } else if (command == Command.Exit) {
            this.initiateClose();
        } else if (command == Command.Reboot) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.RebootReconnectMessage(commandArgument.equals("ToSafeMode")));
        } else if (command == Command.ManageCredentials) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.CredentialsActionMessage(commandArgument.equals("PromptForStorage") ? Messages.CredentialsAction.PROMPT_FOR_STORAGE : Messages.CredentialsAction.SEND_TO_SCREEN));
        } else if (command == Command.SendSystemKeyCode) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.SystemKeyCodeMessage());
        } else if (command == Command.ShareMyDesktop) {
            if (Extensions.isNullOrEmpty((String)commandArgument)) {
                this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ControlConnectionActionMessage2(this.currentConnectionID, Messages.ControlConnectionAction.REQUEST_CAPTURE));
            } else {
                this.endPointManager.enqueueOutgoingMessage((Object)new Messages.SetCaptureMessage(!commandArgument.equals("Cancel"), false, commandArgument.equals("WithInput")));
            }
        } else if (command == Command.ToggleBlankGuestMonitor) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.BlankMonitorMessage(!this.isMenuItemChecked(command, commandArgument)));
        } else if (command == Command.ToggleBlockGuestInput) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.BlockInputMessage(!this.isMenuItemChecked(command, commandArgument)));
        } else if (command == Command.SelectMonitor) {
            this.remoteMonitorIndex = Integer.parseInt(commandArgument);
            this.updateUserInterface();
        } else if (command == Command.SelectQuality) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ScreenQualityLevelMessage(ScreenQualityLevel.valueOf((String)commandArgument)));
        } else if (command == Command.ZoomToScale) {
            this.manualZoomTimeMillis = System.currentTimeMillis();
            this.screenFrame.getScreenPanel().setScreenScale(Double.parseDouble(commandArgument));
            ClientExtensions.tryPackFrame(this.screenFrame);
        } else if (command == Command.SelectSoundCaptureMode) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.SetSoundCaptureModeMessage(Messages.SoundCaptureMode.valueOf((String)commandArgument)));
        } else if (command == Command.RunTool) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ToolboxOperationMessage(Messages.ToolboxOperation.RUN_TOOL, commandArgument, null));
        } else if (command == Command.RequestParticipantShare) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ControlConnectionActionMessage2(UUID.fromString(commandArgument), Messages.ControlConnectionAction.REQUEST_CAPTURE));
        } else if (command == Command.StopParticipantShare) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ControlConnectionActionMessage2(UUID.fromString(commandArgument), Messages.ControlConnectionAction.STOP_CAPTURE));
        } else if (command == Command.DisconnectParticipant) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ControlConnectionActionMessage2(UUID.fromString(commandArgument), Messages.ControlConnectionAction.FORCE_DISCONNECT));
        } else if (command == Command.ToggleBeepOnConnect) {
            this.beepOnConnect = !this.beepOnConnect;
        } else if (command == Command.ToggleSuspendMyInput) {
            this.inputSuspended = !this.inputSuspended;
        } else if (command == Command.OpenUrl) {
            ClientExtensions.desktopOpenUriQuietly(commandArgument);
        }
        this.updateUserInterface();
    }

    protected void activateChatFrame() {
        if (this.chatFrame == null) {
            String titleFormat = Resources.getString((String)"ChatTitleFormat");
            String title = String.format(titleFormat, this.applicationTitle);
            this.chatFrame = new ChatFrame(this);
            this.chatFrame.setTitle(title);
        }
        this.chatFrame.setVisible(true);
    }

    protected void ensureScreenFrame() {
        if (this.screenFrame == null) {
            this.screenFrame = new ScreenFrame();
            this.screenFrame.setListener(this);
            this.screenFrame.setDefaultCloseOperation(0);
            ClientExtensions.setIconImages(this.screenFrame);
            this.screenFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (Client.this.trayIcon != null) {
                        Client.this.screenFrame.setExtendedState(1);
                    } else {
                        Client.this.initiateClose();
                    }
                }

                public void windowActivated(WindowEvent e) {
                    if (Client.this.connectionAttributes.contains(Messages.SessionConnectionAttribute.CAPTURE_SCREEN)) {
                        Client.this.endPointManager.enqueueOutgoingMessage((Object)new Messages.SetCaptureMessage(false, false, false));
                    }
                }
            });
            this.screenFrame.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    if (System.currentTimeMillis() - Client.this.manualZoomTimeMillis > 1000L) {
                        Insets insets = Client.this.screenFrame.getScreenScrollPane().getInsets();
                        double screenScale1 = Client.this.screenFrame.getScreenPanel().getScreenScaleForPreferredWidth(((Client)Client.this).screenFrame.getContentSize().width - insets.left - insets.right);
                        double screenScale2 = Client.this.screenFrame.getScreenPanel().getScreenScaleForPreferredHeight(((Client)Client.this).screenFrame.getContentSize().height - insets.top - insets.bottom);
                        double screenScale = Math.min(screenScale1, screenScale2);
                        Client.this.screenFrame.getScreenPanel().setScreenScale(screenScale);
                        Client.this.screenFrame.revalidate();
                        Client.this.screenFrame.repaint();
                    }
                }
            });
            ScreenPanel screenPanel = this.screenFrame.getScreenPanel();
            screenPanel.addKeyListener(this.inputSender);
            screenPanel.addMouseListener(this.inputSender);
            screenPanel.addMouseMotionListener(this.inputSender);
            screenPanel.addMouseWheelListener(this.inputSender);
            JMenuBar menuBar = this.screenFrame.getJMenuBar();
            if (this.endPointManager.getProcessType() == ProcessType.Host) {
                JMenu viewMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelView);
                JMenu monitorsMenu = ClientExtensions.addMenu(viewMenu, Command.ControlPanelSelectMonitors);
                monitorsMenu.addMenuListener(new MonitorsMenuPopulator());
                JMenu qualityMenu = ClientExtensions.addMenu(viewMenu, Command.ControlPanelSelectQuality);
                ClientExtensions.addMenuItem(qualityMenu, Command.SelectQuality, ScreenQualityLevel.High.toString(), true, this);
                ClientExtensions.addMenuItem(qualityMenu, Command.SelectQuality, ScreenQualityLevel.Medium.toString(), true, this);
                ClientExtensions.addMenuItem(qualityMenu, Command.SelectQuality, ScreenQualityLevel.Low.toString(), true, this);
                JMenu zoomMenu = ClientExtensions.addMenu(viewMenu, Command.ControlPanelZoom);
                zoomMenu.addMenuListener(new ZoomMenuPopulator());
            }
            if (this.endPointManager.getSessionType() != SessionType.Meeting && this.endPointManager.getProcessType() == ProcessType.Host) {
                JMenu miscellaneousMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelMiscellaneous);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.SendSystemKeyCode, null, false, this);
                JMenu rebootAndReconnectMenu = ClientExtensions.addMenu(miscellaneousMenu, Command.ControlPanelReboot);
                ClientExtensions.addMenuItem(rebootAndReconnectMenu, Command.Reboot, "ToNormalMode", false, this);
                ClientExtensions.addMenuItem(rebootAndReconnectMenu, Command.Reboot, "ToSafeMode", false, this);
                JMenu manageCredentialsMenu = ClientExtensions.addMenu(miscellaneousMenu, Command.ControlPanelManageCredentials);
                ClientExtensions.addMenuItem(manageCredentialsMenu, Command.ManageCredentials, "PromptForStorage", false, this);
                ClientExtensions.addMenuItem(manageCredentialsMenu, Command.ManageCredentials, "SendToScreen", false, this);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.ShareMyDesktop, null, false, this);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.ToggleSuspendMyInput, null, true, this);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.ToggleBlockGuestInput, null, true, this);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.ToggleBlankGuestMonitor, null, true, this);
                ClientExtensions.addMenuItem(miscellaneousMenu, Command.ToggleBeepOnConnect, null, true, this);
            }
            if (this.endPointManager.getSessionType() != SessionType.Meeting && this.endPointManager.getProcessType() == ProcessType.Host) {
                JMenu toolboxMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelToolbox);
                toolboxMenu.addMenuListener(new ToolboxMenuPopulator());
            }
            if (this.endPointManager.getSessionType() != SessionType.Meeting) {
                JMenu fileTransferMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelFileTransfer);
                ClientExtensions.addMenuItem(fileTransferMenu, Command.SendFiles, null, false, this);
                ClientExtensions.addMenuItem(fileTransferMenu, Command.ReceiveFiles, null, false, this);
            }
            JMenu soundMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelSound);
            if (this.endPointManager.getProcessType() == ProcessType.Host) {
                JMenu soundCaptureModeMenu = ClientExtensions.addMenu(soundMenu, Command.ControlPanelSelectSoundCaptureMode);
                ClientExtensions.addMenuItem(soundCaptureModeMenu, Command.SelectSoundCaptureMode, Messages.SoundCaptureMode.Silent.toString(), true, this);
                ClientExtensions.addMenuItem(soundCaptureModeMenu, Command.SelectSoundCaptureMode, Messages.SoundCaptureMode.Speakers.toString(), true, this);
                ClientExtensions.addMenuItem(soundCaptureModeMenu, Command.SelectSoundCaptureMode, Messages.SoundCaptureMode.HostMicrophone.toString(), true, this);
                ClientExtensions.addMenuItem(soundCaptureModeMenu, Command.SelectSoundCaptureMode, Messages.SoundCaptureMode.AllMicrophones.toString(), true, this);
            }
            JMenu participantsMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelParticipants);
            participantsMenu.addMenuListener(new ParticipantsMenuPopulator());
            JMenu messagesMenu = ClientExtensions.addMenu(menuBar, Command.ControlPanelMessages);
            ClientExtensions.addMenuItem(messagesMenu, Command.ShowChat, null, false, this);
            ClientExtensions.tryPackFrame(this.screenFrame);
        }
    }

    void tryEnsureTrayIcon() {
        block10: {
            if (this.trayIcon == null) {
                try {
                    if (!Extensions.isClassAvailable((String)"java.awt.SystemTray") || !SystemTray.isSupported()) break block10;
                    boolean isOnWindows = Extensions.isOnWindows();
                    Accessible menu = isOnWindows ? new JPopupMenu() : new PopupMenu();
                    ClientExtensions.addMenuItem(menu, Command.ShowChat, null, false, this);
                    int i = 1;
                    while (true) {
                        try {
                            String text = Resources.getString((String)("TrayLink" + i + "Text"));
                            if (Extensions.isNullOrEmpty((String)text)) break;
                            if (ClientExtensions.getMenuItemCount(menu) == 1) {
                                ClientExtensions.addMenuSeparator(menu);
                            }
                            String url = Resources.getString((String)("TrayLink" + i + "Url"));
                            ClientExtensions.addMenuItem(menu, Command.OpenUrl, url, false, this, text);
                        }
                        catch (Throwable ex) {
                            break;
                        }
                        ++i;
                    }
                    if (!this.endPointManager.getSessionType().equals((Object)SessionType.Access)) {
                        ClientExtensions.addMenuSeparator(menu);
                        ClientExtensions.addMenuItem(menu, Command.Exit, null, false, this);
                    }
                    if (isOnWindows) {
                        List<BufferedImage> icons = ClientResources.getDefaultIcons();
                        this.trayIcon = new JTrayIcon(icons.get(0));
                        ((JTrayIcon)this.trayIcon).setJPopupMenu((JPopupMenu)menu);
                    } else {
                        BufferedImage icon = ClientResources.getMacIcon();
                        this.trayIcon = new TrayIcon(icon);
                        ((TrayIcon)this.trayIcon).setPopupMenu((PopupMenu)menu);
                    }
                    SystemTray systemTray = SystemTray.getSystemTray();
                    systemTray.add((TrayIcon)this.trayIcon);
                }
                catch (AWTException ex) {
                    Constants.ExceptionTraceSource.traceException((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void newChatMessage(String text) {
        Messages.ChatMessage chatMessage = new Messages.ChatMessage();
        chatMessage.text = text;
        this.endPointManager.enqueueOutgoingMessage((Object)chatMessage);
    }

    public void messageReady(Object message) {
        if (!(!this.endPointManager.getStatus().isFlagSet(EndPointStatus.FlagInSession) || message instanceof Messages.InputMessage && this.inputSuspended)) {
            this.endPointManager.enqueueOutgoingMessage(message);
        }
    }

    public void threadStarting() {
    }

    public void threadStopped(boolean wasUnexpected) {
        if (wasUnexpected) {
            this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ResetCaptureStateMessage2());
        }
    }

    static /* synthetic */ Messages.SessionConnectionInfo3[] access$402(Client x0, Messages.SessionConnectionInfo3[] x1) {
        x0.sessionConnections = x1;
        return x1;
    }

    static /* synthetic */ CoreRect[] access$802(Client x0, CoreRect[] x1) {
        x0.remoteMonitorVirtualBounds = x1;
        return x1;
    }

    private class ParticipantsMenuPopulator
    extends MenuPopulator {
        private ParticipantsMenuPopulator() {
        }

        protected void populateMenu(JMenu menu) {
            if (Client.this.sessionConnections != null) {
                for (Messages.SessionConnectionInfo3 sci : Client.this.sessionConnections) {
                    JMenu subMenu = ClientExtensions.addMenu(menu, Command.ControlPanelParticipants, Extensions.getParticipantNameText((String)sci.participantName));
                    if (Client.this.endPointManager.getProcessType() != ProcessType.Host) continue;
                    if (!(sci.connectionID.equals(Client.this.currentConnectionID) || Client.this.endPointManager.getSessionType() == SessionType.Access && sci.processType == ProcessType.Guest)) {
                        ClientExtensions.addMenuItem(subMenu, Command.DisconnectParticipant, sci.connectionID.toString(), false, Client.this);
                    }
                    if (Client.this.endPointManager.getSessionType() != SessionType.Meeting) continue;
                    if (sci.attributes.contains(Messages.SessionConnectionAttribute.CAPTURE_SCREEN)) {
                        ClientExtensions.addMenuItem(subMenu, Command.StopParticipantShare, sci.connectionID.toString(), false, Client.this);
                        continue;
                    }
                    ClientExtensions.addMenuItem(subMenu, Command.RequestParticipantShare, sci.connectionID.toString(), false, Client.this);
                }
            }
        }
    }

    private class ZoomMenuPopulator
    extends MenuPopulator {
        private ZoomMenuPopulator() {
        }

        protected void populateMenu(JMenu menu) {
            double[] zoomScales = Constants.StandardZoomScales;
            double zoomScale = Client.this.screenFrame.getScreenPanel().getScreenScale();
            int index = Arrays.binarySearch(zoomScales, zoomScale);
            if (index < 0) {
                int newIndex = -index - 1;
                double[] newZoomScales = new double[zoomScales.length + 1];
                System.arraycopy(zoomScales, 0, newZoomScales, 0, newIndex);
                System.arraycopy(zoomScales, newIndex, newZoomScales, newIndex + 1, zoomScales.length - newIndex);
                newZoomScales[newIndex] = zoomScale;
                zoomScales = newZoomScales;
            }
            for (int i = 0; i < zoomScales.length; ++i) {
                String text = new DecimalFormat("#.##%").format(zoomScales[i]);
                ClientExtensions.addMenuItem(menu, Command.ZoomToScale, Double.toString(zoomScales[i]), true, Client.this, text);
            }
        }
    }

    private class MonitorsMenuPopulator
    extends MenuPopulator {
        private MonitorsMenuPopulator() {
        }

        protected void populateMenu(JMenu menu) {
            ClientExtensions.addMenuItem(menu, Command.SelectMonitor, "-1", true, Client.this, "All");
            if (Client.this.remoteMonitorVirtualBounds != null && Client.this.remoteMonitorVirtualBounds.length > 1) {
                for (int i = 0; i < Client.this.remoteMonitorVirtualBounds.length; ++i) {
                    ClientExtensions.addMenuItem(menu, Command.SelectMonitor, Integer.toString(i), true, Client.this, "Monitor " + Integer.toString(i + 1));
                }
            }
        }
    }

    private class ToolboxMenuPopulator
    extends MenuPopulator {
        private ToolboxMenuPopulator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateMenu(JMenu menu) {
            EndPointManager endPointManager = Client.this.endPointManager;
            synchronized (endPointManager) {
                Client.this.endPointManager.enqueueOutgoingMessage((Object)new Messages.ToolboxMessage());
                Extensions.waitQuietly((Object)Client.this.endPointManager, (long)5000L);
            }
            if (Client.this.toolbox != null) {
                this.addToolboxItemsToMenu(((Client)Client.this).toolbox.items, "", menu);
            }
        }

        private void addToolboxItemsToMenu(Messages.ToolboxItem[] items, String basePath, JMenu menu) {
            for (int i = 0; items != null && i < items.length; ++i) {
                if (items[i].isDirectory.booleanValue()) {
                    JMenu subMenu = ClientExtensions.addMenu(menu, Command.ControlPanelToolbox, items[i].name);
                    this.addToolboxItemsToMenu(items[i].items, items[i].name + "/", subMenu);
                    continue;
                }
                ClientExtensions.addMenuItem(menu, Command.RunTool, basePath + items[i].name, false, Client.this, items[i].name);
            }
        }
    }

    private abstract class MenuPopulator
    implements MenuListener {
        private MenuPopulator() {
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
            this.populateMenu(menu);
            ArrayList<Object> menuItems = new ArrayList<Object>();
            ClientExtensions.populateMenuHierarchy(menu, menuItems);
            Client.this.updateMenuItemState(menuItems);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        protected abstract void populateMenu(JMenu var1);
    }
}

