/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.CoreSize;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.Resources;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SoundException;
import com.elsitech.screenconnect.SoundFormat;
import com.elsitech.screenconnect.client.ClientResources;
import com.elsitech.screenconnect.client.Command;
import com.elsitech.screenconnect.client.ScreenCaptureThumbnail;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.im.InputContext;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientExtensions {
    private ClientExtensions() {
    }

    public static Point toAwt(CorePoint point) {
        return new Point(point.x, point.y);
    }

    public static Rectangle toAwt(CoreRect rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Dimension toAwt(CoreSize dimension) {
        return new Dimension(dimension.width, dimension.height);
    }

    public static CorePoint fromAwt(Point point) {
        return new CorePoint(point.x, point.y);
    }

    public static CoreRect fromAwt(Rectangle rectangle) {
        return new CoreRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static CoreSize fromAwt(Dimension dimension) {
        return new CoreSize(dimension.width, dimension.height);
    }

    public static void notifySystemOfUserActivity() {
        if (Extensions.isOnMac()) {
            ClientExtensions.runtimeExecQuietly("/usr/bin/caffeinate -u -t 1");
        }
    }

    public static void runtimeExecQuietly(String commandLine) {
        try {
            Runtime.getRuntime().exec("/usr/bin/caffeinate -u -t 1");
        }
        catch (Exception ex) {
            Constants.ExceptionTraceSource.traceException((Throwable)ex);
        }
    }

    public static void desktopOpenUriQuietly(String url) {
        if (Extensions.isClassAvailable((String)"java.awt.Desktop") && Desktop.isDesktopSupported()) {
            try {
                URI uri = new URI(url);
                Desktop.getDesktop().browse(uri);
            }
            catch (Throwable e) {
                Constants.ExceptionTraceSource.traceException(e);
            }
        }
    }

    public static Rectangle getDesktopBounds() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = environment.getScreenDevices();
        Rectangle desktopBounds = new Rectangle();
        for (int i = 0; i < devices.length; ++i) {
            Rectangle deviceBounds = devices[i].getDefaultConfiguration().getBounds();
            desktopBounds = desktopBounds.union(deviceBounds);
        }
        return desktopBounds;
    }

    public static void setIconImages(Window window) {
        List<BufferedImage> icons = ClientResources.getDefaultIcons();
        try {
            window.setIconImages(icons);
        }
        catch (NoSuchMethodError ex) {
            window.setIconImage(icons.get(0));
        }
    }

    public static void tryInvokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception ex) {
            Constants.ExceptionTraceSource.traceException((Throwable)ex);
        }
    }

    protected static void populateMenuHierarchy(Object parentMenuOrItem, List<Object> menuItems) {
        block3: {
            block2: {
                menuItems.add(parentMenuOrItem);
                if (!(parentMenuOrItem instanceof JMenu)) break block2;
                int itemCount = ((JMenu)parentMenuOrItem).getItemCount();
                for (int i = 0; i < itemCount; ++i) {
                    ClientExtensions.populateMenuHierarchy(((JMenu)parentMenuOrItem).getItem(i), menuItems);
                }
                break block3;
            }
            if (!(parentMenuOrItem instanceof JComponent)) break block3;
            int componentCount = ((JComponent)parentMenuOrItem).getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                ClientExtensions.populateMenuHierarchy(((JComponent)parentMenuOrItem).getComponent(i), menuItems);
            }
        }
    }

    protected static boolean isCheckable(Object menuItem) {
        return menuItem instanceof JCheckBoxMenuItem || menuItem instanceof MenuItem;
    }

    protected static JMenu addMenu(Object parentMenu, Command command) {
        String text = Resources.getString((String)((Object)((Object)command) + "Title"));
        return ClientExtensions.addMenu(parentMenu, command, text);
    }

    protected static JMenu addMenu(Object parentMenu, Command command, String text) {
        JMenu menu = new JMenu(text);
        menu.setActionCommand(command.toString());
        if (parentMenu instanceof JMenu) {
            ((JMenu)parentMenu).add(menu);
        } else {
            ((JMenuBar)parentMenu).add(menu);
        }
        return menu;
    }

    protected static Object addMenuItem(Object menu, Command command, String commandArgument, boolean checkable, ActionListener actionListener) {
        String text;
        try {
            text = Resources.getString((String)("Command" + (Object)((Object)command) + (commandArgument == null ? "" : commandArgument)));
        }
        catch (MissingResourceException ex) {
            text = Resources.getString((String)("Command" + (Object)((Object)command)));
        }
        return ClientExtensions.addMenuItem(menu, command, commandArgument, checkable, actionListener, text);
    }

    protected static Object addMenuItem(Object menu, Command command, String commandArgument, boolean checkable, ActionListener actionListener, String text) {
        String commandString = command.toString();
        if (!Extensions.isNullOrEmpty((String)commandArgument)) {
            commandString = commandString + ":" + commandArgument;
        }
        if (menu instanceof JComponent) {
            JMenuItem item = checkable ? new JCheckBoxMenuItem(text) : new JMenuItem(text);
            item.setActionCommand(commandString);
            item.addActionListener(actionListener);
            if (menu instanceof JPopupMenu) {
                ((JPopupMenu)menu).add(item);
            } else {
                ((JMenu)menu).add(item);
            }
            return item;
        }
        MenuItem item = new MenuItem(text);
        item.setActionCommand(commandString);
        item.addActionListener(actionListener);
        ((Menu)menu).add(item);
        return item;
    }

    protected static String getCommandString(Object menuOrItem) {
        if (menuOrItem instanceof JMenuItem) {
            return ((JMenuItem)menuOrItem).getModel().getActionCommand();
        }
        if (menuOrItem instanceof MenuItem) {
            return ((MenuItem)menuOrItem).getActionCommand();
        }
        return null;
    }

    protected static Command getCommand(Object menuOrItem) {
        String commandString = ClientExtensions.getCommandString(menuOrItem);
        if (Extensions.isNullOrEmpty((String)commandString)) {
            return Command.None;
        }
        int index = commandString.indexOf(58);
        return Command.valueOf(index == -1 ? commandString : commandString.substring(0, index));
    }

    protected static String getCommandArgument(Object menuOrItem) {
        String commandString = ClientExtensions.getCommandString(menuOrItem);
        if (commandString == null) {
            return null;
        }
        int index = commandString.indexOf(58);
        return index == -1 ? "" : commandString.substring(index + 1);
    }

    protected static int getMenuItemCount(Object menu) {
        if (menu instanceof JPopupMenu) {
            return ((JPopupMenu)menu).getComponentCount();
        }
        if (menu instanceof JMenu) {
            return ((JMenu)menu).getComponentCount();
        }
        return ((Menu)menu).getItemCount();
    }

    protected static void addMenuSeparator(Object menu) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).addSeparator();
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).addSeparator();
        } else {
            ((Menu)menu).addSeparator();
        }
    }

    protected static JMenu getMenuOrItemMenu(Object menuOrItem) {
        return (JMenu)((JPopupMenu)((Component)menuOrItem).getParent()).getInvoker();
    }

    protected static String getMenuOrItemText(Object menuOrItem) {
        if (menuOrItem instanceof JMenuItem) {
            return ((JMenuItem)menuOrItem).getText();
        }
        if (menuOrItem instanceof MenuItem) {
            return ((MenuItem)menuOrItem).getLabel();
        }
        return ((JMenu)menuOrItem).getText();
    }

    protected static void trySetMenuOrItemEnabled(Object menuOrItem, boolean enabled) {
        if (menuOrItem instanceof JMenuItem) {
            ((JMenuItem)menuOrItem).setEnabled(enabled);
        } else if (menuOrItem instanceof MenuItem) {
            ((MenuItem)menuOrItem).setEnabled(enabled);
        } else if (menuOrItem instanceof JMenu) {
            ((JMenu)menuOrItem).setEnabled(enabled);
        }
    }

    protected static boolean isMenuItemEnabled(Object menuItem) {
        if (menuItem instanceof JMenuItem) {
            return ((JMenuItem)menuItem).isEnabled();
        }
        if (menuItem instanceof MenuItem) {
            return ((MenuItem)menuItem).isEnabled();
        }
        return false;
    }

    protected static boolean toggleMenuItemChecked(Object menuItem) {
        if (menuItem instanceof JMenuItem) {
            boolean wasChecked = ((JMenuItem)menuItem).isSelected();
            ((JMenuItem)menuItem).setSelected(!wasChecked);
            return !wasChecked;
        }
        return false;
    }

    protected static void setMenuItemChecked(Object menuItem, boolean checked) {
        if (menuItem instanceof JMenuItem) {
            ((JMenuItem)menuItem).setSelected(checked);
        }
    }

    protected static boolean getMenuItemChecked(Object menuItem) {
        return ((JMenuItem)menuItem).isSelected();
    }

    public static void tryPackFrame(Frame frame) {
        try {
            frame.pack();
        }
        catch (Throwable t) {
            Constants.ExceptionTraceSource.traceException(t);
        }
    }

    public static void keyPressAndRelease(Robot robot, int keyCode) {
        robot.keyPress(keyCode);
        robot.keyRelease(keyCode);
    }

    public static void keyPressOrRelease(Robot robot, int keyCode, boolean pressOrRelease) {
        if (pressOrRelease) {
            robot.keyPress(keyCode);
        } else {
            robot.keyRelease(keyCode);
        }
    }

    public static void setAllOpaque(Container c, boolean opaque) {
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(opaque);
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component comp = c.getComponent(i);
                if (!(comp instanceof Container)) continue;
                ClientExtensions.setAllOpaque((Container)comp, opaque);
            }
        }
    }

    public static int tryGetLocksActive() {
        try {
            return (Toolkit.getDefaultToolkit().getLockingKeyState(20) ? 1 : 0) | (Toolkit.getDefaultToolkit().getLockingKeyState(144) ? 2 : 0) | (Toolkit.getDefaultToolkit().getLockingKeyState(145) ? 4 : 0);
        }
        catch (UnsupportedOperationException ex) {
            return 0x8000000;
        }
    }

    public static boolean isModifierKey(int javaKeyCode) {
        switch (javaKeyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 524: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLockKey(int javaKeyCode) {
        switch (javaKeyCode) {
            case 20: 
            case 144: 
            case 145: {
                return true;
            }
        }
        return false;
    }

    public static String getKeyboardLayoutID() {
        Locale locale = InputContext.getInstance().getLocale();
        return locale.getLanguage() + '-' + locale.getCountry() + '-' + locale.getVariant();
    }

    public static Integer getJavaMouseButton(int windowsMouseButton) {
        switch (windowsMouseButton) {
            case 0x100000: {
                return 16;
            }
            case 0x400000: {
                return 8;
            }
            case 0x200000: {
                return 4;
            }
        }
        return windowsMouseButton;
    }

    public static int getWindowsMouseButton(int javaMouseButton) {
        switch (javaMouseButton) {
            case 1: 
            case 16: 
            case 1024: {
                return 0x100000;
            }
            case 2: 
            case 8: 
            case 2048: {
                return 0x400000;
            }
            case 3: 
            case 4: 
            case 4096: {
                return 0x200000;
            }
        }
        return javaMouseButton;
    }

    public static int getModifiersDown(KeyEvent e, boolean isOnMac) {
        int modifiersDown = 0;
        if (e.isShiftDown()) {
            modifiersDown |= 1;
        }
        if (e.isControlDown()) {
            modifiersDown |= 2;
        }
        if (e.isAltDown()) {
            modifiersDown = isOnMac ? (modifiersDown |= 8) : (modifiersDown |= 4);
        }
        if (e.isMetaDown()) {
            modifiersDown = isOnMac ? (modifiersDown |= 4) : (modifiersDown |= 8);
        }
        return modifiersDown;
    }

    public static int getJavaModifierKeys(int modifierKeys, boolean isOnMac) {
        int javaModifierKeys = 0;
        if ((modifierKeys & 1) != 0) {
            javaModifierKeys |= 0x40;
        }
        if ((modifierKeys & 2) != 0) {
            javaModifierKeys |= 0x80;
        }
        if ((modifierKeys & 4) != 0) {
            javaModifierKeys = isOnMac ? (javaModifierKeys |= 0x100) : (javaModifierKeys |= 0x200);
        }
        if ((modifierKeys & 8) != 0) {
            javaModifierKeys = isOnMac ? (javaModifierKeys |= 0x200) : (javaModifierKeys |= 0x100);
        }
        return javaModifierKeys;
    }

    public static int translateKeyCodeToMac(int javaKeyCode) {
        switch (javaKeyCode) {
            case 18: {
                return 157;
            }
            case 524: {
                return 18;
            }
        }
        return javaKeyCode;
    }

    public static int translateKeyCodeFromMac(int javaKeyCode) {
        switch (javaKeyCode) {
            case 157: {
                return 18;
            }
            case 18: {
                return 524;
            }
        }
        return javaKeyCode;
    }

    public static int getJavaKeyCode(int windowsKeyCode) {
        switch (windowsKeyCode) {
            case 13: {
                return 10;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 16: 
            case 160: 
            case 161: {
                return 16;
            }
            case 17: 
            case 162: 
            case 163: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 27: {
                return 27;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 37: {
                return 37;
            }
            case 38: {
                return 38;
            }
            case 39: {
                return 39;
            }
            case 40: {
                return 40;
            }
            case 188: {
                return 44;
            }
            case 189: {
                return 45;
            }
            case 190: {
                return 46;
            }
            case 191: {
                return 47;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return windowsKeyCode;
            }
            case 186: {
                return 59;
            }
            case 187: {
                return 61;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return windowsKeyCode;
            }
            case 219: {
                return 91;
            }
            case 220: {
                return 92;
            }
            case 221: {
                return 93;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return windowsKeyCode;
            }
            case 106: {
                return 106;
            }
            case 107: {
                return 107;
            }
            case 108: {
                return 108;
            }
            case 109: {
                return 109;
            }
            case 110: {
                return 110;
            }
            case 111: {
                return 111;
            }
            case 46: {
                return 127;
            }
            case 144: {
                return 144;
            }
            case 145: {
                return 145;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return windowsKeyCode;
            }
            case 124: {
                return 61440;
            }
            case 125: {
                return 61441;
            }
            case 126: {
                return 61442;
            }
            case 127: {
                return 61443;
            }
            case 128: {
                return 61444;
            }
            case 129: {
                return 61445;
            }
            case 130: {
                return 61446;
            }
            case 131: {
                return 61447;
            }
            case 132: {
                return 61448;
            }
            case 133: {
                return 61449;
            }
            case 134: {
                return 61450;
            }
            case 135: {
                return 61451;
            }
            case 44: {
                return 154;
            }
            case 45: {
                return 155;
            }
            case 47: {
                return 156;
            }
            case 192: {
                return 192;
            }
            case 222: {
                return 222;
            }
            case 93: {
                return 525;
            }
            case 91: 
            case 92: {
                return 524;
            }
        }
        return windowsKeyCode;
    }

    public static int getWindowsKeyCode(int javaKeyCode) {
        switch (javaKeyCode) {
            case 10: {
                return 13;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 3: {
                return javaKeyCode;
            }
            case 12: {
                return javaKeyCode;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 27: {
                return 27;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 37: {
                return 37;
            }
            case 38: {
                return 38;
            }
            case 39: {
                return 39;
            }
            case 40: {
                return 40;
            }
            case 44: {
                return 188;
            }
            case 45: {
                return 189;
            }
            case 46: {
                return 190;
            }
            case 47: {
                return 191;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return javaKeyCode;
            }
            case 59: {
                return 191;
            }
            case 61: {
                return 187;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return javaKeyCode;
            }
            case 91: {
                return 219;
            }
            case 92: {
                return 220;
            }
            case 93: {
                return 221;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return javaKeyCode;
            }
            case 106: {
                return 106;
            }
            case 107: {
                return 107;
            }
            case 108: {
                return 108;
            }
            case 109: {
                return 109;
            }
            case 110: {
                return 110;
            }
            case 111: {
                return 111;
            }
            case 127: {
                return 46;
            }
            case 144: {
                return 144;
            }
            case 145: {
                return 145;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return javaKeyCode;
            }
            case 61440: {
                return 124;
            }
            case 61441: {
                return 125;
            }
            case 61442: {
                return 126;
            }
            case 61443: {
                return 127;
            }
            case 61444: {
                return 128;
            }
            case 61445: {
                return 129;
            }
            case 61446: {
                return 130;
            }
            case 61447: {
                return 131;
            }
            case 61448: {
                return 132;
            }
            case 61449: {
                return 133;
            }
            case 61450: {
                return 134;
            }
            case 61451: {
                return 135;
            }
            case 154: {
                return 44;
            }
            case 155: {
                return 45;
            }
            case 156: {
                return 47;
            }
            case 157: {
                return 18;
            }
            case 192: {
                return 192;
            }
            case 222: {
                return 222;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                return javaKeyCode;
            }
            case 128: {
                return 186;
            }
            case 129: {
                return 222;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 160: 
            case 161: 
            case 162: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: {
                return javaKeyCode;
            }
            case 524: {
                return 91;
            }
            case 525: {
                return 93;
            }
        }
        return javaKeyCode;
    }

    public static long getTotalSystemMemorySize() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
    }

    public static long getAvailableSystemMemorySize() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreePhysicalMemorySize();
    }

    public static long getIdleSeconds() {
        return -1L;
    }

    public static String getOperatingSystemName() {
        return ManagementFactory.getOperatingSystemMXBean().getName();
    }

    public static Messages.Version getOperatingSystemVersion() {
        return new Messages.Version(ManagementFactory.getOperatingSystemMXBean().getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessorName() {
        File cpuInfoFile = new File("/proc/cpuinfo");
        if (cpuInfoFile.exists()) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(cpuInfoFile);
                Pattern pattern = Pattern.compile("model[ _]name\\s+:\\s+((\\S+ )*\\S+)", 2);
                while (scanner.hasNextLine()) {
                    Matcher matcher = pattern.matcher(scanner.nextLine());
                    if (!matcher.lookingAt()) continue;
                    String string = matcher.group(1);
                    return string;
                }
            }
            catch (FileNotFoundException e) {
                Constants.ExceptionTraceSource.traceException((Throwable)e);
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return System.getenv("PROCESSOR_IDENTIFIER");
    }

    public static int getProcessorVirtualCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static byte[] tryGetWakeToken(InetAddress interfaceIP) {
        byte[] macAddress = ClientExtensions.tryGetMacAddressForIP(interfaceIP);
        if (macAddress == null) {
            return null;
        }
        int ffCount = 6;
        int macRepeatCount = 16;
        byte[] wakeToken = new byte[ffCount + macAddress.length * macRepeatCount];
        Arrays.fill(wakeToken, 0, ffCount, (byte)-1);
        for (int i = ffCount; i < wakeToken.length; i += macAddress.length) {
            System.arraycopy(macAddress, 0, wakeToken, i, macAddress.length);
        }
        return wakeToken;
    }

    public static byte[] tryGetMacAddressForIP(InetAddress ipAddress) {
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (hardwareAddress == null || hardwareAddress.length != 6 || !Collections.list(networkInterface.getInetAddresses()).contains(ipAddress)) continue;
                return networkInterface.getHardwareAddress();
            }
        }
        catch (Throwable e) {
            Constants.ExceptionTraceSource.traceException(e);
        }
        return null;
    }

    public static ScreenCaptureThumbnail captureScreen(float maxScale, int maxPixelCount, int maxWidth, int maxHeight) throws Exception {
        Rectangle virtualScreenBounds = ClientExtensions.getDesktopBounds();
        float aspectRatio = (float)virtualScreenBounds.width / (float)virtualScreenBounds.height;
        float pixelCountBasedHeight = (float)Math.sqrt((float)maxPixelCount / aspectRatio);
        float pixelCountBasedScale = pixelCountBasedHeight / (float)virtualScreenBounds.height;
        float widthBasedScale = (float)maxWidth / (float)virtualScreenBounds.width;
        float heightBasedScale = (float)maxHeight / (float)virtualScreenBounds.height;
        float scale = Collections.min(Arrays.asList(Float.valueOf(maxScale), Float.valueOf(pixelCountBasedScale), Float.valueOf(widthBasedScale), Float.valueOf(heightBasedScale))).floatValue();
        BufferedImage unscaledScreencapImage = new Robot().createScreenCapture(virtualScreenBounds);
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scale, scale);
        AffineTransformOp smoothScaleOp = new AffineTransformOp(scaleTransform, 2);
        AffineTransformOp hackScaleOp = new AffineTransformOp(scaleTransform, 1);
        BufferedImage scaledScreencapImage = smoothScaleOp.filter(unscaledScreencapImage, hackScaleOp.filter(unscaledScreencapImage, null));
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledScreencapImage, "jpg", byteArrayStream);
        ScreenCaptureThumbnail screencap = new ScreenCaptureThumbnail();
        screencap.contentType = "image/jpeg";
        screencap.content = byteArrayStream.toByteArray();
        screencap.contentHash = MessageDigest.getInstance("MD5").digest(screencap.content);
        return screencap;
    }

    public static String getLoggedOnUserDomain() {
        return System.getenv("USERDOMAIN");
    }

    public static String getLoggedOnUserName() {
        return System.getProperty("user.name");
    }

    public static String getMachineDomain() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            Matcher domainMatcher = Pattern.compile(localAddress.getHostName() + "\\.*(.*)").matcher(localAddress.getCanonicalHostName());
            domainMatcher.find();
            return domainMatcher.group(1);
        }
        catch (Exception e) {
            Constants.ExceptionTraceSource.traceException((Throwable)e);
            return null;
        }
    }

    public static CoreRect transformRect(AffineTransform transform, CoreRect originalRect) {
        Point2D topLeftLocation = transform.transform(new Point2D.Double(originalRect.x, originalRect.y), null);
        Point2D bottomRightLocation = transform.transform(new Point2D.Double(originalRect.x + originalRect.width, originalRect.y + originalRect.height), null);
        return new CoreRect((int)Math.floor(topLeftLocation.getX()), (int)Math.floor(topLeftLocation.getY()), (int)Math.ceil(bottomRightLocation.getX() - topLeftLocation.getX()), (int)Math.ceil(bottomRightLocation.getY() - topLeftLocation.getY()));
    }

    public static String getDeviceIDFromMixerInfo(Mixer.Info mixerInfo) {
        return mixerInfo.toString();
    }

    public static Mixer.Info getMixerInfoFromDeviceID(String deviceID) throws SoundException.InvalidDeviceIDException {
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            if (!Extensions.equals((Object)ClientExtensions.getDeviceIDFromMixerInfo(mixerInfo), (Object)deviceID)) continue;
            return mixerInfo;
        }
        throw new SoundException.InvalidDeviceIDException();
    }

    public static AudioFormat convertSoundFormat(SoundFormat format) {
        return new AudioFormat(format.getSamplesPerSecond(), format.getBitsPerSample(), format.getNumChannels(), format.isSigned(), false);
    }

    public static boolean isRenderOrCaptureDevice(Mixer.Info mixerInfo, boolean renderOrCapture) {
        Mixer mixer = AudioSystem.getMixer(mixerInfo);
        Line.Info[] lineInfos = renderOrCapture ? mixer.getSourceLineInfo() : mixer.getTargetLineInfo();
        Class lineClass = renderOrCapture ? SourceDataLine.class : TargetDataLine.class;
        for (Line.Info lineInfo : lineInfos) {
            if (!lineClass.isAssignableFrom(lineInfo.getLineClass())) continue;
            return true;
        }
        return false;
    }

    public static List<Services.SoundDeviceInfo> getSoundDeviceInfos(boolean renderOrCapture) {
        ArrayList<Services.SoundDeviceInfo> deviceInfos = new ArrayList<Services.SoundDeviceInfo>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            if (!ClientExtensions.isRenderOrCaptureDevice(mixerInfo, renderOrCapture)) continue;
            deviceInfos.add(new Services.SoundDeviceInfo(ClientExtensions.getDeviceIDFromMixerInfo(mixerInfo), mixerInfo.getName()));
        }
        return deviceInfos;
    }

    public static String tryGetDefaultSoundDeviceID(boolean renderOrCapture) {
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (mixerInfos.length == 0) {
            return null;
        }
        Mixer.Info mixerInfo = AudioSystem.getMixer(null).getMixerInfo();
        int i = -1;
        while (i < mixerInfos.length) {
            if (ClientExtensions.isRenderOrCaptureDevice(mixerInfo, renderOrCapture)) {
                return ClientExtensions.getDeviceIDFromMixerInfo(mixerInfo);
            }
            mixerInfo = mixerInfos[++i];
        }
        return null;
    }
}

