/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.FileUserInterfaceManager;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

public class ClientFileUserInterfaceManager
implements FileUserInterfaceManager {
    private File baseDirectory;
    private boolean hasActivated;

    public ClientFileUserInterfaceManager(File baseDirectory) {
        this.baseDirectory = (File)Extensions.assertArgumentNonNull((Object)baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void refreshExplorerWindow() {
        this.activateExplorerWindow();
    }

    public void activateExplorerWindow() {
        if (this.hasActivated && !Extensions.isOnWindows()) {
            return;
        }
        ClientExtensions.desktopOpenUriQuietly(this.baseDirectory.toURI().toString());
        this.hasActivated = true;
    }

    public void runFile(String filePath) {
        try {
            Desktop.getDesktop().open(new File(filePath));
        }
        catch (IOException ex) {
            Constants.ExceptionTraceSource.traceException((Throwable)ex);
        }
    }
}

