/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.InputReceiver;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.AWTError;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.util.HashMap;
import java.util.Map;

public class ClientInputReceiver
extends InputReceiver {
    private Point mouseTranslation;
    private Robot primaryScreenRobot;
    private String keyboardLayoutID;
    private long lastMouseMoveTimeMillis;
    private Point lastMouseMovePosition;
    private long lastNotifySystemActivityMillis;
    private int modifiersDown;
    private HashMap<Integer, Integer> modifierToJavaKeyMap;

    public ClientInputReceiver() {
        try {
            this.primaryScreenRobot = new Robot();
        }
        catch (AWTException e) {
            throw new AWTError("Cannot load screen robot");
        }
        this.mouseTranslation = ClientExtensions.getDesktopBounds().getLocation();
        this.modifierToJavaKeyMap = new HashMap();
        this.modifierToJavaKeyMap.put(1, 16);
        this.modifierToJavaKeyMap.put(4, 18);
        this.modifierToJavaKeyMap.put(2, 17);
        this.modifierToJavaKeyMap.put(8, 524);
    }

    public void processMessage(Messages.InputMessage message) {
        super.processMessage(message);
        if (System.currentTimeMillis() - this.lastNotifySystemActivityMillis > 60000L) {
            ClientExtensions.notifySystemOfUserActivity();
            this.lastNotifySystemActivityMillis = System.currentTimeMillis();
        }
    }

    protected void processKeyboardMessage(Messages.KeyboardMessage2 keyboardMessage) {
        if (this.keyboardLayoutID == null) {
            this.keyboardLayoutID = ClientExtensions.getKeyboardLayoutID();
        }
        int javaKeyCode = -1;
        if (keyboardMessage.javaKeyCode != 0) {
            javaKeyCode = keyboardMessage.javaKeyCode;
        }
        if (javaKeyCode == -1) {
            javaKeyCode = ClientExtensions.getJavaKeyCode(keyboardMessage.windowsKeyCode);
        }
        if (Extensions.isOnMac()) {
            javaKeyCode = ClientExtensions.translateKeyCodeToMac(javaKeyCode);
        }
        for (Map.Entry<Integer, Integer> entry : this.modifierToJavaKeyMap.entrySet()) {
            if ((keyboardMessage.modifiersDown & entry.getKey()) == (this.modifiersDown & entry.getKey())) continue;
            ClientExtensions.keyPressOrRelease(this.primaryScreenRobot, entry.getValue(), (this.modifiersDown & entry.getKey()) == 0);
        }
        this.modifiersDown = keyboardMessage.modifiersDown;
        int keyCodeToSend = javaKeyCode;
        try {
            if (keyCodeToSend != -1) {
                ClientExtensions.keyPressOrRelease(this.primaryScreenRobot, keyCodeToSend, keyboardMessage.upOrDown == false);
            }
        }
        catch (Exception ex) {
            Constants.ExceptionTraceSource.traceException((Throwable)ex);
        }
    }

    protected void processMouseMessage(Messages.MouseMessage mouseMessage) {
        Point position = ClientExtensions.toAwt(mouseMessage.position);
        position.translate(this.mouseTranslation.x, this.mouseTranslation.y);
        if (!position.equals(this.lastMouseMovePosition) || System.currentTimeMillis() - this.lastMouseMoveTimeMillis > 1000L) {
            this.primaryScreenRobot.mouseMove(position.x, position.y);
            this.lastMouseMovePosition = position;
            this.lastMouseMoveTimeMillis = System.currentTimeMillis();
        }
        if (mouseMessage instanceof Messages.MouseButtonMessage) {
            int javaMouseButton = ClientExtensions.getJavaMouseButton(((Messages.MouseButtonMessage)mouseMessage).button);
            if (((Messages.MouseButtonMessage)mouseMessage).upOrDown.booleanValue()) {
                this.primaryScreenRobot.mouseRelease(javaMouseButton);
            } else {
                this.primaryScreenRobot.mousePress(javaMouseButton);
            }
        } else if (mouseMessage instanceof Messages.MouseWheelMessage) {
            int wheelAmount = ((Messages.MouseWheelMessage)mouseMessage).delta / -120;
            this.primaryScreenRobot.mouseWheel(wheelAmount);
        }
    }
}

