/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.IncrementalScreenCapturer;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.MonitorManager;
import com.elsitech.screenconnect.RawBitmapData;
import com.elsitech.screenconnect.WaitChecker;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@CaptureStateDependent
public class ClientScreenCapturer
extends IncrementalScreenCapturer {
    public ClientScreenCapturer(MessagePreparerListener messagePreparerListener, WaitChecker waitChecker) {
        super(messagePreparerListener, waitChecker, 50, 250, 3);
    }

    protected MonitorManager[] createMonitorManagers() throws Throwable {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = environment.getScreenDevices();
        MonitorManager[] screenManagers = new MonitorManager[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            screenManagers[i] = new AwtScreenManager(devices[i]);
        }
        return screenManagers;
    }

    private static class AwtScreenManager
    implements MonitorManager {
        private Object robotPeer;
        private List<PixelCapturer> capturers = new ArrayList<PixelCapturer>();
        private Point translateVector;
        private RawBitmapData captureData;
        private CoreRect bounds;
        private int[] rgbPixelData = null;

        public AwtScreenManager(GraphicsDevice device) throws Exception {
            Robot robot = new Robot(device);
            this.robotPeer = Extensions.getFieldValue((Object)robot, (String)"peer");
            Extensions.findMethods(this.robotPeer.getClass(), (boolean)true, (boolean)false, (Extensions.MethodSearchSpecifier[])new Extensions.MethodSearchSpecifier[]{new Extensions.MethodSearchSpecifier(1, "nativeGetScreenPixels", new Class[0]){

                public void methodFound(Method method) {
                    AwtScreenManager.this.capturers.add(new PixelCapturer(method));
                }
            }, new Extensions.MethodSearchSpecifier(1, "getRGBPixels", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class}){

                public void methodFound(Method method) {
                    AwtScreenManager.this.capturers.add(new PixelCapturer(method));
                }
            }, new Extensions.MethodSearchSpecifier(1, "getRGBPixelsImpl", new Class[0]){

                public void methodFound(Method method) {
                    try {
                        final Object x11GraphicsConfig = Extensions.getFieldValue((Object)AwtScreenManager.this.robotPeer, (String)"xgc");
                        AwtScreenManager.this.capturers.add(new PixelCapturer(method){

                            protected Object[] getArgs(Rectangle translatedBounds) {
                                Object[] superArgs = super.getArgs(translatedBounds);
                                Object[] args = new Object[superArgs.length + 1];
                                args[0] = x11GraphicsConfig;
                                System.arraycopy(superArgs, 0, args, 1, superArgs.length);
                                return args;
                            }
                        });
                    }
                    catch (NoSuchFieldException e) {
                        Constants.ExceptionTraceSource.traceException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        Constants.ExceptionTraceSource.traceException((Throwable)e);
                    }
                }
            }, new Extensions.MethodSearchSpecifier(2, "getRGBPixels", new Class[]{Rectangle.class}){

                public void methodFound(Method method) {
                    AwtScreenManager.this.capturers.add(new PixelCapturer(method){

                        public void populateRGBPixelData(Rectangle translatedBounds) throws Exception {
                            AwtScreenManager.access$002(AwtScreenManager.this, (int[])this.method.invoke(AwtScreenManager.this.robotPeer, translatedBounds));
                        }
                    });
                }
            }});
            try {
                this.translateVector = (Point)Extensions.getFieldValue((Object)robot, (String)"gdLoc");
            }
            catch (Throwable ex) {
                this.translateVector = new Point();
            }
            this.bounds = ClientExtensions.fromAwt(device.getDefaultConfiguration().getBounds());
        }

        public BitmapData acquireBitmapData(CoreRect bounds) {
            return this.captureData.crop(bounds);
        }

        public void releaseBitmapData(BitmapData bitmapData) {
        }

        public CoreRect captureMonitor(CoreRect optionalCropScreenBounds) throws Throwable {
            Rectangle cropScreenBounds = optionalCropScreenBounds == null ? new Rectangle(0, 0, this.bounds.width, this.bounds.height) : ClientExtensions.toAwt(optionalCropScreenBounds);
            Rectangle translatedBounds = new Rectangle(cropScreenBounds);
            translatedBounds.translate(this.translateVector.x, this.translateVector.y);
            Iterator<PixelCapturer> capturerIterator = this.capturers.iterator();
            while (true) {
                try {
                    capturerIterator.next().populateRGBPixelData(translatedBounds);
                }
                catch (Exception e) {
                    if (capturerIterator.hasNext()) continue;
                    throw e;
                    if (capturerIterator.hasNext()) continue;
                }
                break;
            }
            this.captureData = new RawBitmapData(cropScreenBounds.x, cropScreenBounds.y, cropScreenBounds.width, cropScreenBounds.height, this.rgbPixelData, 0, cropScreenBounds.width);
            return this.bounds;
        }

        public void close() throws IOException {
        }

        static /* synthetic */ int[] access$002(AwtScreenManager x0, int[] x1) {
            x0.rgbPixelData = x1;
            return x1;
        }

        private class PixelCapturer {
            protected Method method;

            public PixelCapturer(Method method) {
                this.method = method;
            }

            public void populateRGBPixelData(Rectangle translatedBounds) throws Exception {
                int numPixels = translatedBounds.height * translatedBounds.width;
                if (AwtScreenManager.this.rgbPixelData == null || AwtScreenManager.this.rgbPixelData.length < numPixels) {
                    AwtScreenManager.access$002(AwtScreenManager.this, new int[numPixels]);
                }
                this.method.invoke(AwtScreenManager.this.robotPeer, this.getArgs(translatedBounds));
            }

            protected Object[] getArgs(Rectangle translatedBounds) {
                return new Object[]{translatedBounds.x, translatedBounds.y, translatedBounds.width, translatedBounds.height, AwtScreenManager.this.rgbPixelData};
            }
        }
    }
}

