/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SoundCapturer;
import com.elsitech.screenconnect.SoundFormat;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CaptureStateDependent
public class ClientSoundCapturer
extends SoundCapturer {
    public ClientSoundCapturer(MessagePreparerListener messagePreparerListener, SoundCapturer.Listener listener) {
        super(messagePreparerListener, listener);
    }

    public List<Services.SoundDeviceInfo> getDevices() {
        return ClientExtensions.getSoundDeviceInfos(false);
    }

    public String tryGetDefaultDeviceID() {
        return ClientExtensions.tryGetDefaultSoundDeviceID(false);
    }

    protected SoundCapturer.SoundStream openStream(String deviceID, boolean isBigEndian) throws Exception {
        final TargetDataLine line = (TargetDataLine)AudioSystem.getMixer(ClientExtensions.getMixerInfoFromDeviceID(deviceID)).getLine(new DataLine.Info(TargetDataLine.class, ClientExtensions.convertSoundFormat(SoundFormat.DEFAULT_CAPTURE_FORMAT)));
        line.open();
        line.start();
        return new SoundCapturer.SoundStream(){

            public int read(ByteArraySegment buffer) {
                return line.read(buffer.array, buffer.offset, buffer.count);
            }

            public void close() throws IOException {
                line.close();
            }
        };
    }
}

