/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.ByteArraySegment;
import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Services;
import com.elsitech.screenconnect.SoundException;
import com.elsitech.screenconnect.SoundFormat;
import com.elsitech.screenconnect.SoundRenderer;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CaptureStateDependent
public class ClientSoundRenderer
extends SoundRenderer {
    public ClientSoundRenderer(SoundRenderer.Listener listener) {
        super(listener);
    }

    public List<Services.SoundDeviceInfo> getDevices() {
        return ClientExtensions.getSoundDeviceInfos(true);
    }

    public String tryGetDefaultDeviceID() {
        return ClientExtensions.tryGetDefaultSoundDeviceID(true);
    }

    protected Boolean doesDeviceRenderSoundAloud(String deviceID) throws SoundException.InvalidDeviceIDException {
        Boolean superResult = super.doesDeviceRenderSoundAloud(deviceID);
        if (superResult != null) {
            return superResult;
        }
        Mixer.Info mixerInfo = ClientExtensions.getMixerInfoFromDeviceID(deviceID);
        for (Line.Info lineInfo : AudioSystem.getMixer(mixerInfo).getTargetLineInfo()) {
            if (!Port.Info.HEADPHONE.matches(lineInfo)) continue;
            return false;
        }
        return SoundRenderer.doesDeviceNameIndicateAloudRendering((String)mixerInfo.getName());
    }

    protected SoundRenderer.LineRenderer createLineRenderer(String deviceID) throws SoundException.InvalidDeviceIDException {
        return new ClientSoundLineRenderer(AudioSystem.getMixer(ClientExtensions.getMixerInfoFromDeviceID(deviceID)));
    }

    public static class ClientSoundLineRenderer
    implements SoundRenderer.LineRenderer {
        private SourceDataLine sourceDataLine;

        public ClientSoundLineRenderer(Mixer mixer) {
            try {
                AudioFormat format = ClientExtensions.convertSoundFormat(SoundFormat.DEFAULT_RENDER_FORMAT);
                this.sourceDataLine = (SourceDataLine)mixer.getLine(new DataLine.Info(SourceDataLine.class, format, SoundFormat.DEFAULT_RENDER_FORMAT.getNumBytesForMilliseconds(2000)));
                this.sourceDataLine.open(format, 22000);
            }
            catch (LineUnavailableException e) {
                Constants.ExceptionTraceSource.traceException((Throwable)e);
            }
        }

        public void start() {
            this.sourceDataLine.start();
        }

        public void stop() {
            this.sourceDataLine.stop();
            this.sourceDataLine.flush();
        }

        public void write(ByteArraySegment data) {
            this.sourceDataLine.write(data.array, data.offset, data.count);
        }

        public long getFramesPlayed() {
            return this.sourceDataLine.getLongFramePosition();
        }

        public void setVolume(float newVolume) {
            float volumeInDecibels = (float)(20.0 * Math.log10(newVolume));
            ((FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN)).setValue(volumeInDecibels);
        }

        public void close() {
            this.sourceDataLine.close();
        }
    }
}

