/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.FileData;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.VirtualFileSender;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipboardCapturer
extends ThreadRunner {
    private static final Object FINGERPRINT_INITIAL = new Object();
    private MessagePreparerListener messagePreparerListener;
    private VirtualFileSender virtualFileSender;
    private Clipboard clipboard;
    private Object latestFingerprint;

    private static <V> V handleClipboardContents(Transferable clipboardContents, ClipboardContentsHandler<V> handler) {
        try {
            if (clipboardContents.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return handler.handleFiles((List)clipboardContents.getTransferData(DataFlavor.javaFileListFlavor));
            }
            if (clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return handler.handleString((String)clipboardContents.getTransferData(DataFlavor.stringFlavor));
            }
        }
        catch (UnsupportedFlavorException e) {
            Constants.ExceptionTraceSource.traceException((Throwable)e);
        }
        catch (IOException e) {
            Constants.ExceptionTraceSource.traceException((Throwable)e);
        }
        return null;
    }

    private static Object calculateFingerprint(Transferable transferable) {
        return ClipboardCapturer.handleClipboardContents(transferable, new ClipboardContentsHandler<Object>(){

            @Override
            public Object handleString(String clipboardString) {
                return clipboardString == null ? null : Integer.valueOf(clipboardString.hashCode());
            }

            @Override
            public Object handleFiles(List<File> clipboardFiles) {
                if (clipboardFiles == null) {
                    return null;
                }
                long hashCode = 1L;
                for (File file : clipboardFiles) {
                    hashCode = 31L * hashCode + this.getFingerprint(file);
                }
                return hashCode;
            }

            private long getFingerprint(File file) {
                if (file == null) {
                    return 0L;
                }
                return (long)file.getAbsolutePath().hashCode() + file.lastModified();
            }
        });
    }

    public ClipboardCapturer(MessagePreparerListener messagePreparerListener, VirtualFileSender virtualFileSender) {
        super(5, false);
        this.messagePreparerListener = (MessagePreparerListener)Extensions.assertArgumentNonNull((Object)messagePreparerListener);
        this.virtualFileSender = (VirtualFileSender)Extensions.assertArgumentNonNull((Object)virtualFileSender);
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.latestFingerprint = FINGERPRINT_INITIAL;
    }

    public void processMessage(Messages.ClipboardTextMessage clipboardTextMessage) {
        this.setClipboardContents(new StringSelection(clipboardTextMessage.text));
    }

    public void processMessage(Messages.ClipboardFilesMessage clipboardFilesMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Throwable {
        while (!this.isStopping()) {
            this.waitUnlessSignaled(400L);
            boolean fingerprintChanged = false;
            Transferable clipboardContents = null;
            Object object = this.syncLock;
            synchronized (object) {
                clipboardContents = this.getClipboardContents();
                Object fingerprint = ClipboardCapturer.calculateFingerprint(clipboardContents);
                fingerprintChanged = !Extensions.equals((Object)this.latestFingerprint, (Object)fingerprint) && this.latestFingerprint != FINGERPRINT_INITIAL;
                this.latestFingerprint = fingerprint;
            }
            if (!fingerprintChanged) continue;
            this.sendClipboardContents(clipboardContents);
        }
    }

    private Transferable getClipboardContents() {
        Transferable clipboardContents = null;
        long startTime = System.currentTimeMillis();
        while (clipboardContents == null && System.currentTimeMillis() - startTime < 5000L) {
            try {
                clipboardContents = this.clipboard.getContents(null);
            }
            catch (IllegalStateException e) {
                Extensions.sleepQuietly((long)100L);
            }
        }
        return clipboardContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClipboardContents(Transferable clipboardContents) {
        try {
            Object object = this.syncLock;
            synchronized (object) {
                this.clipboard.setContents(clipboardContents, null);
                this.latestFingerprint = ClipboardCapturer.calculateFingerprint(clipboardContents);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendClipboardContents(Transferable clipboardContents) {
        ClipboardCapturer.handleClipboardContents(clipboardContents, new ClipboardContentsHandler<Void>(){

            @Override
            public Void handleString(String clipboardString) {
                Messages.ClipboardTextMessage clipboardTextMessage = new Messages.ClipboardTextMessage();
                clipboardTextMessage.text = clipboardString;
                ClipboardCapturer.this.messagePreparerListener.messageReady((Object)clipboardTextMessage);
                return null;
            }

            @Override
            public Void handleFiles(List<File> clipboardFiles) {
                Messages.ClipboardFilesMessage clipboardFilesMessage = new Messages.ClipboardFilesMessage();
                clipboardFilesMessage.files = ClipboardCapturer.this.virtualFileSender.registerVirtualFiles(FileData.getFileDatas((File[])clipboardFiles.toArray(new File[clipboardFiles.size()])), null);
                if (clipboardFilesMessage.files.length > 0) {
                    ClipboardCapturer.this.messagePreparerListener.messageReady((Object)clipboardFilesMessage);
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClipboardContentsHandler<V> {
        public V handleString(String var1);

        public V handleFiles(List<File> var1);
    }
}

