/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.CaptureStateDependent;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.ThreadRunner;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;

@CaptureStateDependent
public class CursorCapturer
extends ThreadRunner {
    private MessagePreparerListener messagePreparerListener;

    public CursorCapturer(MessagePreparerListener messagePreparerListener) {
        super(5, false);
        this.messagePreparerListener = (MessagePreparerListener)Extensions.assertArgumentNonNull((Object)messagePreparerListener);
    }

    protected void run() throws Throwable {
        Point desktopOffset = ClientExtensions.getDesktopBounds().getLocation();
        Point lastCursorPosition = new Point(-1, -1);
        while (!this.isStopping()) {
            this.waitUnlessSignaled(50L);
            PointerInfo pi = MouseInfo.getPointerInfo();
            Point cursorPosition = pi.getLocation();
            cursorPosition.translate(-desktopOffset.x, -desktopOffset.y);
            if (cursorPosition.equals(lastCursorPosition)) continue;
            Messages.CursorMessage cursorMessage = new Messages.CursorMessage();
            cursorMessage.cursorID = 0;
            cursorMessage.position = ClientExtensions.fromAwt(cursorPosition);
            this.messagePreparerListener.messageReady((Object)cursorMessage);
            lastCursorPosition = cursorPosition;
        }
    }
}

