/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.CorePoint;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.MessagePreparerListener;
import com.elsitech.screenconnect.Messages;
import com.elsitech.screenconnect.client.ClientExtensions;
import com.elsitech.screenconnect.client.ViewportTransform;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class InputSender
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private MessagePreparerListener messagePreparerListener;
    private String keyboardLayoutID;

    public InputSender(MessagePreparerListener messagePreparerListener) {
        this.messagePreparerListener = (MessagePreparerListener)Extensions.assertArgumentNonNull((Object)messagePreparerListener);
    }

    public void keyPressed(KeyEvent e) {
        this.sendKeyMessage(e);
    }

    public void keyReleased(KeyEvent e) {
        this.sendKeyMessage(e);
    }

    private void sendKeyMessage(KeyEvent e) {
        if (this.keyboardLayoutID == null) {
            this.keyboardLayoutID = ClientExtensions.getKeyboardLayoutID();
        }
        int javaKeyCode = e.getKeyCode();
        boolean isOnMac = Extensions.isOnMac();
        if (isOnMac) {
            javaKeyCode = ClientExtensions.translateKeyCodeFromMac(javaKeyCode);
        }
        Messages.KeyboardMessage2 message = new Messages.KeyboardMessage2();
        message.upOrDown = e.getID() == 402;
        message.keyboardLayoutID = this.keyboardLayoutID;
        message.hardwareScanCode = 0;
        message.windowsKeyCode = ClientExtensions.getWindowsKeyCode(javaKeyCode);
        message.javaKeyCode = javaKeyCode;
        if (!message.upOrDown.booleanValue()) {
            message.charsProducedOrBuffered = (short)e.getKeyChar() == -1 ? "" : Character.toString(e.getKeyChar());
            message.charProducedCount = message.charsProducedOrBuffered.length();
        }
        message.modifiersDown = ClientExtensions.getModifiersDown(e, isOnMac);
        message.locksActive = ClientExtensions.tryGetLocksActive();
        this.messagePreparerListener.messageReady((Object)message);
    }

    public void mousePressed(MouseEvent e) {
        this.sendMouseButtonMessage(e, false);
    }

    public void mouseReleased(MouseEvent e) {
        this.sendMouseButtonMessage(e, true);
    }

    public void mouseMoved(MouseEvent e) {
        this.sendMouseMoveMessage(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.sendMouseMoveMessage(e);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Messages.MouseWheelMessage message = new Messages.MouseWheelMessage();
        message.delta = e.getWheelRotation() * -120;
        message.position = this.getMousePosition(e);
        this.messagePreparerListener.messageReady((Object)message);
    }

    private void sendMouseMoveMessage(MouseEvent e) {
        Messages.MouseMessage message = new Messages.MouseMessage();
        message.position = this.getMousePosition(e);
        this.messagePreparerListener.messageReady((Object)message);
    }

    private void sendMouseButtonMessage(MouseEvent e, boolean upOrDown) {
        Messages.MouseButtonMessage message = new Messages.MouseButtonMessage();
        message.position = this.getMousePosition(e);
        message.button = ClientExtensions.getWindowsMouseButton(e.getButton());
        message.upOrDown = upOrDown;
        this.messagePreparerListener.messageReady((Object)message);
    }

    private CorePoint getMousePosition(MouseEvent e) {
        Object source = e.getSource();
        Point location = e.getPoint();
        if (source instanceof ViewportTransform) {
            location = ((ViewportTransform)source).transformLocation(location);
        }
        return ClientExtensions.fromAwt(location);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

