/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import java.awt.Frame;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JTrayIcon
extends TrayIcon {
    private JPopupMenu menu;
    private static final JDialog DIALOG = new JDialog((Frame)null);
    private PopupMenuListener popupListener = new TrayPopupListener();
    private MouseListener mouseListener = new TrayMouseAdapter();

    public JTrayIcon(Image image) {
        super(image);
    }

    public final JPopupMenu getJPopupMenu() {
        return this.menu;
    }

    public final void setJPopupMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.popupListener);
            this.removeMouseListener(this.mouseListener);
        }
        if (menu != null) {
            this.menu = menu;
            this.menu.addPopupMenuListener(this.popupListener);
            this.addMouseListener(this.mouseListener);
        }
    }

    static {
        DIALOG.setUndecorated(true);
        DIALOG.setAlwaysOnTop(true);
    }

    private static final class TrayPopupListener
    implements PopupMenuListener {
        private TrayPopupListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            DIALOG.setVisible(false);
        }

        public void popupMenuCanceled(PopupMenuEvent evt) {
            DIALOG.setVisible(false);
        }
    }

    private final class TrayMouseAdapter
    extends MouseAdapter {
        private TrayMouseAdapter() {
        }

        private void showJPopupMenu(MouseEvent evt) {
            if (evt.isPopupTrigger() && JTrayIcon.this.menu != null) {
                DIALOG.setLocation(evt.getX(), evt.getY() - ((JTrayIcon)JTrayIcon.this).menu.getPreferredSize().height);
                DIALOG.setVisible(true);
                JTrayIcon.this.menu.show(DIALOG.getContentPane(), 0, 0);
                DIALOG.toFront();
            }
        }

        public void mousePressed(MouseEvent evt) {
            this.showJPopupMenu(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.showJPopupMenu(evt);
        }

        public void mouseClicked(MouseEvent evt) {
            this.showJPopupMenu(evt);
        }
    }
}

