/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.TraceSource;
import com.elsitech.screenconnect.client.ClientExtensions;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public class KeyMap {
    private static final int[] MappableKeys = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 59, 61, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 192, 222, 224, 225, 226, 227, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 150, 151, 152, 153, 160, 161, 162, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523};
    private Map<Character, Integer> charToKeyCodeWithModifiersMap;
    private boolean isAltGraphValid;
    private boolean initializationStarted;
    private TraceSource trace = Extensions.createTraceSource(this.getClass());

    public KeyMap() {
        this.charToKeyCodeWithModifiersMap = new HashMap<Character, Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitializationStarted() {
        if (this.initializationStarted) {
            return;
        }
        Map<Character, Integer> map = this.charToKeyCodeWithModifiersMap;
        synchronized (map) {
            if (!this.initializationStarted) {
                this.initializationStarted = true;
                final JFrame frame = new JFrame();
                final Timer timer = new Timer(5000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        frame.dispose();
                    }
                });
                frame.addWindowFocusListener(new WindowFocusListener(){

                    public void windowLostFocus(WindowEvent e) {
                    }

                    public void windowGainedFocus(WindowEvent e) {
                        try {
                            int keyCode;
                            Iterator i$;
                            ArrayList<Integer> validMappableKeys;
                            Robot robot;
                            block16: {
                                robot = new Robot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
                                validMappableKeys = new ArrayList<Integer>();
                                for (int keyCode2 : MappableKeys) {
                                    try {
                                        ClientExtensions.keyPressAndRelease(robot, keyCode2);
                                        validMappableKeys.add(keyCode2);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        // empty catch block
                                    }
                                }
                                robot.keyPress(16);
                                i$ = validMappableKeys.iterator();
                                while (i$.hasNext()) {
                                    keyCode = (Integer)i$.next();
                                    ClientExtensions.keyPressAndRelease(robot, keyCode);
                                }
                                robot.keyRelease(16);
                                try {
                                    robot.keyPress(65406);
                                    KeyMap.this.isAltGraphValid = true;
                                }
                                catch (IllegalArgumentException ex) {
                                    if (Extensions.isOnWindows()) {
                                        robot.keyPress(17);
                                        robot.keyPress(18);
                                    }
                                    if (!Extensions.isOnMac()) break block16;
                                    robot.keyPress(18);
                                }
                            }
                            i$ = validMappableKeys.iterator();
                            while (i$.hasNext()) {
                                keyCode = (Integer)i$.next();
                                ClientExtensions.keyPressAndRelease(robot, keyCode);
                            }
                            robot.keyPress(16);
                            i$ = validMappableKeys.iterator();
                            while (i$.hasNext()) {
                                keyCode = (Integer)i$.next();
                                ClientExtensions.keyPressAndRelease(robot, keyCode);
                            }
                            robot.keyRelease(16);
                            if (KeyMap.this.isAltGraphValid) {
                                robot.keyRelease(65406);
                            } else if (Extensions.isOnWindows()) {
                                robot.keyRelease(17);
                                robot.keyRelease(18);
                            } else if (Extensions.isOnMac()) {
                                robot.keyRelease(18);
                            }
                            robot.keyPress(35);
                        }
                        catch (AWTException aWTException) {
                            // empty catch block
                        }
                    }
                });
                frame.addKeyListener(new KeyListener(){

                    public void keyTyped(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                            case 16: 
                            case 17: 
                            case 18: 
                            case 65406: {
                                break;
                            }
                            case 35: {
                                if (timer.isRunning()) {
                                    timer.stop();
                                }
                                frame.dispose();
                                break;
                            }
                            default: {
                                if ((short)e.getKeyChar() == -1) {
                                    return;
                                }
                                Map map = KeyMap.this.charToKeyCodeWithModifiersMap;
                                synchronized (map) {
                                    KeyMap.this.charToKeyCodeWithModifiersMap.put(Character.valueOf(e.getKeyChar()), e.getKeyCode() | e.getModifiers() << 16);
                                }
                                KeyMap.this.trace.traceMessage("%s which makes %c", new Object[]{KeyStroke.getKeyStrokeForEvent(e), Character.valueOf(e.getKeyChar())});
                            }
                        }
                    }
                });
                frame.setUndecorated(true);
                frame.setAlwaysOnTop(true);
                frame.setResizable(false);
                frame.setVisible(true);
                timer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyCodeWithModifiersForChar(char c) {
        Map<Character, Integer> map = this.charToKeyCodeWithModifiersMap;
        synchronized (map) {
            Integer result = this.charToKeyCodeWithModifiersMap.get(Character.valueOf(c));
            return result == null ? -1 : result;
        }
    }

    public static int extractKeyCode(int keyCodeWithModifiers) {
        return keyCodeWithModifiers & 0xFFFF;
    }

    public static int extractModifiers(int keyCodeWithModifiers) {
        return keyCodeWithModifiers >> 16;
    }
}

