/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenURIHandler;
import com.elsitech.screenconnect.ClientLaunchParameters;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Properties;
import com.elsitech.screenconnect.client.Client;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.SwingUtilities;

public class Program {
    public static void main(final String[] args) throws Exception {
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("java.net.useSystemProxies", "true");
        final boolean[] hasRanClient = new boolean[1];
        if (Properties.getUserProperty((String)"screenconnect.mac.uri.handler.register") != null) {
            MacUriHandler.register(new UriHandler(){

                public void handleUri(URI uri) {
                    ClientLaunchParameters clientLaunchParameters = ClientLaunchParameters.fromUrl((String)uri.getHost(), (int)uri.getPort(), (String)uri.getRawPath());
                    Program.runClient(clientLaunchParameters);
                    hasRanClient[0] = true;
                }
            });
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                if (!hasRanClient[0]) {
                    String clientLaunchParametersString = null;
                    String clientLaunchParametersFilename = Properties.getUserProperty((String)"screenconnect.client.launch.parameters.file");
                    if (clientLaunchParametersFilename != null) {
                        try {
                            clientLaunchParametersString = Extensions.readEntireFile((File)new File(clientLaunchParametersFilename), (Charset)StandardCharsets.US_ASCII);
                        }
                        catch (FileNotFoundException e) {
                            Constants.ExceptionTraceSource.traceException((Throwable)e);
                        }
                    }
                    if (clientLaunchParametersString == null) {
                        clientLaunchParametersString = Properties.getUserProperty((String)"screenconnect.client.launch.parameters");
                    }
                    if (clientLaunchParametersString == null) {
                        clientLaunchParametersString = args[0];
                    }
                    ClientLaunchParameters clientLaunchParameters = ClientLaunchParameters.fromQueryString((String)clientLaunchParametersString);
                    Program.runClient(clientLaunchParameters);
                }
            }
        });
    }

    static void runClient(ClientLaunchParameters clientLaunchParameters) {
        Client client = Client.create(clientLaunchParameters);
        client.start(new Runnable(){

            public void run() {
                if (Properties.getUserProperty((String)"screenconnect.client.stop.exit") != null) {
                    System.exit(0);
                }
            }
        });
    }

    private static interface UriHandler {
        public void handleUri(URI var1);
    }

    private static class MacUriHandler {
        private MacUriHandler() {
        }

        static void register(final UriHandler uriHandler) {
            Application.getApplication().setOpenURIHandler(new OpenURIHandler(){

                public void openURI(AppEvent.OpenURIEvent arg0) {
                    URI uri = arg0.getURI();
                    uriHandler.handleUri(uri);
                }
            });
        }
    }
}

