/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.client.ScreenPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class ScreenFrame
extends JFrame {
    private JMenuBar menuBar;
    private JComponent outerPanel;
    private JPanel infoPanelContainer;
    private JScrollPane screenScrollPane;
    private ScreenPanel screenPanel;
    private Listener listener;

    public ScreenFrame() {
        this.setRootPaneCheckingEnabled(false);
        this.setLayout(new OverlayLayout(this));
        this.setRootPaneCheckingEnabled(true);
        this.menuBar = new JMenuBar();
        this.outerPanel = new JComponent(){

            public boolean isOptimizedDrawingEnabled() {
                return false;
            }

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.BLACK);
                Rectangle clipBounds = g.getClipBounds();
                g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            }
        };
        this.outerPanel.setLayout(new OverlayLayout(this.outerPanel){

            public void layoutContainer(Container target) {
                super.layoutContainer(target);
                for (int i = 0; i < target.getComponentCount(); ++i) {
                    Dimension size = target.getComponent(i).getPreferredSize();
                    size.width = Math.min(size.width, target.getWidth());
                    size.height = Math.min(size.height, target.getHeight());
                    int x = target.getWidth() / 2 - size.width / 2;
                    int y = target.getHeight() / 2 - size.height / 2;
                    target.getComponent(i).setBounds(x, y, size.width, size.height);
                }
            }
        });
        this.infoPanelContainer = new JPanel();
        this.infoPanelContainer.setVisible(false);
        this.infoPanelContainer.setBackground(Color.WHITE);
        this.infoPanelContainer.setBorder(new LineBorder(Color.DARK_GRAY, 1));
        this.screenPanel = new ScreenPanel();
        UIManager.getDefaults().put("ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[0]));
        this.screenScrollPane = new JScrollPane(this.screenPanel);
        this.setJMenuBar(this.menuBar);
        this.outerPanel.add(this.infoPanelContainer);
        this.outerPanel.add(this.screenScrollPane);
        this.setContentPane(this.outerPanel);
        this.screenPanel.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent e) {
                if (ScreenFrame.this.listener != null) {
                    ScreenFrame.this.listener.onViewportChanged();
                }
            }
        });
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ScreenFrame.this.listener != null) {
                    ScreenFrame.this.listener.onViewportChanged();
                }
            }
        };
        this.screenScrollPane.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.screenScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
    }

    protected JRootPane createRootPane() {
        return new JRootPane(){

            protected LayoutManager createRootLayout() {
                return new JRootPane.RootLayout(){

                    public Dimension maximumLayoutSize(Container target) {
                        Insets i = this.getInsets();
                        Dimension mbd = menuBar != null && menuBar.isVisible() ? menuBar.getMaximumSize() : new Dimension(0, 0);
                        Dimension rd = contentPane != null ? contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom - mbd.height - 1);
                        return new Dimension(rd.width + i.left + i.right, rd.height + mbd.height + i.top + i.bottom);
                    }
                };
            }
        };
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Dimension getContentSize() {
        return this.outerPanel.getSize();
    }

    public JScrollPane getScreenScrollPane() {
        return this.screenScrollPane;
    }

    public ScreenPanel getScreenPanel() {
        return this.screenPanel;
    }

    public void setInfoPanel(JComponent panel) {
        this.infoPanelContainer.setVisible(panel != null);
        this.infoPanelContainer.removeAll();
        if (panel != null) {
            this.infoPanelContainer.add(panel);
            this.infoPanelContainer.validate();
        }
    }

    public Rectangle getRemoteScreenViewport() {
        Rectangle viewport = this.screenPanel.getVisibleRect();
        Point topLeft = this.screenPanel.transformLocation(viewport.getLocation());
        Point bottomRight = this.screenPanel.transformLocation(new Point(viewport.x + viewport.width, viewport.y + viewport.height));
        return new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
    }

    public static interface Listener {
        public void onViewportChanged();
    }
}

