/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.client;

import com.elsitech.screenconnect.BitmapData;
import com.elsitech.screenconnect.Blittable;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.CoreRect;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.RawBitmapData;
import com.elsitech.screenconnect.client.BufferedImageAdapter;
import com.elsitech.screenconnect.client.ClientExtensions;
import com.elsitech.screenconnect.client.ViewportTransform;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import javax.swing.JPanel;

public class ScreenPanel
extends JPanel
implements Blittable,
ViewportTransform {
    private BufferedImage screenImage;
    private BufferedImageAdapter screenAdapter;
    private Rectangle screenCropBounds;
    private double screenScale;
    private boolean screenEnabled;
    private AffineTransform transform;

    public ScreenPanel() {
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setScreenSize(ClientExtensions.toAwt(Constants.ScreenPanelDefaultSize));
        this.setScreenCropBounds(new Rectangle(new Point(), ClientExtensions.toAwt(Constants.ScreenPanelDefaultSize)));
        this.setScreenScale(1.0);
    }

    public boolean setScreenSize(Dimension size) {
        Extensions.assertArgumentNonNull((Object)size);
        if (this.screenImage == null || size.width != this.screenImage.getWidth() || size.height != this.screenImage.getHeight()) {
            this.screenImage = new BufferedImage(size.width, size.height, 1);
            this.screenAdapter = new BufferedImageAdapter(this.screenImage);
            this.repaint();
            return true;
        }
        return false;
    }

    public Dimension getScreenSize() {
        return new Dimension(this.screenImage.getWidth(), this.screenImage.getHeight());
    }

    public boolean setScreenScale(double scale) {
        if (this.screenScale != scale) {
            this.screenScale = scale;
            this.refreshTransform();
            this.revalidate();
            return true;
        }
        return false;
    }

    public double getScreenScale() {
        return this.screenScale;
    }

    public boolean setScreenCropBounds(Rectangle bounds) {
        Extensions.assertArgumentNonNull((Object)bounds);
        if (this.screenCropBounds == null || !this.screenCropBounds.equals(bounds)) {
            this.screenCropBounds = (Rectangle)Extensions.assertArgumentNonNull((Object)bounds);
            this.refreshTransform();
            this.revalidate();
            return true;
        }
        return false;
    }

    public void setScreenEnabled(boolean enabled) {
        if (enabled != this.screenEnabled) {
            this.screenEnabled = enabled;
            this.repaint();
        }
    }

    public Rectangle getScreenCropBounds() {
        return this.screenCropBounds;
    }

    private void refreshTransform() {
        this.transform = new AffineTransform();
        this.transform.scale(this.screenScale, this.screenScale);
        this.transform.translate(-this.screenCropBounds.x, -this.screenCropBounds.y);
    }

    public BitmapData acquireBitmapData(CoreRect bounds) {
        return this.screenAdapter.crop(bounds);
    }

    public void releaseBitmapData(BitmapData bitmapData) {
        RawBitmapData rawBitmapData = (RawBitmapData)bitmapData;
        CoreRect rect = new CoreRect(rawBitmapData.getX(), rawBitmapData.getY(), rawBitmapData.getWidth(), rawBitmapData.getHeight());
        CoreRect transformedRect = ClientExtensions.transformRect(this.transform, rect);
        this.repaint(ClientExtensions.toAwt(transformedRect));
    }

    public void paintComponent(Graphics g) {
        boolean contentsLost;
        CoreRect repaintRect;
        BufferedImage image = this.screenImage;
        if (!this.screenEnabled) {
            RescaleOp darkener = new RescaleOp(0.5f, 0.0f, null);
            image = darkener.filter(image, null);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        CoreRect imageBounds = new CoreRect(0, 0, image.getWidth(), image.getHeight());
        try {
            repaintRect = ClientExtensions.transformRect(this.transform.createInverse(), ClientExtensions.fromAwt(g.getClipBounds())).inflateWithinBounds(2, imageBounds);
        }
        catch (NoninvertibleTransformException e) {
            Constants.ExceptionTraceSource.traceException((Throwable)e);
            repaintRect = imageBounds;
        }
        do {
            VolatileImage volatileImage = this.getGraphicsConfiguration().createCompatibleVolatileImage(repaintRect.width, repaintRect.height);
            Graphics2D volatileImageGraphics = volatileImage.createGraphics();
            volatileImageGraphics.drawImage(image, 0, 0, repaintRect.width, repaintRect.height, repaintRect.x, repaintRect.y, repaintRect.x + repaintRect.width, repaintRect.y + repaintRect.height, null);
            AffineTransform volatileImageTransform = AffineTransform.getTranslateInstance(repaintRect.x, repaintRect.y);
            volatileImageTransform.preConcatenate(this.transform);
            ((Graphics2D)g).drawImage(volatileImage, volatileImageTransform, null);
            contentsLost = volatileImage.contentsLost();
            volatileImageGraphics.dispose();
            volatileImage.flush();
        } while (contentsLost);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public double getScreenScaleForPreferredWidth(int preferredWidth) {
        return (double)preferredWidth / (double)this.screenCropBounds.width;
    }

    public double getScreenScaleForPreferredHeight(int preferredHeight) {
        return (double)preferredHeight / (double)this.screenCropBounds.height;
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = (Dimension)this.screenCropBounds.getSize().clone();
        preferredSize.width = (int)Math.round((double)preferredSize.width * this.screenScale);
        preferredSize.height = (int)Math.round((double)preferredSize.height * this.screenScale);
        return preferredSize;
    }

    public Point transformLocation(Point location) {
        try {
            Point2D transformedLocation = this.transform.inverseTransform(new Point2D.Double(location.x, location.y), null);
            return new Point((int)Math.round(transformedLocation.getX()), (int)Math.round(transformedLocation.getY()));
        }
        catch (NoninvertibleTransformException ex) {
            return new Point();
        }
    }
}

