/*
 * Decompiled with CFR 0.152.
 */
package com.elsitech.screenconnect.bootstrapper;

import com.elsitech.screenconnect.ClientLaunchParameters;
import com.elsitech.screenconnect.Constants;
import com.elsitech.screenconnect.Extensions;
import com.elsitech.screenconnect.Properties;
import com.elsitech.screenconnect.TraceSource;
import com.elsitech.screenconnect.client.Client;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoader;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.UUID;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;

public class Program {
    public static void main(String[] args) throws Exception {
        ClientLaunchParameters clp = ClientLaunchParameters.fromQueryString((String)args[0]);
        try {
            Program.runDotNetClient(clp);
        }
        catch (Throwable ex) {
            Constants.ExceptionTraceSource.traceException(ex);
            Program.runJavaClient(clp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runDotNetClient(ClientLaunchParameters clp) throws Exception {
        File exeDir;
        TraceSource trace = Extensions.createTraceSource(Program.class);
        trace.traceMessage("Starting trying to run .NET client...", new Object[0]);
        try {
            String exeDirPath;
            BasicService serviceManager = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = serviceManager.getCodeBase();
            URL url = new URL(codeBase, "Bin/Elsinore.ScreenConnect.Client.exe.jar");
            try {
                trace.traceMessage("Trying to use resource provider to get exe directory...", new Object[0]);
                exeDirPath = ResourceProvider.get().getLibraryDirForJar("Elsinore.ScreenConnect.WindowsClient.exe", url, null);
            }
            catch (Throwable ex) {
                Constants.ExceptionTraceSource.traceException(ex);
                trace.traceMessage("Trying to use download engine to get exe directory...", new Object[0]);
                Method downloadEngineMethod = DownloadEngine.class.getMethod("getLibraryDirForJar", String.class, URL.class, String.class);
                exeDirPath = (String)downloadEngineMethod.invoke(null, "Elsinore.ScreenConnect.WindowsClient.exe", url, null);
            }
            exeDir = new File(exeDirPath);
        }
        catch (Throwable ex) {
            Constants.ExceptionTraceSource.traceException(ex);
            trace.traceMessage("Trying to use launch download native directorys to get exe directory...", new Object[0]);
            Method launchDownloadMethod = LaunchDownload.class.getMethod("getNativeDirectories", LaunchDesc.class);
            JNLPClassLoader jnlpClassLoader = (JNLPClassLoader)Program.class.getClassLoader();
            LaunchDesc launchDesc = jnlpClassLoader.getLaunchDesc();
            File[] directories = (File[])launchDownloadMethod.invoke(null, launchDesc);
            exeDir = directories[0];
        }
        if (exeDir.getAbsolutePath().contains("Low")) {
            trace.traceMessage("Detected that we're running in a 'Low' directory...", new Object[0]);
            String systemTempDirectoryPath = System.getProperty("java.io.tmpdir");
            File productTempDirectoryPath = new File(systemTempDirectoryPath, "ScreenConnect");
            File versionTempDirectoryPath = new File(productTempDirectoryPath, Program.class.getPackage().getImplementationVersion());
            File instanceTempDirectoryPath = new File(versionTempDirectoryPath, UUID.nameUUIDFromBytes(clp.encryptionKey).toString());
            trace.traceMessage("Trying to copy files outside of 'Low' directory...", new Object[0]);
            Extensions.copyFiles((File)exeDir, (File)instanceTempDirectoryPath, (boolean)false);
            exeDir = instanceTempDirectoryPath;
        }
        for (String fileName : Properties.getResourceNames()) {
            if (fileName.contains("/")) continue;
            trace.traceMessage("Processing stream for file: %s", new Object[]{fileName});
            File file = new File(exeDir, fileName);
            FileOutputStream fileStream = null;
            InputStream contentStream = null;
            try {
                file.createNewFile();
                fileStream = new FileOutputStream(file);
                contentStream = Properties.openResourceStream((String)fileName);
                Extensions.writeTo((InputStream)contentStream, (OutputStream)fileStream);
            }
            catch (FileNotFoundException ex) {
                Constants.ExceptionTraceSource.traceException((Throwable)ex);
            }
            finally {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (contentStream == null) continue;
                contentStream.close();
            }
        }
        String exePath = new File(exeDir, "Elsinore.ScreenConnect.WindowsClient.exe").getAbsolutePath();
        String[] commandArray = new String[]{exePath, clp.originalQueryString};
        Runtime.getRuntime().exec(commandArray);
    }

    private static void runJavaClient(ClientLaunchParameters clp) throws Exception {
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("java.net.useSystemProxies", "true");
        Client client = Client.create((ClientLaunchParameters)clp);
        client.start(new Runnable(){

            public void run() {
                System.exit(0);
            }
        });
    }
}

