﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="oldVersion" />

	<!-- basic identity transform -->
	<xsl:template priority="-9" match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- data newlines because we're filtering other elements -->
	<xsl:template priority="-5" match="//data">
		<xsl:text>&#xD;&#xA;  </xsl:text>
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- additions -->
	<xsl:template match="/root">
		<xsl:copy>
			<xsl:apply-templates select="*[not(self::data)]" />

			<xsl:apply-templates select="data">
				<xsl:sort select="@name" />
			</xsl:apply-templates>

			<!-- 3.1 -->
			<xsl:if test="count(data[@name='AppearancePanel.ClientResourcesLabelText']) = 0" xml:space="preserve">
  <data name="AppearancePanel.ClientResourcesLabelText" xml:space="preserve">
    <value>Client Resources:</value>
  </data>
  <data name="AppearancePanel.WebResourcesLabelText" xml:space="preserve">
    <value>Web Resources:</value>
  </data>
  <data name="EmailAuthenticationProviderBodyFormat" xml:space="preserve">
    <value />
  </data>
  <data name="EmailAuthenticationProviderSubjectFormat" xml:space="preserve">
    <value>Your one-time password is: {0} (EOM)</value>
  </data>
  <data name="Launcher.WebStartTitle" xml:space="preserve">
    <value>ScreenConnect Client</value>
  </data>
  <data name="Launcher.WebStartVendor" xml:space="preserve">
    <value>Elsinore Technologies, Inc.</value>
  </data>
  <data name="LoginPanel.ButtonText" xml:space="preserve">
    <value>Login</value>
  </data>
  <data name="LoginPanel.FailureText" xml:space="preserve">
    <value>Your login attempt was not successful. Please try again.</value>
  </data>
  <data name="LoginPanel.OneTimePasswordLabelText" xml:space="preserve">
    <value>One-Time Password:</value>
  </data>
  <data name="LoginPanel.OneTimePasswordMessage" xml:space="preserve">
    <value>Your user account requires an additional authentication step.</value>
  </data>
  <data name="LoginPanel.PasswordLabelText" xml:space="preserve">
    <value>Password:</value>
  </data>
  <data name="LoginPanel.RememberMeText" xml:space="preserve">
    <value>Remember me next time.</value>
  </data>
  <data name="LoginPanel.UserNameLabelText" xml:space="preserve">
    <value>User Name:</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='Launcher.InstallPrompt']) = 0" xml:space="preserve">
  <data name="Launcher.InstallPrompt" xml:space="preserve">
    <value>The mobile app must be installed before proceeding.

Click OK to confirm it is installed.

Click Cancel to install. Rejoin the session after installation.</value>
  </data>
			</xsl:if>

			<!-- 3.2 -->
			<xsl:if test="count(data[@name='SessionJoinPanel.LaunchMessage']) = 0" xml:space="preserve">
  <data name="SessionJoinPanel.LaunchMessage" xml:space="preserve">
    <value>Launch With:</value>
  </data>
			</xsl:if>

			<!-- 3.3 -->
			<xsl:if test="count(data[@name='AuditPanel.TimeFormat']) = 0" xml:space="preserve">
  <data name="AuditPanel.TimeFormat" xml:space="preserve">
    <value>{0}</value>
  </data>
  <data name="InvitePanel.CommunicateUrlVisible" xml:space="preserve">
    <value>true</value>
  </data>
  <data name="InvitePanel.ComposeEmailVisible" xml:space="preserve">
    <value>true</value>
  </data>
  <data name="InvitePanel.SendEmailVisible" xml:space="preserve">
    <value>true</value>
  </data>
			</xsl:if>

			<!-- 3.4 -->
			<xsl:if test="count(data[@name='PhoneticAlphabet.A']) = 0" xml:space="preserve">
  <data name="PhoneticAlphabet.0" xml:space="preserve">
    <value>Zero</value>
  </data>
  <data name="PhoneticAlphabet.1" xml:space="preserve">
    <value>One</value>
  </data>
  <data name="PhoneticAlphabet.2" xml:space="preserve">
    <value>Two</value>
  </data>
  <data name="PhoneticAlphabet.3" xml:space="preserve">
    <value>Three</value>
  </data>
  <data name="PhoneticAlphabet.4" xml:space="preserve">
    <value>Four</value>
  </data>
  <data name="PhoneticAlphabet.5" xml:space="preserve">
    <value>Five</value>
  </data>
  <data name="PhoneticAlphabet.6" xml:space="preserve">
    <value>Six</value>
  </data>
  <data name="PhoneticAlphabet.7" xml:space="preserve">
    <value>Seven</value>
  </data>
  <data name="PhoneticAlphabet.8" xml:space="preserve">
    <value>Eight</value>
  </data>
  <data name="PhoneticAlphabet.9" xml:space="preserve">
    <value>Niner</value>
  </data>
  <data name="PhoneticAlphabet.A" xml:space="preserve">
    <value>Alfa</value>
  </data>
  <data name="PhoneticAlphabet.B" xml:space="preserve">
    <value>Bravo</value>
  </data>
  <data name="PhoneticAlphabet.C" xml:space="preserve">
    <value>Charlie</value>
  </data>
  <data name="PhoneticAlphabet.D" xml:space="preserve">
    <value>Delta</value>
  </data>
  <data name="PhoneticAlphabet.E" xml:space="preserve">
    <value>Echo</value>
  </data>
  <data name="PhoneticAlphabet.F" xml:space="preserve">
    <value>Foxtrot</value>
  </data>
  <data name="PhoneticAlphabet.G" xml:space="preserve">
    <value>Golf</value>
  </data>
  <data name="PhoneticAlphabet.H" xml:space="preserve">
    <value>Hotel</value>
  </data>
  <data name="PhoneticAlphabet.I" xml:space="preserve">
    <value>India</value>
  </data>
  <data name="PhoneticAlphabet.J" xml:space="preserve">
    <value>Juliett</value>
  </data>
  <data name="PhoneticAlphabet.K" xml:space="preserve">
    <value>Kilo</value>
  </data>
  <data name="PhoneticAlphabet.L" xml:space="preserve">
    <value>Lima</value>
  </data>
  <data name="PhoneticAlphabet.M" xml:space="preserve">
    <value>Mike</value>
  </data>
  <data name="PhoneticAlphabet.N" xml:space="preserve">
    <value>November</value>
  </data>
  <data name="PhoneticAlphabet.O" xml:space="preserve">
    <value>Oscar</value>
  </data>
  <data name="PhoneticAlphabet.P" xml:space="preserve">
    <value>Papa</value>
  </data>
  <data name="PhoneticAlphabet.Q" xml:space="preserve">
    <value>Quebec</value>
  </data>
  <data name="PhoneticAlphabet.R" xml:space="preserve">
    <value>Romeo</value>
  </data>
  <data name="PhoneticAlphabet.S" xml:space="preserve">
    <value>Sierra</value>
  </data>
  <data name="PhoneticAlphabet.T" xml:space="preserve">
    <value>Tango</value>
  </data>
  <data name="PhoneticAlphabet.U" xml:space="preserve">
    <value>Uniform</value>
  </data>
  <data name="PhoneticAlphabet.V" xml:space="preserve">
    <value>Victor</value>
  </data>
  <data name="PhoneticAlphabet.W" xml:space="preserve">
    <value>Whiskey</value>
  </data>
  <data name="PhoneticAlphabet.X" xml:space="preserve">
    <value>Xray</value>
  </data>
  <data name="PhoneticAlphabet.Y" xml:space="preserve">
    <value>Yankee</value>
  </data>
  <data name="PhoneticAlphabet.Z" xml:space="preserve">
    <value>Zulu</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='HostPanel.SearchBoxPlaceholderText']) = 0" xml:space="preserve">
  <data name="HostPanel.SearchBoxPlaceholderText" xml:space="preserve">
    <value>search</value>
  </data>
			</xsl:if>

			<!-- 4.0 -->
			<xsl:if test="count(data[@name='SessionPanel.PropertyKeepOption']) = 0" xml:space="preserve">
  <data name="SessionPanel.PropertyKeepOption" xml:space="preserve">
    <value>Do Not Change</value>
  </data>
  <data name="SessionPanel.PropertyMachineNameOption" xml:space="preserve">
    <value>Use Machine Name</value>
  </data>
  <data name="SessionPanel.PropertySpecifyOption" xml:space="preserve">
    <value>Use Specific Value:</value>
  </data>
  <data name="InvitePanel.DoneButtonText" xml:space="preserve">
    <value>Done</value>
  </data>
  <data name="InvitePanel.Title" xml:space="preserve">
    <value>Invite Guest</value>
  </data>
  <data name="LogoPanel.IconUrl" xml:space="preserve">
    <value>~/Images/LogoIcon.png</value>
  </data>
  <data name="ManageSessionGroupsPanel.DeleteButtonText" xml:space="preserve">
    <value>✖</value>
  </data>
  <data name="ManageSessionGroupsPanel.Instructions" xml:space="preserve">
    <value>The Session Filter syntax is very similar to the SQL "where" clause syntax. Properties, operators, literals, variables, and functions can be combined to create powerful expressions.&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Available properties:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;SessionID&lt;/b&gt;: The unique ID of the session in GUID (Globally Unique Identifier) format&lt;br /&gt;
- &lt;b&gt;Name&lt;/b&gt;: The name of the session&lt;br /&gt;
- &lt;b&gt;Host&lt;/b&gt;: The user name of the host of the session&lt;br /&gt;
- &lt;b&gt;IsPublic&lt;/b&gt;: A flag indicating whether the session is public&lt;br /&gt;
- &lt;b&gt;Code&lt;/b&gt;: The access code for the session, if defined&lt;br /&gt;
- &lt;b&gt;Notes&lt;/b&gt;: A semicolon-delimited list of all notes added to the session&lt;br /&gt;
- &lt;b&gt;HostConnectedCount&lt;/b&gt;: The number of hosts connected to the session&lt;br /&gt;
- &lt;b&gt;GuestConnectedCount&lt;/b&gt;: The number of guests connected to the session&lt;br /&gt;
- &lt;b&gt;CustomPropertyN&lt;/b&gt;: The value of custom property N, where N is 1-8&lt;br /&gt;
- &lt;b&gt;GuestLoggedOnUserDomain&lt;/b&gt;: The domain of the user logged onto the guest machine&lt;br /&gt;
- &lt;b&gt;GuestLoggedOnUserName&lt;/b&gt;: The name of the user logged onto the guest machine&lt;br /&gt;
- &lt;b&gt;GuestLastActivityTime&lt;/b&gt;: The time of last activity on the guest machine&lt;br /&gt;
- &lt;b&gt;GuestMachineDomain&lt;/b&gt;: The domain or workgroup of the guest machine&lt;br /&gt;
- &lt;b&gt;GuestMachineName&lt;/b&gt;: The name of the guest machine&lt;br /&gt;
- &lt;b&gt;GuestOperatingSystemName&lt;/b&gt;: The name of the operating system of the guest machine&lt;br /&gt;
- &lt;b&gt;GuestOperatingSystemVersion&lt;/b&gt;: The version of the guest operating system, in N.N.N.N notation&lt;br /&gt;
- &lt;b&gt;GuestProcessorName&lt;/b&gt;: The name of the processor on the guest machine&lt;br /&gt;
- &lt;b&gt;GuestProcessorVirtualCount&lt;/b&gt;: The number of virtual processors on the guest machine&lt;br /&gt;
- &lt;b&gt;GuestSystemMemoryTotalMegabytes&lt;/b&gt;: The total system memory on the guest machine, in megabytes&lt;br /&gt;
- &lt;b&gt;GuestSystemMemoryAvailableMegabytes&lt;/b&gt;: The available system memory on the guest machine, in megabytes&lt;br /&gt;
- &lt;b&gt;GuestClientVersion&lt;/b&gt;: The version of client software on the guest machine, in N.N.N.N notation&lt;br /&gt;
- &lt;b&gt;GuestNetworkAddress&lt;/b&gt;: The network address of the guest machine, usually in N.N.N.N IPv4 notation&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Available operators:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;AND&lt;/b&gt;: Combines two expressions and matches if they are both true&lt;br /&gt;
- &lt;b&gt;OR&lt;/b&gt;: Combines two expressions and matches if one or both is true&lt;br /&gt;
- &lt;b&gt;NOT&lt;/b&gt;: Negates an expression or operator&lt;br /&gt;
- &lt;b&gt;=&lt;/b&gt;: Determines whether two values are equal&lt;br /&gt;
- &lt;b&gt;&amp;lt&amp;gt;&lt;/b&gt;: Determines whether two values are not equal&lt;br /&gt;
- &lt;b&gt;&amp;lt;&lt;/b&gt;: Determines whether one value is less than another value&lt;br /&gt;
- &lt;b&gt;&amp;gt;&lt;/b&gt;: Determines whether one value is greater than another value&lt;br /&gt;
- &lt;b&gt;&amp;lt=&lt;/b&gt;: Determines whether one value is less than or equal to another value&lt;br /&gt;
- &lt;b&gt;&amp;gt;=&lt;/b&gt;: Determines whether one value is greater than or equal to another value&lt;br /&gt;
- &lt;b&gt;IN&lt;/b&gt;: Used to see if a property is in a set of values&lt;br /&gt;
- &lt;b&gt;LIKE&lt;/b&gt;: Used to compare strings, usually with wildcards (* and % are both valid)&lt;br /&gt;
- &lt;b&gt;+&lt;/b&gt;: Add two values together&lt;br /&gt;
- &lt;b&gt;-&lt;/b&gt;: Subtract one value from another&lt;br /&gt;
- &lt;b&gt;*&lt;/b&gt;: Multiply two values together&lt;br /&gt;
- &lt;b&gt;/&lt;/b&gt;: Divide one value by another&lt;br /&gt;
- &lt;b&gt;%&lt;/b&gt;: Mod one value by another&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Available variables:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;$USERNAME&lt;/b&gt;: User name of the currently logged-in user, pre-quoted&lt;br /&gt;
- &lt;b&gt;$SERVERVERSION&lt;/b&gt;: The version of this product running on the server, pre-quoted&lt;br /&gt;
- &lt;b&gt;$OTHERAND&lt;/b&gt;: AND'ed-together expression of session filters of other filtered session groups not containing an $OTHER variable&lt;br /&gt;
- &lt;b&gt;$OTHEROR&lt;/b&gt;: OR'ed-together expression of session filters of other filtered session groups not containing an $OTHER variable&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Available functions:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;LEN(expression)&lt;/b&gt;: Return the length of a string&lt;br /&gt;
- &lt;b&gt;IIF(expression, trueResult, falseResult)&lt;/b&gt;: Return one of two values depending on whether the expression is true or false&lt;br /&gt;
- &lt;b&gt;ISNULL(expression, resultIfNull)&lt;/b&gt;: Return the value of the expression or another value if the expression returns null&lt;br /&gt;
- &lt;b&gt;TRIM(expression)&lt;/b&gt;: Trim whitespace from the beginning and end of a string&lt;br /&gt;
- &lt;b&gt;SUBSTRING(expression, start, length)&lt;/b&gt;: Get part of a string&lt;br /&gt;
- &lt;b&gt;CONVERT(expression, type)&lt;/b&gt;: Explicity convert between datatypes&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Literals:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;Strings&lt;/b&gt;: Quoted with single quote character ('); escape single quotes inside the string with two consecutive single quotes&lt;br /&gt;
- &lt;b&gt;Numbers&lt;/b&gt;: All numbers can be used without quoting or any other special notation&lt;br /&gt;
- &lt;b&gt;Dates/Times&lt;/b&gt;: Quoted with single quote character (') or number sign (#)&lt;br /&gt;
- &lt;b&gt;Booleans&lt;/b&gt;: Use "true" or "false", unquoted&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Other usage notes:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- Parentheses can be used for readability and to enforce operator precedence&lt;br /&gt;
- Wildcards (* and %) can only be used at the beginning or end of a LIKE expression, but not in the middle&lt;br /&gt;
- No properties will ever be NULL, but rather empty strings&lt;br /&gt;
&lt;br /&gt;
&lt;b&gt;Examples:&lt;/b&gt;&lt;br /&gt;
&lt;br /&gt;
- &lt;b&gt;Name LIKE 'CompanyA*'&lt;/b&gt;: Sessions where the name starts with "CompanyA"&lt;br /&gt;
- &lt;b&gt;Name LIKE '*CompanyA*'&lt;/b&gt;: Sessions where the name contains "CompanyA"&lt;br /&gt;
- &lt;b&gt;Name LIKE '*CompanyA'&lt;/b&gt;: Sessions where the name ends with "CompanyA"&lt;br /&gt;
- &lt;b&gt;Host = $USERNAME&lt;/b&gt;: Sessions where the host is the current user&lt;br /&gt;
- &lt;b&gt;Notes LIKE '*server*'&lt;/b&gt;: Sessions where the notes contain the word "server"&lt;br /&gt;
- &lt;b&gt;(Name LIKE 'CompanyA%') AND (Notes LIKE '*server*')&lt;/b&gt;: Sessions where the name starts with "CompanyA" and the notes contain the word "server"&lt;br /&gt;
- &lt;b&gt;$OTHEROR&lt;/b&gt;: Sessions that are in another session group&lt;br /&gt;
- &lt;b&gt;NOT $OTHEROR&lt;/b&gt;: Sessions that are not in another session group&lt;br /&gt;
- &lt;b&gt;HostConnectedCount &amp;gt; 0 AND GuestConnectedCount &amp;gt; 0&lt;/b&gt;: Sessions where both a host and a guest are connected&lt;br /&gt;
- &lt;b&gt;HostConnectedCount = 0 AND GuestConnectedCount &amp;gt; 0&lt;/b&gt;: Sessions where just a guest is connected&lt;br /&gt;
- &lt;b&gt;HostConnectedCount &amp;gt; GuestConnectedCount&lt;/b&gt;: Sessions where more hosts are connected than guests&lt;br /&gt;
- &lt;b&gt;IsPublic = true&lt;/b&gt;: Sessions that are public&lt;br /&gt;
- &lt;b&gt;LEN(Code) &gt; 0&lt;/b&gt;: Sessions that have a code&lt;br /&gt;
- &lt;b&gt;IsPublic = false AND LEN(Code) = 0&lt;/b&gt;: Sessions that aren't public and don't have a code&lt;br /&gt;
- &lt;b&gt;Notes LIKE '*' + $USERNAME + '*'&lt;/b&gt;: Sessions that contain the current user name in the notes&lt;br /&gt;
- &lt;b&gt;Host IN ('Bill', 'Bob', 'Sarah')&lt;/b&gt;: Sessions where host is either Bill, Bob, or Sarah&lt;br /&gt;
- &lt;b&gt;SUBSTRING(Name, 5, 4) = 'TEST'&lt;/b&gt;: Sessions where characters 5-9 of the name are "TEST" (work-around for no wildcards in the middle)&lt;br /&gt;</value>
  </data>
  <data name="ManageSessionGroupsPanel.Message" xml:space="preserve">
    <value>Use Session Groups to dynamically organize your sessions. In addition to improved navigability, Session Groups can also be used by Security roles in the Administration area to limit access for particular users.</value>
  </data>
  <data name="ManageSessionGroupsPanel.MoveDownButtonText" xml:space="preserve">
    <value>⇩</value>
  </data>
  <data name="ManageSessionGroupsPanel.MoveUpButtonText" xml:space="preserve">
    <value>⇧</value>
  </data>
  <data name="ManageSessionGroupsPanel.NewButtonText" xml:space="preserve">
    <value>⏎</value>
  </data>
  <data name="ManageSessionGroupsPanel.ShowReferenceButtonText" xml:space="preserve">
    <value>Show Reference</value>
  </data>
  <data name="ManageSessionGroupsPanel.Title" xml:space="preserve">
    <value>Manage Session Groups</value>
  </data>
  <data name="NavigationPanel.AdministrationLinkText" xml:space="preserve">
    <value>Admin</value>
  </data>
  <data name="NavigationPanel.GuestLinkText" xml:space="preserve">
    <value>Guest</value>
  </data>
  <data name="NavigationPanel.HostLinkText" xml:space="preserve">
    <value>Host</value>
  </data>
  <data name="SessionProperty.ClientVersion.LabelText" xml:space="preserve">
    <value>Client Version:</value>
  </data>
  <data name="SessionProperty.Code.LabelText" xml:space="preserve">
    <value>Code:</value>
  </data>
  <data name="SessionProperty.Code.ValueFormat" xml:space="preserve">
    <value>{0} ({1})</value>
  </data>
  <data name="SessionProperty.Custom1.AccessVisible" xml:space="preserve">
    <value>true</value>
  </data>
  <data name="SessionProperty.Custom1.LabelText" xml:space="preserve">
    <value>Organization:</value>
  </data>
  <data name="SessionProperty.Custom1.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom1.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom2.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom2.LabelText" xml:space="preserve">
    <value>Custom Property 2:</value>
  </data>
  <data name="SessionProperty.Custom2.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom2.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom3.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom3.LabelText" xml:space="preserve">
    <value>Custom Property 3:</value>
  </data>
  <data name="SessionProperty.Custom3.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom3.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom4.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom4.LabelText" xml:space="preserve">
    <value>Custom Property 4:</value>
  </data>
  <data name="SessionProperty.Custom4.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom4.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom5.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom5.LabelText" xml:space="preserve">
    <value>Custom Property 5:</value>
  </data>
  <data name="SessionProperty.Custom5.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom5.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom6.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom6.LabelText" xml:space="preserve">
    <value>Custom Property 6:</value>
  </data>
  <data name="SessionProperty.Custom6.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom6.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom7.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom7.LabelText" xml:space="preserve">
    <value>Custom Property 7:</value>
  </data>
  <data name="SessionProperty.Custom7.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom7.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom8.AccessVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom8.LabelText" xml:space="preserve">
    <value>Custom Property 8:</value>
  </data>
  <data name="SessionProperty.Custom8.MeetingVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.Custom8.SupportVisible" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionProperty.FalseText" xml:space="preserve">
    <value>No</value>
  </data>
  <data name="SessionProperty.GuestInfoUpdateTime.ValueFormat" xml:space="preserve">
    <value>Last updated {0} ago</value>
  </data>
  <data name="SessionProperty.GuestsConnected.LabelText" xml:space="preserve">
    <value>Guests Connected:</value>
  </data>
  <data name="SessionProperty.GuestsConnected.ValueFormat" xml:space="preserve">
    <value>{0} ({1})</value>
  </data>
  <data name="SessionProperty.Host.LabelText" xml:space="preserve">
    <value>Host:</value>
  </data>
  <data name="SessionProperty.HostsConnected.LabelText" xml:space="preserve">
    <value>Hosts Connected:</value>
  </data>
  <data name="SessionProperty.HostsConnected.ValueFormat" xml:space="preserve">
    <value>{0} ({1})</value>
  </data>
  <data name="SessionProperty.IdleTime.LabelText" xml:space="preserve">
    <value>Idle Time:</value>
  </data>
  <data name="SessionProperty.IdleTime.ValueFormat" xml:space="preserve">
    <value>{0}</value>
  </data>
  <data name="SessionProperty.IsPublic.LabelText" xml:space="preserve">
    <value>Published:</value>
  </data>
  <data name="SessionProperty.JoinMode.LabelText" xml:space="preserve">
    <value>Join Mode:</value>
  </data>
  <data name="SessionProperty.LoggedOnUser.LabelText" xml:space="preserve">
    <value>Logged On User:</value>
  </data>
  <data name="SessionProperty.Machine.LabelText" xml:space="preserve">
    <value>Machine:</value>
  </data>
  <data name="SessionProperty.Name.LabelText" xml:space="preserve">
    <value>Name:</value>
  </data>
  <data name="SessionProperty.NetworkAddress.LabelText" xml:space="preserve">
    <value>Network Address:</value>
  </data>
  <data name="SessionProperty.OperatingSystem.LabelText" xml:space="preserve">
    <value>Operating System:</value>
  </data>
  <data name="SessionProperty.OperatingSystem.ValueFormat" xml:space="preserve">
    <value>{0} ({1})</value>
  </data>
  <data name="SessionProperty.Processor.LabelText" xml:space="preserve">
    <value>Processor(s):</value>
  </data>
  <data name="SessionProperty.Processor.ValueFormat" xml:space="preserve">
    <value>{0} ({1} virtual)</value>
  </data>
  <data name="SessionProperty.SystemMemory.LabelText" xml:space="preserve">
    <value>Available Memory:</value>
  </data>
  <data name="SessionProperty.SystemMemory.ValueFormat" xml:space="preserve">
    <value>{1} MB / {0} MB</value>
  </data>
  <data name="SessionProperty.TrueText" xml:space="preserve">
    <value>Yes</value>
  </data>
  <data name="Command.AddNote.ButtonText" xml:space="preserve">
    <value>Add Note</value>
  </data>
  <data name="Command.AddNote.Message" xml:space="preserve">
    <value>Add notes to log work or provide identification for sessions.</value>
  </data>
  <data name="Command.AddNote.PlaceholderText" xml:space="preserve">
    <value>Enter a note</value>
  </data>
  <data name="Command.AddNote.Text" xml:space="preserve">
    <value>Add Note…</value>
  </data>
  <data name="Command.ChangePassword.Text" xml:space="preserve">
    <value>Change Password</value>
  </data>
  <data name="Command.Check.CheckText" xml:space="preserve">
    <value>Check:</value>
  </data>
  <data name="Command.Check.WhereText" xml:space="preserve">
    <value>Or Where:</value>
  </data>
  <data name="Command.CheckAll.Text" xml:space="preserve">
    <value>All</value>
  </data>
  <data name="Command.CheckBoth.Text" xml:space="preserve">
    <value>Both Connected</value>
  </data>
  <data name="Command.CheckNeither.Text" xml:space="preserve">
    <value>Neither Connected</value>
  </data>
  <data name="Command.CheckNone.Text" xml:space="preserve">
    <value>None</value>
  </data>
  <data name="Command.CheckOnlyGuest.Text" xml:space="preserve">
    <value>Only Guest Connected</value>
  </data>
  <data name="Command.CheckOnlyHost.Text" xml:space="preserve">
    <value>Only Host Connected</value>
  </data>
  <data name="Command.Edit.Text" xml:space="preserve">
    <value>Edit</value>
  </data>
  <data name="Command.End.Text" xml:space="preserve">
    <value>End</value>
  </data>
  <data name="Command.Help.Text" xml:space="preserve">
    <value>Help</value>
  </data>
  <data name="Command.Invite.Text" xml:space="preserve">
    <value>Invite…</value>
  </data>
  <data name="Command.Join.Text" xml:space="preserve">
    <value>Join</value>
  </data>
  <data name="Command.Login.Text" xml:space="preserve">
    <value>Login</value>
  </data>
  <data name="Command.Logout.Text" xml:space="preserve">
    <value>Logout</value>
  </data>
  <data name="Command.More.Text" xml:space="preserve">
    <value>More ▽</value>
  </data>
  <data name="Command.Reinstall.ButtonText" xml:space="preserve">
    <value>Reinstall</value>
  </data>
  <data name="Command.Reinstall.Message" xml:space="preserve">
    <value>Reinstall will attempt to upgrade the software of the remote machine to the current version. It will be processed at the time the machine is connected without a host connected.</value>
  </data>
  <data name="Command.Reinstall.Text" xml:space="preserve">
    <value>Reinstall…</value>
  </data>
  <data name="Command.RunCommand.ButtonText" xml:space="preserve">
    <value>Run Command</value>
  </data>
  <data name="Command.RunCommand.Message" xml:space="preserve">
    <value>Run commands on the remote systems. Results from the commands are viewable on each session.</value>
  </data>
  <data name="Command.RunCommand.PlaceholderText" xml:space="preserve">
    <value>Enter a command</value>
  </data>
  <data name="Command.RunCommand.Text" xml:space="preserve">
    <value>Run Command…</value>
  </data>
  <data name="Command.SelectCommands.Text" xml:space="preserve">
    <value>Commands</value>
  </data>
  <data name="Command.SelectGeneral.Text" xml:space="preserve">
    <value>General</value>
  </data>
  <data name="Command.SelectMessages.Text" xml:space="preserve">
    <value>Messages</value>
  </data>
  <data name="Command.SelectNotes.Text" xml:space="preserve">
    <value>Notes</value>
  </data>
  <data name="Command.SelectTimeline.Text" xml:space="preserve">
    <value>Timeline</value>
  </data>
  <data name="Command.SendMessage.ButtonText" xml:space="preserve">
    <value>Send Message</value>
  </data>
  <data name="Command.SendMessage.Message" xml:space="preserve">
    <value>Send messages to the remote systems. The messages will appear to the user in the client software.</value>
  </data>
  <data name="Command.SendMessage.PlaceholderText" xml:space="preserve">
    <value>Enter a message</value>
  </data>
  <data name="Command.SendMessage.Text" xml:space="preserve">
    <value>Send Message…</value>
  </data>
  <data name="Command.Transfer.ButtonText" xml:space="preserve">
    <value>Transfer Sessions</value>
  </data>
  <data name="Command.Transfer.Message" xml:space="preserve">
    <value>Transfer sessions to a different host.</value>
  </data>
  <data name="Command.Transfer.Text" xml:space="preserve">
    <value>Transfer…</value>
  </data>
  <data name="Command.Uninstall.ButtonText" xml:space="preserve">
    <value>Uninstall</value>
  </data>
  <data name="Command.Uninstall.Message" xml:space="preserve">
    <value>This will attempt to remove the client software from remote machine. It will be processed at the time the machine is connected without a host connected.</value>
  </data>
  <data name="Command.Uninstall.Text" xml:space="preserve">
    <value>Uninstall…</value>
  </data>
  <data name="Command.UpdateGuestInfo.Text" xml:space="preserve">
    <value>Update Guest Info</value>
  </data>
  <data name="Command.UserMore.Text" xml:space="preserve">
    <value>{0} ▽</value>
  </data>
  <data name="Command.Wake.ButtonText" xml:space="preserve">
    <value>Wake</value>
  </data>
  <data name="Command.Wake.Message" xml:space="preserve">
    <value>Wake will trigger Wake-on-LAN signals from other machines on the same network as this machine. The machine will wake from sleep if the machine is configured for Wake-on-LAN.</value>
  </data>
  <data name="Command.Wake.Text" xml:space="preserve">
    <value>Wake…</value>
  </data>
  <data name="CreateSessionPanel.ButtonText" xml:space="preserve">
    <value>Create Session</value>
  </data>
  <data name="CreateSessionPanel.JoinNowText" xml:space="preserve">
    <value>Join Now</value>
  </data>
  <data name="CreateSessionPanel.MeetingTitle" xml:space="preserve">
    <value>Create Meeting Session</value>
  </data>
  <data name="CreateSessionPanel.SupportTitle" xml:space="preserve">
    <value>Create Support Session</value>
  </data>
  <data name="EditSessionsPanel.ButtonText" xml:space="preserve">
    <value>Save Sessions</value>
  </data>
  <data name="EditSessionsPanel.Title" xml:space="preserve">
    <value>Edit Sessions</value>
  </data>
  <data name="HostPanel.GuestAnonymousName" xml:space="preserve">
    <value>Guest</value>
  </data>
  <data name="ChangePasswordPanel.CancelButtonText" xml:space="preserve">
    <value>Cancel</value>
  </data>
  <data name="ChangePasswordPanel.ChangePasswordButtonText" xml:space="preserve">
    <value>Change Password</value>
  </data>
  <data name="ChangePasswordPanel.ConfirmNewPasswordLabelText" xml:space="preserve">
    <value>Confirm New Password:</value>
  </data>
  <data name="ChangePasswordPanel.ContinueButtonText" xml:space="preserve">
    <value>Continue</value>
  </data>
  <data name="ChangePasswordPanel.CurrentPasswordLabelText" xml:space="preserve">
    <value>Password:</value>
  </data>
  <data name="ChangePasswordPanel.Heading" xml:space="preserve">
    <value>Change Password</value>
  </data>
  <data name="ChangePasswordPanel.NewPasswordLabelText" xml:space="preserve">
    <value>New Password:</value>
  </data>
  <data name="ChangePasswordPanel.SuccessText" xml:space="preserve">
    <value>Password successfully changed.</value>
  </data>
  <data name="SessionInfoPanel.NotesVisibleIfPresent" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionInfoPanel.CustomPropertyLabelFormat" xml:space="preserve">
    <value>{0} {1}</value>
  </data>
  <data name="SessionInfoPanel.GuestClientVersionLabelFormat" xml:space="preserve">
    <value>Client Version: {0}</value>
  </data>
  <data name="SessionInfoPanel.GuestClientVersionVisibleIfOutOfDate" xml:space="preserve">
    <value>true</value>
  </data>
  <data name="SessionInfoPanel.GuestClientVersionVisibleIfPresent" xml:space="preserve">
    <value>false</value>
  </data>
  <data name="SessionInfoPanel.GuestLoggedOnUserActiveLabelFormat" xml:space="preserve">
    <value>User: {1} (Active)</value>
  </data>
  <data name="SessionInfoPanel.GuestLoggedOnUserIdleLabelFormat" xml:space="preserve">
    <value>User: {1} (Idle {2})</value>
  </data>
  <data name="SessionInfoPanel.GuestLoggedOnUserIdleThresholdSeconds" xml:space="preserve">
    <value>600</value>
  </data>
  <data name="SessionInfoPanel.GuestLoggedOnUserIdleUnknownLabelFormat" xml:space="preserve">
    <value>User: {1}</value>
  </data>
  <data name="SessionInfoPanel.GuestLoggedOnUserVisibleIfPresent" xml:space="preserve">
    <value>true</value>
  </data>
  <data name="SessionInfoPanel.GuestOperatingSystemLabelFormat" xml:space="preserve">
    <value>OS: {0} ({1})</value>
  </data>
  <data name="SessionInfoPanel.GuestOperatingSystemVisibleIfPresent" xml:space="preserve">
    <value>false</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='LicensePanel.UpgradeLicenseButtonText']) = 0" xml:space="preserve">
  <data name="LicensePanel.UpgradeLicenseButtonText" xml:space="preserve">
    <value>Add or Upgrade Licenses</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='LogoPanel.IconVisible']) = 0" xml:space="preserve">
  <data name="LogoPanel.IconVisible" xml:space="preserve">
    <value><xsl:value-of select="//data[@name='LogoPanel.ImageUrl']/value/text() = '~/Images/Logo.png'" /></value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='BuildInstallerPanel.DownloadButtonText']) = 0" xml:space="preserve">
  <data name="BuildInstallerPanel.DownloadButtonText" xml:space="preserve">
    <value>Download Installer</value>
  </data>
  <data name="BuildInstallerPanel.InstallerType.00.msi" xml:space="preserve">
    <value>Windows (.msi)</value>
  </data>
  <data name="BuildInstallerPanel.InstallerType.01.exe" xml:space="preserve">
    <value>Windows (.exe)</value>
  </data>
  <data name="BuildInstallerPanel.InstallerType.02.pkg" xml:space="preserve">
    <value>Mac OS X (.pkg)</value>
  </data>
  <data name="BuildInstallerPanel.InstallerType.03.deb" xml:space="preserve">
    <value>Debian Linux (.deb)</value>
  </data>
  <data name="BuildInstallerPanel.InstallerType.04.rpm" xml:space="preserve">
    <value>Red Hat Linux (.rpm)</value>
  </data>
  <data name="BuildInstallerPanel.InstallerTypeLabelText" xml:space="preserve">
    <value>Type:</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='SessionHelpPanel.InstructionsHeading']) = 0" xml:space="preserve">
  <data name="SessionHelpPanel.InstructionsGuestCodeFormat" xml:space="preserve">
    <value>Instruct your guest to navigate to "&lt;a href="{0}" target="_blank"&gt;{0}&lt;/a&gt;" and type in the code "{2}", spelled "{3}".</value>
  </data>
  <data name="SessionHelpPanel.InstructionsGuestInvitationOnlyFormat" xml:space="preserve">
    <value>Click the "Invite..." button above to send an invitation to your guest(s).</value>
  </data>
  <data name="SessionHelpPanel.InstructionsGuestPublicFormat" xml:space="preserve">
    <value>Instruct your guest to navigate to "&lt;a href="{0}" target="_blank"&gt;{0}&lt;/a&gt;" and click on the session named "{1}".</value>
  </data>
  <data name="SessionHelpPanel.InstructionsHeading" xml:space="preserve">
    <value>Connect to your Guest</value>
  </data>
  <data name="SessionHelpPanel.InstructionsHostFormat" xml:space="preserve">
    <value>Join the session yourself by clicking the "Join" button above or double-clicking on the session in the table above.</value>
  </data>
  <data name="SessionProperty.JoinMode.InvitationOnlyFormat" xml:space="preserve">
    <value>Invitation Only</value>
  </data>
  <data name="SessionProperty.JoinMode.PublishedFormat" xml:space="preserve">
    <value>Published</value>
  </data>
  <data name="SessionProperty.JoinMode.CodeFormat" xml:space="preserve">
    <value>Code: {1}</value>
  </data>
			</xsl:if>

			<!-- 4.1 -->
			<xsl:if test="count(data[@name='Command.End.Message']) = 0" xml:space="preserve">
  <data name="Command.End.Message" xml:space="preserve">
    <value>End will remove the sessions from this view. You and your guests will be disconnected from the session and will be unable to join in the future.</value>
  </data>
  <data name="Command.End.ButtonText" xml:space="preserve">
    <value>End</value>
  </data>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<!-- key changes -->

	<!-- 4.0 -->
	<xsl:template match="//@name[.='ConnectedPanel.Heading']">
		<xsl:attribute name="name">ConnectedPanel.Title</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='ErrorPanel.Heading']">
		<xsl:attribute name="name">ErrorPanel.Title</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='JoinPanel.Heading']">
		<xsl:attribute name="name">JoinPanel.Title</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='BuildInstallerPanel.Heading']">
		<xsl:attribute name="name">BuildInstallerPanel.Title</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionGroupPanel.NameHeader']">
		<xsl:attribute name="name">ManageSessionGroupsPanel.NameHeader</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionGroupPanel.SessionFilterHeader']">
		<xsl:attribute name="name">ManageSessionGroupsPanel.SessionFilterHeader</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionGroupPanel.ButtonText']">
		<xsl:attribute name="name">ManageSessionGroupsPanel.ButtonText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='LinkPanel.HelpLink.Host.aspx']">
		<xsl:attribute name="name">UserPanel.HelpLink.Host</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='LinkPanel.HelpLink.Guest.aspx']">
		<xsl:attribute name="name">UserPanel.HelpLink.Guest</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='LinkPanel.HelpLink.Administration.aspx']">
		<xsl:attribute name="name">UserPanel.HelpLink.Administration</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeInvitationOnlyText']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeInvitationOnlyText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeInvitationOnlyVisible']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeInvitationOnlyVisible</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeLabelText']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeLabelText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModePublicText']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModePublicText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModePublicVisible']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModePublicVisible</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeSecureCodeText']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeSecureCodeText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeSecureCodeVisible']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeSecureCodeVisible</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeSimpleCodeText']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeSimpleCodeText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='SessionPanel.JoinModeSimpleCodeVisible']">
		<xsl:attribute name="name">SessionPanel.PropertyJoinModeSimpleCodeVisible</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='LogoPanel.ImageAlternateText']">
		<xsl:attribute name="name">LogoPanel.AlternateText</xsl:attribute>
	</xsl:template>
	<xsl:template match="//@name[.='LogoPanel.IconImageUrl']">
		<xsl:attribute name="name">LogoPanel.IconUrl</xsl:attribute>
	</xsl:template>

	<!-- value changes -->

	<!-- 3.1 -->
	<xsl:template match="text()[.='Go to the web address below to join the session:&#xD;&#xA;{1}']">Go to the web address below to join:&#xD;&#xA;{1}</xsl:template>
	<xsl:template match="text()[.='{0}_{1}_{2:yyyy-MM-dd}']">{0}_{1:yyyy-MM-dd}</xsl:template>

	<!-- 3.4 -->
	<xsl:template match="text()[starts-with(., 'ScreenConnect checked the the URL')]">ScreenConnect checked the URL you are currently using in your browser address bar. This URL should be universal and work the same for users on the server, on the local network, or over the internet.&lt;br /&gt;&#xD;&#xA;&lt;br /&gt;&#xD;&#xA;Using a universal URL is required for sending an email invitation, or the user will be directed to a page non-existent to them. It is also good practice for general use considering the common need to access ScreenConnect from an off-site location.&lt;br /&gt;&#xD;&#xA;&lt;br /&gt;&#xD;&#xA;Possible URLs are listed that may work for your installation. The success of these depend on your network configuration and whether the External Accessibility Check passed.</xsl:template>
	<xsl:template match="text()[starts-with(., 'ScreenConnect checked the the external')]">ScreenConnect checked the external accessibility of your installation. For internet users to access your installation, network gateways such as routers and firewalls must forward specific traffic to ScreenConnect.&lt;br /&gt;&#xD;&#xA;&lt;br /&gt;&#xD;&#xA;ScreenConnect attempts to automatically configure these gateways using Universal Plug and Play (UPnP) and the Internet Gateway Device (IGD) protocol. However, this often fails for a variety of reasons, requiring you to forward the traffic manually.</xsl:template>

	<!-- 4.0 -->
	<xsl:template match="text()[.='manage session groups']">Manage Session Groups</xsl:template>
	<xsl:template match="text()[.='I Agree, Join the Session']">I Agree, Join Session</xsl:template>
	<xsl:template match="text()[.='Join the Meeting']">Join Meeting</xsl:template>
	<xsl:template match="*[@name='BuildInstallerPanel.Paragraph1Message']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">Build an installer to deploy to remote machines. This permanently installs the client software on the remote machine. The client software will connect back and appear in your list of Access sessions.</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='BuildInstallerPanel.Paragraph2Message']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">Provide values to identify the machines when they first appear in your list:</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='BuildInstallerPanel.Paragraph3Message']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">These values can be changed later once the sessions are in your list.</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='AuditPanel.AuditEntryEventFormat']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">Event: {0}, Host: {1}, Data: {2}</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='HostPanel.AccessEmptyMessage']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">&lt;h2&gt;No Access Sessions Found&lt;/h2&gt;&#xD;&#xA;&lt;p&gt;Use access sessions to provide indefinite access to familiar computers.&lt;/p&gt;&#xD;&#xA;&lt;p&gt;Click the "+" symbol next to the "Access" heading on the left sidebar to get started.&lt;/p&gt;</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='HostPanel.MeetingEmptyMessage']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">&lt;h2&gt;No Meeting Sessions Found&lt;/h2&gt;&#xD;&#xA;&lt;p&gt;Use meeting sessions for presentations or gatherings.&lt;/p&gt;&#xD;&#xA;&lt;p&gt;Click the "+" symbol next to the "Meet" heading on the left sidebar to get started.&lt;/p&gt;</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*[@name='HostPanel.SupportEmptyMessage']/value/text()">
		<xsl:choose>
			<xsl:when test="number($oldVersion) &lt; 4.0">&lt;h2&gt;No Support Sessions Found&lt;/h2&gt;&#xD;&#xA;&lt;p&gt;Create support sessions to provide immediate support for any computer on the internet.&lt;/p&gt;&#xD;&#xA;&lt;p&gt;Click the "+" symbol next to the "Support" heading on the left sidebar to get started.&lt;/p&gt;</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()[.='Role Names must match Windows Group Names. A case-insensitive comparison is performed, first attempting to comparing the Role Name to &quot;DomainOrComputer\Group&quot;, then falling back to compare to the &quot;Group&quot; portion.']">Role Names must match Windows Group Names. A case-insensitive comparison is performed, first attempting to compare the Role Name to "DomainOrComputer\Group", then falling back to compare to the "Group" portion.</xsl:template>
	<xsl:template match="text()[.='&lt;b&gt;Published:&lt;/b&gt; Guest selects the session from list']">&lt;b&gt;Published:&lt;/b&gt; Guest selects the session from a list</xsl:template>
	<xsl:template match="text()[.='Audit everything in Basic Auditing.  In addition stores all captured screen activity from every session. Captures are downloadable as video files. WARNING: Consumes significant disk space.']">Audit everything in Basic Auditing. In addition, stores all captured screen activity from every session. Captures are downloadable as video files. WARNING: Consumes significant disk space.</xsl:template>
	<xsl:template match="text()[.='This will attempt to remove the client software from remote machine. It will be processed at the time the machine is connected without a host connected.']">This will attempt to remove the client software from the remote machine. It will be processed at the time the machine is connected without a host connected.</xsl:template>
	<xsl:template match="text()[.='No valid licenses. You may need to delete licenses in order to fix.']">No valid licenses. You may need to delete licenses in order to fix this.</xsl:template>
	<xsl:template match="text()[.='Redhat Linux (.rpm)']">Red Hat Linux (.rpm)</xsl:template>

	<!-- 4.1 -->
	<xsl:template match="text()[.='&lt;b&gt;No sessions found.&lt;/b&gt;&lt;br /&gt;&lt;br /&gt; Please select a valid session group.']">&lt;h2&gt;No Sessions Found&lt;/h2&gt;&#xD;&#xA;&lt;p&gt;Please select a valid session group on the left sidebar.&lt;/p&gt;</xsl:template>
	<xsl:template match="text()[.='The mobile app must be installed before proceeding.&#xA;&#xA;Click OK to confirm it is installed.&#xA;&#xA;Click Cancel to install. Rejoin the session after installation.']" xml:space="preserve">The ScreenConnect client application must be installed before proceeding.&#xD;&#xA;&#xD;&#xA;Click OK to confirm it is installed.&#xD;&#xA;&#xD;&#xA;Click Cancel to install. Rejoin the session after installation.</xsl:template>

	<xsl:template match="text()[.='Reinstall…']">Reinstall</xsl:template>
	<xsl:template match="text()[.='Uninstall…']">Uninstall</xsl:template>
	<xsl:template match="text()[.='Wake…']">Wake</xsl:template>
	<xsl:template match="text()[.='Transfer Sessions']">Transfer</xsl:template>
	<xsl:template match="text()[.='This will attempt to remove the client software from the remote machine. It will be processed at the time the machine is connected without a host connected.']">Uninstall will attempt to remove the client software from the remote machine. It will be processed at the time the machine is connected without a host connected.</xsl:template>

	<!-- removals -->

	<!-- 3.1 -->
	<xsl:template match="*[@name = 'AppearancePanel.ResourceStringsLabelText']" />
	<xsl:template match="*[@name = 'Client.ApplicationTitle']" />
	<xsl:template match="*[@name = 'Launcher.AndroidPrompt']" />
	<xsl:template match="*[@name = 'Launcher.iOSPrompt']" />

	<!-- 3.2 -->
	<xsl:template match="*[@name = 'Launcher.WebStartTitle']" />
	<xsl:template match="*[@name = 'Launcher.WebStartVendor']" />

	<!-- 3.4 -->
	<xsl:template match="*[@name = 'BuildInstallerPanel.DownloadMacButtonText']" />
	<xsl:template match="*[@name = 'BuildInstallerPanel.DownloadWindowsExeButtonText']" />
	<xsl:template match="*[@name = 'BuildInstallerPanel.DownloadWindowsMsiButtonText']" />

	<!-- 4.0 -->
	<xsl:template match="*[starts-with(@name, 'LinkPanel.Guest')]" />
	<xsl:template match="*[starts-with(@name, 'LinkPanel.Host')]" />
	<xsl:template match="*[starts-with(@name, 'LinkPanel.Administration')]" />
	<xsl:template match="*[starts-with(@name, 'LinkPanel.Log')]" />
	<xsl:template match="*[starts-with(@name, 'LinkPanel.Link')]" />
	<xsl:template match="*[starts-with(@name, 'LinkPanel.HelpLinkText')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.NameLabelText')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.Instructions')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.AccessSessionHeading')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.CodeLabelText')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.Default')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.Message')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.Move')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.New')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.Instructions')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.Delete')]" />
	<xsl:template match="*[starts-with(@name, 'SessionEventType.')]" />
	<xsl:template match="*[starts-with(@name, 'SessionPanel.SessionLog')]" />
	<xsl:template match="*[starts-with(@name, 'ProcessType.')]" />
	<xsl:template match="*[starts-with(@name, 'ReinstallPanel.')]" />
	<xsl:template match="*[starts-with(@name, 'SessionButtonPanel.')]" />
	<xsl:template match="*[starts-with(@name, 'SelectSessionsPanel.')]" />
	<xsl:template match="*[starts-with(@name, 'SessionGroupPanel.Heading')]" />
	<xsl:template match="*[starts-with(@name, 'SessionInfoPanel.DurationLabelFormat')]" />
	<xsl:template match="*[@name = 'UserPanel.Message']" />
	<xsl:template match="*[@name = 'SessionTransferPanel.Message']" />
	<xsl:template match="*[@name = 'SessionPanel.SupportSessionHeading']" />
	<xsl:template match="*[@name = 'SessionPanel.SavingMessage']" />
	<xsl:template match="*[@name = 'SessionPanel.SavedMessage']" />
	<xsl:template match="*[@name = 'SessionPanel.PublicLabelText']" />
	<xsl:template match="*[@name = 'SessionPanel.MeetingSessionHeading']" />
	<xsl:template match="*[@name = 'BuildInstallerPanel.Paragraph4Message']" />
	<xsl:template match="*[@name = 'HostPanel.AccessButtonText']" />
	<xsl:template match="*[@name = 'HostPanel.MeetingButtonText']" />
	<xsl:template match="*[@name = 'HostPanel.SupportButtonText']" />
	<xsl:template match="*[@name = 'BuildInstallerPanel.LabelDefault']" />
	<xsl:template match="*[@name = 'Launcher.AndroidInstallUrl']" />
	<xsl:template match="*[@name = 'Launcher.iOSInstallUrl']" />
	<xsl:template match="*[@name = 'AppearancePanel.UploadButtonText']" />
	<xsl:template match="*[starts-with(@name, 'BuildInstallerPanel.DownloadButtonText.')]" />
	<xsl:template match="*[@name = 'SessionInfoPanel.JoinModeCodeFormat']" />
	<xsl:template match="*[@name = 'SessionInfoPanel.JoinModeInvitationOnlyFormat']" />
	<xsl:template match="*[@name = 'SessionInfoPanel.JoinModePublishedFormat']" />
	<xsl:template match="*[@name = 'SessionProperty.Code.LabelText']" />
	<xsl:template match="*[@name = 'SessionProperty.IsPublic.LabelText']" />
	<xsl:template match="*[@name = 'SessionProperty.FalseText']" />
	<xsl:template match="*[@name = 'SessionProperty.TrueText']" />
</xsl:stylesheet>